/* NVClock 0.5 beta - Linux overclocker for NVIDIA cards
 *
 * site: http://nvclock.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define MAX_CARDS 4

#include <sys/mman.h> 
#include <sys/types.h> 
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>

struct pci_ids {
    int   id;
    char *name;
    int   mem_min;
    int   mem_max;
    int   nv_min;
    int   nv_max;
    int   supported;
};

struct card {
    int flags;
    int bus;
    int slot;
    int vendor_id;
    int device_id;
    int irq;
    unsigned int reg_address;
    unsigned int reg_size;
    unsigned int fb_address;
    unsigned int fb_size;
    char *device_string;
    int mem;
    int number;
    int supported;
    int memclk_min; 
    int memclk_max; 
    int nvclk_min; 
    int nvclk_max; 
};


#ifdef __cplusplus
extern "C" {
#endif
    
    int ChangeSpeeds(float memclk, float nvclk, int card_number, int debug);
    int GetSpeed(float *memclk, float *nvclk, int card_number, int debug);
    const struct pci_ids *GetCardInfo(int card_number);
    int CheckDriver();
    int FindAllCards_ioctl();
    int FindAllCards_proc();
    extern struct card card[MAX_CARDS];
    extern int root;

#define NVIDIA_IOCTL_MAGIC      'F'
#define NVIDIA_IOCTL_CARD_INFO_FLAG_PRESENT       0x0001
#define NVIDIA_CARD_INFO      _IOWR(NVIDIA_IOCTL_MAGIC, 2, sizeof(void *))

#ifdef __cplusplus    
};
#endif
