/* dummycons.c - testing driver, ala dummyups, but with no X requirement

   Copyright (C) 2001  Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/termios.h>

/* TODO: this may need to be much bigger */
#define INFO_MAX 64

#include "config.h"
#include "proto.h"
#include "shared.h"
#include "shared-tables.h"
#include "version.h"
#include "upscommon.h"
#include "common.h"

	int	info_max = INFO_MAX;

void initinfo (void)
{
	create_info(info_max, 1);

	/* setup the basics */

	addinfo(INFO_MFR, "Console testing", 0, 0);
	addinfo(INFO_MODEL, "Dummy UPS", 0, 0);
	addinfo(INFO_STATUS, "OL", 0, 0);
}

#if 0
/* install pointers to functions for msg handlers called from msgparse */
void setuphandlers()
{
	/* TODO: future */
}
#endif

void do_help(void)
{
	printf("Network UPS Tools dummycons help\n\n");
	printf("? / h / help	- show this help\n");
	printf("a / add VAR VAL	- add variable VAR with value VAL\n");
	printf("l / list	- show current variables in use\n");
	printf("L / List	- show all possible variables and settings\n");
	printf("s / set VAR VAL - set variable VAR to VAL\n");
	printf("q / quit	- quit\n");
	printf("\n");
	printf("Values can use \"quotes\" to store values with embedded spaces.\n");
}

void do_set(char *var, char *val)
{
	int	i;
	char	*dp = NULL;

	if ((!var) || (!val)) {
		printf("Error: need variable and desired values as arguments.\n");
		return;
	}

	for (i = 0; netvars[i].name != NULL; i++)
		if (!strcasecmp(netvars[i].name, var)) {
			dp = getdata(netvars[i].type);

			if (!dp) {
				printf("Error: %s doesn't exist yet.  (Use 'add' before calling set)\n",
					var);
				return;
			}

			printf("INFO_%s = %s\n", netvars[i].name, val);
			setinfo(netvars[i].type, "%s", val);
			return;
		}

	printf("Error: %s unrecognized.\n", var);
}

void do_list(int all)
{
	int	i;
	char	*dp, vn[50];

	for (i = 0; netvars[i].name != NULL; i++) {
		dp = getdata(netvars[i].type);

		snprintf(vn, sizeof(vn), "INFO_%s (%s)", netvars[i].name,
			netvars[i].desc);

		if (!dp) {
			if (all) {
				printf("%-50s = (undefined)\n", vn);
			}
		}
		else
			printf("%-50s = %s\n", vn, dp);
	}
}	

/* for future cleanup activities */
void do_quit(void)
{
	exit(0);
}

void do_add(char *var, char *val)
{
	int	i;

	if ((!var) || (!val)) {
		printf("Error: need variable and desired values as arguments.\n");
		return;
	}

	/* TODO: handle special types (enums, etc) */
	for (i = 0; netvars[i].name != NULL; i++) {
		if (!strcasecmp(netvars[i].name, var)) {
			addinfo(netvars[i].type, val, 0, 0);
			printf("INFO_%s = %s\n", netvars[i].name, val);
			return;
		}
	}

	printf("Error: %s unrecognized.\n", var);
}

void fake_shutdown(void)
{
	printf("dummycons: not a driver, nothing to shutdown...\n");
	exit(0);
}

void help(char *progname)
{
	printf("Dummy UPS driver - for testing and development\n\n");

	printf("usage: %s [-h]\n", progname);
	printf("       %s -k <portname>\n", progname);
	printf("       %s [-m <num>] [-k] <portname>\n\n", progname);

	printf("  -h		- display this help\n");
	printf("  -k		- fake a shutdown\n");
	printf("  -m <num>	- allow <num> items to be added\n");
	printf("  <portname>	- fake port name (for state file)\n");

	exit(0);
}

/* trivia: parseline used to be parseconf, but only dummycons needs it now */

/* split up buf into a number of substrings, returning pointers in arg */
int parseline(char *buf, char **arg, int numargs)
{
	char	*ptr, *ws;
	int	i, buflen, an, state;

	an = state = 0;
	ws = NULL;

	buflen = strlen (buf);
	ptr = buf;

	/* yes, it's a state machine! be afraid! */

	for (i = 0; i < buflen; i++) {
		switch (state) {
			case 0:		/* scan */
				if (*ptr == '"') {
					ws = ptr + 1; 	/* start after quote */
					state = 1;	/* goto quotecollect */
					break;
				}

				if (isspace((unsigned char)ptr[0]))
					break;		/* loop */

				if (*ptr == '\\') {	/* literal as start */
					if (i == (buflen - 1)) {
						upslogx(LOG_NOTICE,
						"\\ at end of line!");
						return 0;	/* failure */
					}

					ws = ptr;

					/* shift string to the left */
					memmove(ptr, ptr+1, buflen-i);

					/* fix length */
					buflen--;

					state = 2;	/* goto collect */
					break;
				}

				/* handle comments - # means we're done */
				if (*ptr == '#') {
					*ptr = '\0';
					buflen = i;
					break;
				}

				if (!isspace((unsigned char)ptr[0])) {
					ws = ptr;
					state = 2;	/* goto collect */
					break;
				}
			
				break;

			case 1:		/* quotecollect */
				if (ptr[0] == '"')
					state = 3;	/* goto save */

				if (ptr[0] == '\\') {	/* literal handling */
					if (i == (buflen - 1)) {
						upslogx(LOG_NOTICE,
						"\\ at end of line!");
						return 0;	/* failure */
					}

					/* shift string to the left */
					memmove(ptr, ptr+1, buflen-i);

					/* fix length */
					buflen--;

					break;
				}

				/* a comment here means a broken string */
				if (ptr[0] == '#') {
					upslogx(LOG_NOTICE,
                                                "Unbalanced quotes due to embedded comment!");
                                                return 0;       /* failure */
				}

				break;			/* loop */

			case 2:		/* collect */
				if (ptr[0] == '\\') {	/* literal handling */
					if (i == (buflen - 1)) {
						upslogx(LOG_NOTICE,
						"\\ at end of line!");
						return 0;	/* failure */
					}

					/* shift string to the left */
					memmove(ptr, ptr+1, buflen-i);

					/* fix length */
					buflen--;
					break;		/* loop */
				}

				/* handle comments - # means we're done */
				if (ptr[0] == '#') {
					ptr[0] = '\0';
					buflen = i;
					break;
				}

				if (!isspace((unsigned char)ptr[0]))
					break;		/* loop */

				state = 3;		/* goto save */
		}

		if (state == 3) {		/* save */
			if (an < numargs)
				arg[an++] = ws;
			ptr[0] = '\0';
			ws = NULL;
			state = 0;
		}

		ptr++;
	}

	if (state == 1)		/* end-of-string in state 1 == missing quote */
		upslogx(LOG_NOTICE, "Unbalanced \" in line");

	if (state == 2) {	/* catch last word when exiting from collect */
		ptr[0] = '\0';
		if (an < numargs)
			arg[an++] = ws;
	}

	/* zap any leftover pointers */
	for (i = an; i < numargs; i++)
		arg[i] = NULL;

	/* safety catch: don't allow all nulls back as 'success' */
	if (arg[0] == NULL)
		return 0;	/* FAILED (don't parse this) */

	return 1;	/* success */
}

int main(int argc, char **argv)
{
	int	res, i;
	char	buf[128], *portname, *prog;
	char	*arg[3];

	printf("Network UPS Tools - Dummy console UPS driver 0.10 (%s)\n", UPS_VERSION);

	prog = argv[0];

	while ((i = getopt(argc, argv, "+hkm:")) != EOF) {
		switch(i) {
			case 'k':
				fake_shutdown();
				break;

			case 'm':
				info_max = atoi(optarg);
				break;

			case 'h':
				help(prog);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc != 1)
		portname = "null";
	else
		portname = argv[0];

	snprintf(statefn, sizeof(statefn), "%s/dummycons-%s", STATEPATH, portname);

	printf("State file: %s\n", statefn);

	droproot();
	initinfo();

	printf("Command (? for help): ");
	fflush(stdout);

	for (;;) {
		struct	timeval	tv;
		fd_set	rfd;		

		tv.tv_sec = 2;
		tv.tv_usec = 0;
		FD_ZERO(&rfd);
		FD_SET(fileno(stdin), &rfd);

		res = select(fileno(stdin) + 1, &rfd, NULL, NULL, &tv);

		if (res < 0)
			fatal("select");

		/* idle loop */
		if (res == 0) {
			writeinfo();
			continue;
		}

		fgets(buf, sizeof(buf), stdin);

		if (!strncmp(buf, "?", 1))
			do_help();

		/* split into usable chunks */
		res = parseline(buf, arg, 3);

		if (res < 1)
			continue;

		if (!strcmp(arg[0], "set"))
			do_set(arg[1], arg[2]);

		if (!strcmp(arg[0], "s"))
			do_set(arg[1], arg[2]);

		if (!strcmp(arg[0], "quit"))
			do_quit();

		if (!strcmp(arg[0], "q"))
			do_quit();

		if (!strcmp(arg[0], "list"))
			do_list(0);

		if (!strcmp(arg[0], "l"))
			do_list(0);

		if (!strcmp(arg[0], "List"))
			do_list(1);

		if (!strcmp(arg[0], "L"))
			do_list(1);

		if (!strcmp(arg[0], "help"))
			do_help();

		if (!strcmp(arg[0], "h"))
			do_help();

		if (!strcmp(arg[0], "a"))
			do_add(arg[1], arg[2]);

		if (!strcmp(arg[0], "add"))
			do_add(arg[1], arg[2]);

		writeinfo();

		printf("Command (? for help): ");
		fflush(stdout);

	}	/* for (;;) */
}
