/* shared-tables.h - tables of info from shared.h, but 
   prolly only used for info output/parsing

   Copyright (C) 2000 Russell Kroll <rkroll@exploits.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/* Originally in upsd.h, separated out because I wanted the text
   strings while working on table driven stuff in the apc-smart
   module
	Nigel Metheringham <Nigel.Metheringham@vdata.co.uk>
*/

/* netvars[] - map text strings from the network to internal identifiers */

struct netvars_t {
	char	*name;
	int	type;
	char	*desc;
}	netvars[] =
{
	{ "MFR",	INFO_MFR,	"Manufacturer"		},
	{ "MODEL",	INFO_MODEL,	"Model"			},
	{ "SERIAL",	INFO_SERIAL,	"Serial number"		},
	{ "UTILITY",	INFO_UTILITY,	"Utility voltage"	},
	{ "BATTPCT",	INFO_BATTPCT,	"Battery percentage"	},
	{ "STATUS",	INFO_STATUS,	"Status"		},
	{ "UPSTEMP",	INFO_UPSTEMP,	"UPS temperature"	},
	{ "ACFREQ",	INFO_ACFREQ,	"AC frequency"		},
	{ "LOADPCT",	INFO_LOADPCT,	"Load percentage"	},
	{ "LOWXFER", 	INFO_LOWXFER,	"Low transfer voltage"	},
	{ "HIGHXFER",	INFO_HIGHXFER,	"High transfer voltage"	},
	{ "AMBHUMID",	INFO_AMBHUMID,	"Ambient humidity"	},
	{ "AMBTEMP",	INFO_AMBTEMP,	"Ambient temperature"	},
	{ "CONTACTS",   INFO_CONTACTS,  "Dry contacts"		},
	{ "UPSIDENT",	INFO_UPSIDENT,	"UPS identification"	},
	{ "WAKEDELAY",	INFO_WAKEDELAY,	"Wake-up delay"		},
	{ "LINESENS",	INFO_LINESENS,	"Line sensitivity"	},
	{ "WAKETHRSH",	INFO_WAKETHRSH,	"Battery powerup thres" },
	{ "REQVOLT",	INFO_REQVOLT,	"Requested output volts"},
	{ "LOBATTIME",	INFO_LOBATTIME,	"Battery time before LB"},
	{ "PDNGRACE",	INFO_PDNGRACE,	"Delay on powerdown"	},
	{ "ALRMDELAY",	INFO_ALRMDELAY,	"Delay before alert"	}, 
	{ "SLFTSTINT",	INFO_SLFTSTINT,	"Selftest intervals"	},
	{ "FIRMREV",	INFO_FIRMREV,	"Firmware revision" 	},
	{ "OUTVOLT",	INFO_OUTVOLT,	"Output voltage"	},
	{ "REG1",	INFO_REG1,	"Register 1"		},
	{ "REG2",	INFO_REG2,	"Register 2"		},
	{ "REG3",	INFO_REG3,	"Register 3"		},
	{ "LINEQUAL",	INFO_LINEQUAL,	"Line quality"		},
	{ "BATTPACKS",	INFO_BATTPACKS,	"Installed battery packs"	},
	{ "BATTVOLT",	INFO_BATTVOLT,	"Current battery voltage"	},
	{ "XFERWHY",	INFO_XFERWHY,	"Reason for last transfer"	},
	{ "MAXUTIL",	INFO_MAXUTIL,	"Max utility voltage seen"	},
	{ "MINUTIL",	INFO_MINUTIL,	"Min utility voltage seen"	},
	{ "SLFTSTRES",	INFO_SLFTSTRES,	"Last self test result"		},
	{ "RUNTIME",	INFO_RUNTIME,	"Predicted runtime on batt"	},
	{ "MFRDATE",	INFO_MFRDATE,	"Manufacturing date"	},
	{ "BATTDATE",	INFO_BATTDATE,	"Battery change date"	},
	{ "TEMPMAX",	INFO_TEMPMAX,	"Max temperature setting"	},
	{ "TEMPMIN",	INFO_TEMPMIN,	"Min temperature setting"	},
	{ "HUMDMAX",	INFO_HUMDMAX,	"Max humidity setting"	},
	{ "HUMDMIN",	INFO_HUMDMIN,	"Min humidity setting"	},
	{ "FIRMREV1",	INFO_FIRMREV1,	"Firmware revision (more)"	},
	{ "FIRMREV2",	INFO_FIRMREV2,	"Firmware revision (aux device)"},
	{ "NOMBATVLT",	INFO_NOMBATVLT,	"Nominal battery voltage"	},
	{ "COPYRIGHT",	INFO_COPYRIGHT,	"UPS F/W Copyright Info"	},
	{ "DIPSWCH",	INFO_DIPSWCH,	"DIPSWCH"	},
	{ "OUTVLTSEL",	INFO_OUTVLTSEL,	"Output voltage selection"	},
	{ "CURRENT",	INFO_CURRENT,	"Output Load Current"	},
	{ "LOADPWR",	INFO_LOADPWR,	"Apparent load power %"	},
	{ "LANGUAGE",	INFO_LANGUAGE,	"Front panel language"	},
	{ "BADPACKS",	INFO_BADPACKS,	"Bad battery packs installed"	},
	{ "ALRMENA",	INFO_ALRMENA,	"Alarm enable"		},
	{ "ALRMSTAT",	INFO_ALRMSTAT,	"Alarm status"		},
	{ "AMBTEMP2",	INFO_AMBTEMP2,	"AMBTEMP2"		},
	{ "AMBHUMID2",	INFO_AMBHUMID2,	"AMBHUMID2"		},
	{ "GRACEDELAY",	INFO_GRACEDELAY,"Shutdown delay"	},
	{ "RTHRESH",	INFO_RTHRESH,	"Return Threshold"	},
	{ "ALRMDEL",	INFO_ALRMDEL,	"Alarm Delay"		},
	/* the 89 sec varables */
	{ "ALRM_PWRWAIT",	INFO_ALRM_PWRWAIT,	"Alarm Awaiting Power"	},
	{ "ALRM_BADBYPASS",	INFO_ALRM_BADBYPASS,	"Alarm Bypass Bad"	},
	{ "ALRM_CHARGFAIL",	INFO_ALRM_CHARGFAIL,	"Alarm Charger Failure"	},
	{ "ALRM_FANFAIL",	INFO_ALRM_FANFAIL,	"Alarm Fan Failure"	},
	{ "ALRM_FUSEFAIL",	INFO_ALRM_FUSEFAIL,	"Alarm Fuse Failure"	},
	{ "ALRM_GENERAL",	INFO_ALRM_GENERAL,	"Alarm General Fault"	},
	{ "ALRM_BADINPUT",	INFO_ALRM_BADINPUT,	"Alarm Input Bad"	},
	{ "ALRM_BADOUTPUT",	INFO_ALRM_BADOUTPUT,	"Alarm Output Bad"	},
	{ "ALRM_OUTPUTOFF",	INFO_ALRM_OUTPUTOFF,	"Alarm Output Off"	},
	{ "ALRM_OVERLOAD",	INFO_ALRM_OVERLOAD,	"Alarm Overload"	},
	{ "ALRM_IMMSHUT",	INFO_ALRM_IMMSHUT,	"Alarm Shutdown Imminent"	},
	{ "ALRM_PENDSHUT",	INFO_ALRM_PENDSHUT,	"Alarm Shutdown Pending"	},
	{ "ALRM_SYSOFF",	INFO_ALRM_SYSOFF,	"Alarm System Off"	},
	{ "ALRM_TEMP",		INFO_ALRM_TEMP,		"Alarm Temperature"	},
	{ "ALRM_UPSSHUT",	INFO_ALRM_UPSSHUT,	"Alarm UPS Shutdown"	},
	{ "AUDIBLEALRM",	INFO_AUDIBLEALRM,	"Audible Alarm"	},
	{ "AUTORESTART",	INFO_AUTORESTART,	"Auto Restart"	},
	{ "BATT_CHARGE",	INFO_BATT_CHARGE,	"Battery Charge"	},
	{ "BATT_COND",		INFO_BATT_COND,		"Battery Condition"	},
	{ "BATT_CURRENT",	INFO_BATT_CURRENT,	"Battery Current"	},
	{ "BATT_DATE",		INFO_BATT_DATE,		"Battery Installed"	},
	{ "BATT_STATUS",	INFO_BATT_STATUS,	"Battery Status"	},
	{ "BATT_TEMP",		INFO_BATT_TEMP,		"Battery Temperature"	},
	{ "BATT_VOLT",		INFO_BATT_VOLT,		"Battery Voltage"	},
	{ "BYPASS_CURRENT1",	INFO_BYPASS_CURRENT1,	"Bypass Current 1"	},
	{ "BYPASS_CURRENT2",	INFO_BYPASS_CURRENT2,	"Bypass Current 2"	},
	{ "BYPASS_CURRENT3",	INFO_BYPASS_CURRENT3,	"Bypass Current 3"	},
	{ "BYPASS_FREQ",	INFO_BYPASS_FREQ,	"Bypass Frequency"	},
	{ "BYPASS_NLINES",	INFO_BYPASS_NLINES,	"Bypass Num Lines"	},
	{ "BYPASS_PWR1",	INFO_BYPASS_PWR1,	"Bypass Power 1"	},
	{ "BYPASS_PWR2",	INFO_BYPASS_PWR2,	"Bypass Power 2"	},
	{ "BYPASS_PWR3",	INFO_BYPASS_PWR3,	"Bypass Power 3"	},
	{ "BYPASS_VOLT1",	INFO_BYPASS_VOLT1,	"Bypass Voltage 1"	},
	{ "BYPASS_VOLT2",	INFO_BYPASS_VOLT2,	"Bypass Voltage 2"	},
	{ "BYPASS_VOLT3",	INFO_BYPASS_VOLT3,	"Bypass Voltage 3"	},
	{ "BATT_PCT",		INFO_BATT_PCT,		"Estimated Charge"	},
	{ "IN_CURRENT1",	INFO_IN_CURRENT1,	"Input Current 1"	},
	{ "IN_CURRENT2",	INFO_IN_CURRENT2,	"Input Current 2"	},
	{ "IN_CURRENT3",	INFO_IN_CURRENT3,	"Input Current 3"	},
	{ "IN_ACFREQ1",		INFO_IN_ACFREQ1,	"Input Frequency 1"	},
	{ "IN_ACFREQ2",		INFO_IN_ACFREQ2,	"Input Frequency 2"	},
	{ "IN_ACFREQ3",		INFO_IN_ACFREQ3,	"Input Frequency 3"	},
	{ "IN_LINEBADS",	INFO_IN_LINEBADS,	"Input Line Bads"	},
	{ "IN_NLINES",		INFO_IN_NLINES,		"Input Num Lines"	},
	{ "IN_PWR1",		INFO_IN_PWR1,		"Input Power 1"	},
	{ "IN_PWR2",		INFO_IN_PWR2,		"Input Power 2"	},
	{ "IN_PWR3",		INFO_IN_PWR3,		"Input Power 3"	},
	{ "IN_VOLT1",		INFO_IN_VOLT1,		"Input Voltage 1"	},
	{ "IN_VOLT2",		INFO_IN_VOLT2,		"Input Voltage 2"	},
	{ "IN_VOLT3",		INFO_IN_VOLT3,		"Input Voltage 3"	},
	{ "NOM_BATTLIFE",	INFO_NOM_BATTLIFE,	"Nominal Battery Life"	},
	{ "NOM_IN_FREQ",	INFO_NOM_IN_FREQ,	"Nominal Input Frequency"	},
	{ "NOM_IN_VOLT",	INFO_NOM_IN_VOLT,	"Nominal Input Voltage"	},
	{ "NOM_LOBATTIME",	INFO_NOM_LOBATTIME,	"Nominal Low Battery Time"	},
	{ "NOM_OUT_FREQ",	INFO_NOM_OUT_FREQ,	"Nominal Output Frequency"	},
	{ "NOM_OUT_PWR",	INFO_NOM_OUT_PWR,	"Nominal Output Power"	},
	{ "NOM_OUT_VOLT",	INFO_NOM_OUT_VOLT,	"Nominal Output Voltage"	},
	{ "NOM_VA_RATE",	INFO_NOM_VA_RATE,	"Nominal VA Rating"	},
	{ "OUT_CURRENT1",	INFO_OUT_CURRENT1,	"Output Current 1"	},
	{ "OUT_CURRENT2",	INFO_OUT_CURRENT2,	"Output Current 2"	},
	{ "OUT_CURRENT3",	INFO_OUT_CURRENT3,	"Output Current 3"	},
	{ "OUT_FREQ",		INFO_OUT_FREQ,		"Output Frequency"	},
	{ "OUT_LOADPCT1",	INFO_OUT_LOADPCT1,	"Output Load 1"	},
	{ "OUT_LOADPCT2",	INFO_OUT_LOADPCT2,	"Output Load 2"	},
	{ "OUT_LOADPCT3",	INFO_OUT_LOADPCT3,	"Output Load 3"	},
	{ "OUT_NLINES",		INFO_OUT_NLINES,	"Output Num Lines"	},
	{ "OUT_LOADPWR1",	INFO_OUT_LOADPWR1,	"Output Power 1"	},
	{ "OUT_LOADPWR2",	INFO_OUT_LOADPWR2,	"Output Power 2"	},
	{ "OUT_LOADPWR3",	INFO_OUT_LOADPWR3,	"Output Power 3"	},
	{ "OUT_SOURCE",		INFO_OUT_SOURCE,	"Output Source"	},
	{ "OUT_VOLT1",		INFO_OUT_VOLT1,		"Output Voltage 1"	},
	{ "OUT_VOLT2",		INFO_OUT_VOLT2,		"Output Voltage 2"	},
	{ "OUT_VOLT3",		INFO_OUT_VOLT3,		"Output Voltage 3"	},
	{ "RBTWDUR",		INFO_RBTWDUR,		"Reboot With Duration"	},
	{ "SECSONBATT",		INFO_SECSONBATT,	"Seconds on Battery"	},
	{ "SHUTTYPE",		INFO_SHUTTYPE,		"Shutdown Type"	},
	{ "DELAYSHUT",		INFO_DELAYSHUT,		"Shutdown After Delay"	},
	{ "WAKEDELAY",		INFO_WAKEDELAY,		"Startup After Delay"	},
	{ "SLFTSTDETAIL",	INFO_SLFTSTDETAIL,	"Test Results Detail"	},
	{ "SLFTSTSUM",		INFO_SLFTSTSUM,		"Test Results Summary"	},
	{ "SLFTSTTYPE",		INFO_SLFTSTTYPE,	"Test Type"	},
	{ "BAUDRATE",		INFO_BAUDRATE,		"Baud Rate"	},
	{ "OUT_VA",		INFO_OUT_VA,		"Output Apparent Power"	},
	{ "OUT_POWER",		INFO_OUT_POWER,		"Output Actual Power"	},
	{ "TIME",		INFO_TIME,		"Time"	},
	{ "DATE",		INFO_DATE,		"Date"  },

	{ NULL,		INFO_UNUSED, 	NULL			}
};


/* instcmds[] - instant commands sent via SysV IPC msg queues */
struct instcmds_t {
	char	*name;
	int	cmd;
	char	*desc;
}	instcmds[] =
{
	{ "FPTEST",	CMD_FPTEST,	"Front panel test"		},
	{ "BTEST0",	CMD_BTEST0,	"Stop battery test"		},
	{ "BTEST1",	CMD_BTEST1,	"Start battery test"		},
	{ "OFF",	CMD_OFF,	"Turn off load"			},
	{ "ON",		CMD_ON,		"Turn on load"			},
	{ "CAL0",	CMD_CAL0,	"Stop runtime calibration"	},
	{ "CAL1",	CMD_CAL1,	"Start runtime calibration"	},
	{ "SDRET",	CMD_SDRET,	"Shutdown+return in auxdata min"},
	{ "DUMB",	CMD_DUMB,	"Turn dumb" 			},
	{ "SIMPWF",	CMD_SIMPWF,	"Simulate power failure"	},
	{ "SOFTDOWN",	CMD_SOFTDOWN,	"Soft shutdown"			},
	{ "SHUTDOWN",	CMD_SHUTDOWN,	"Shutdown after grace period" 	},
	{ "BYPASS",	CMD_BYPASS,	"Switch to Bypass mode" 	},
	{ NULL,		0,		NULL				}
};
