/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern buddylist_node *buddylist_head;
extern commandalias_node *commandaliasesroot;
extern char *command_list[];
extern int commandnum;
extern window_node *current_window;
extern color_pref colors;
extern preferences pref;

unsigned short find_tabbed_string(char *string_to_find, char *input_string)
{
   int i, numberofmatches = 0;
   unsigned short quote_begin = 0, quote_end = 0;
   int string_to_finds_length, input_strings_length;
   unsigned int amount_to_add;
   char *matches[MAXMATCHES];
   buddylist_node *current_buddy;
   commandalias_node *cmdaliasnode;

   string_to_finds_length = strlen(string_to_find);
   if(string_to_finds_length == 0)
     return 0;

   if(string_to_find[0] == '/') /* search through commands and command aliases */
     {
	for(i = 0; i < commandnum; i++)
	  {
	     if( !strncmp(command_list[i], string_to_find, string_to_finds_length) )
	       {
		  if(numberofmatches < MAXMATCHES)
		    matches[numberofmatches++] = command_list[i];
		  else
		    break;
	       }
	  }

	if (numberofmatches < MAXMATCHES)
	  {
	     for(cmdaliasnode = commandaliasesroot; cmdaliasnode; cmdaliasnode = cmdaliasnode -> next)
	       {
		  if (!strncmp(cmdaliasnode->name, string_to_find, string_to_finds_length))
		    {
		       if(numberofmatches < MAXMATCHES)
			 matches[numberofmatches++] = cmdaliasnode->name;
		       else
			 break;
		    }
	       }
	  }
     }
   else /* search through buddies and buddy aliases */
     {
	for(current_buddy = buddylist_head; current_buddy; current_buddy = current_buddy->next)
	  {
	     if( !strncmp(current_buddy->screenname, string_to_find, string_to_finds_length) )
	       {
		  if(numberofmatches < MAXMATCHES)
		    matches[numberofmatches++] = current_buddy->screenname;
		  else
		    break;
	       }
	     if( !strncmp(current_buddy->buddy_alias, string_to_find, string_to_finds_length) )
	       {
		  if(numberofmatches < MAXMATCHES)
		    matches[numberofmatches++] = current_buddy->buddy_alias;
		  else
		    break;
	       }
	  }
     }

   switch(numberofmatches)
     {
      case 0:
	beep();
	return 0;

      case 1:
	input_strings_length = strlen(input_string);

	/* check to see if they started with a quote, note parse_args gets rid of
	   quotes so we have to actually check input_string */
	if (input_string[input_strings_length - string_to_finds_length - 1] == '"')
	  quote_end = 1; /* tag a quote on the end if they started with one */
	else /* if they didn't start with a quote see if the match has spaces in it */
	  {
	     for (i = 0; i < strlen(matches[0]); i++)
	       {
		  if (matches[0][i] == ' ')
		    {
		       /* if we've got spaces put quotes around the result */
		       quote_begin = 1;
		       quote_end = 1;
		       break;
		    }
	       }
	  }

	if (quote_begin)
	  {
	     input_string[input_strings_length - string_to_finds_length] = '"';
	     strcpy(input_string + input_strings_length - string_to_finds_length + 1, matches[0]);
	  }
	else
	  strcat(input_string, (char*)(matches[0] + string_to_finds_length));

	if (quote_end)
	  strcat(input_string, "\"");

	/* put a space on the end all the time unless it's a command and they
	   want to see tard tips. */
	if (!(pref.tardtips && string_to_find[0] == '/'))
	  strcat(input_string, " ");
	break;

      default:
	if(numberofmatches >= MAXMATCHES)
	  {
	     info("Maxium matches exceeded.");
	     beep();
	  }
	else
	  {
	     int numofcharsmatch = 0, tmplength = string_to_finds_length - 1;
	     wattrset(current_window->window, CP(colors.tabfore, colors.tabback)|A_BOLD);
	     wprintw(current_window->window, "Possible Matches: ");
	     wattroff(current_window->window, A_BOLD);

	     for(i = 0; i < numberofmatches; i++)
	       wprintw(current_window->window, "%s ", matches[i]);

	     wprintw(current_window->window, "\n");

	     wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
	     wrefresh(current_window->window);

	     do
	       {
		  char tmpchr = matches[0][tmplength];
		  numofcharsmatch = 0;

		  for(i = 0; i < numberofmatches; i++)
		    {
		       if(matches[i][tmplength] == tmpchr)
			 numofcharsmatch++;
		    }
		  tmplength++;
	       }
	     while(numofcharsmatch == numberofmatches);

	     amount_to_add = tmplength - string_to_finds_length - 1;

	     if (amount_to_add > 0)
	       {
		  strncat(input_string, matches[0] + string_to_finds_length, amount_to_add);
		  return 1;
	       }
	     else
	       beep();
	  }
	return 0;
     }
   return 1;
}

