/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

typedef void (*funcptr)(void *, ...);
void *handle;

int main(int argc, char *argv[])
{
   int i, skip_login = 0;
   int chr;
   fd_set FD;
#ifdef RESIZEABLE
   struct sigaction sig_handler;

   sig_handler.sa_handler = resize_window;
   sigemptyset(&sig_handler.sa_mask);
   sig_handler.sa_flags = SA_RESTART;
   
   sigaction(SIGWINCH, &sig_handler, NULL);
#endif

   signal(SIGINT, shutdown_env);
   signal(SIGALRM, catch_alarm);
   
#ifdef DEBUG
   debug_init();
#endif

   for(i = 1; i < argc; i++)
     {
	if(!strcmp(argv[i], "--skiplogin"))
	  skip_login = 1;
     }

   handle = firetalk_create_handle(0);
   firetalk_register_callback(handle,FC_DISCONNECT, (funcptr) disconnect);
   firetalk_register_callback(handle,FC_ERROR, (funcptr) error);
   firetalk_register_callback(handle,FC_IM_GETMESSAGE, (funcptr) getmessage);
   firetalk_register_callback(handle,FC_IM_GETACTION, (funcptr) getaction);
   firetalk_register_callback(handle,FC_IM_BUDDYONLINE, (funcptr) buddy_online);
   firetalk_register_callback(handle,FC_IM_BUDDYOFFLINE, (funcptr) buddy_offline);
   firetalk_register_callback(handle,FC_IM_BUDDYAWAY, (funcptr) buddy_away);
   firetalk_register_callback(handle,FC_IM_BUDDYUNAWAY, (funcptr) buddy_unaway);
   firetalk_register_callback(handle,FC_IM_LISTBUDDY, (funcptr) listbuddy);
   firetalk_register_callback(handle,FC_GOTINFO, (funcptr) got_info);
   firetalk_register_callback(handle,FC_IDLEINFO, (funcptr) got_idle);
   firetalk_register_callback(handle,FC_SETIDLE, (funcptr) set_idle);
   firetalk_register_callback(handle,FC_EVILED, (funcptr) eviled);
   firetalk_register_callback(handle,FC_NEWNICK, (funcptr) newnick);
   firetalk_register_callback(handle,FC_PASSCHANGED, (funcptr) passchanged);
   firetalk_register_callback(handle,FC_DOINIT, (funcptr) doinit);
   firetalk_register_callback(handle,FC_CHAT_JOINED, (funcptr) chat_joined);
   firetalk_register_callback(handle,FC_CHAT_LEFT, (funcptr) chat_left);
   firetalk_register_callback(handle,FC_CHAT_INVITED, (funcptr) chat_invited);
   firetalk_register_callback(handle,FC_CHAT_USER_JOINED, (funcptr) chat_user_joined);
   firetalk_register_callback(handle,FC_CHAT_USER_LEFT, (funcptr) chat_user_left);
   firetalk_register_callback(handle,FC_CHAT_GETMESSAGE, (funcptr) get_chatroom_message);

   if(path_init())
     load_colors();

   setup_env();

   if(!skip_login)
     login();

   keypad(stdscr, TRUE);

   mainloop:
   FD_ZERO(&FD);
   FD_SET(STDIN_FILENO, &FD);

   if(firetalk_select_custom(STDIN_FILENO+1, &FD, NULL, NULL, NULL) < 0)
     {
	firetalk_perror("firetalk_select");
	exit(EXIT_FAILURE);
     }

   if(FD_ISSET(STDIN_FILENO, &FD))
     {
	chr = getch();
	process_keypress(chr);
     }
   goto mainloop;
}

