/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *main_window;
extern window_node *current_window;
extern preferences pref;
extern buddylist_node *scrolled_buddy;
extern void *handle;
extern awaymessage_node *away_message;
extern char last_message_sender[];
extern char username[];
extern int away;
extern color_pref colors;

void send_message(char *who, char *message, int autoreply)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   int success, using_scrolledbuddy = 0;
   window_node *curwin = current_window;

   if(who == NULL)
     {
	if(scrolled_buddy)
	  {
	     who = scrolled_buddy->screenname;
	     using_scrolledbuddy = 1;
	  }
	else
	  return;
     }

   success = firetalk_im_send_message(handle, who, message, autoreply);
   if(success == FE_SUCCESS)
     {
	if(pref.multi_windows)
	  {
	     curwin = windowfor((char*)who, FALSE);

	     if(!curwin)
	       {
		  if(using_scrolledbuddy)
		    {
		       if(scrolled_buddy->buddy_alias[0])
			 wprintw(main_window->window, "No window for %s... creating.\n", scrolled_buddy->buddy_alias);
		       else
			 wprintw(main_window->window, "No window for %s... creating.\n", scrolled_buddy->screenname);
		    }
		  else
		    wprintw(main_window->window, "No window for %s... creating.\n", who);

		  if(current_window == main_window)
		    wrefresh(main_window->window);
		  addwindowtolist((char*)who, FALSE);
		  curwin = windowfor((char*)who, FALSE);
	       }

	     if(pref.window_popup_on_mesg)
	       current_window = curwin;
	  }

	wattrset(curwin->window, CP(colors.sendfore, colors.sendback));
	if(pref.timestamp)
	  {
	     time_value = time(NULL);
	     time_info = localtime(&time_value);
	     strftime(tbuff, 9, "%X", time_info);
	     wprintw(curwin->window, "%s ", tbuff);
	  }

	if(using_scrolledbuddy)
	  {
	     if(scrolled_buddy->buddy_alias[0])
	       wprintw(curwin->window, "%s< ", scrolled_buddy->buddy_alias);
	     else
	       wprintw(curwin->window, "%s< ", scrolled_buddy->screenname);
	  }
	else
	  wprintw(curwin->window, "%s< ", who);

	wattrset(curwin->window, CP(colors.mainfore, colors.mainback));
	print_html(curwin, (char*)message);
	wprintw(curwin->window, "\n");

	if(curwin == current_window)
	  {
	     touchwin(curwin->window);
	     wrefresh(curwin->window);
	  }

	if(pref.logging)
	  log_message(who, message, SEND);
     }
   else
     alert("Could not send message to buddy.");

   if(away && autoreply == FALSE)
     {
	away = FALSE;
	firetalk_set_away(handle, "");
     }

   alarm(pref.away_timer);
}

void send_room_message(char *room, char *message, int autoreply)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   int success, using_scrolledbuddy = 0;
   window_node *curwin = current_window;

   if(room == NULL)
     {
	if(scrolled_buddy && scrolled_buddy->isroom)
	  {
	     room = scrolled_buddy->screenname;
	     using_scrolledbuddy = 1;
	  }
	else
	  return;
     }

   success = firetalk_chat_send_message(handle, room, message, autoreply);
   if(success == FE_SUCCESS)
     {
	if(pref.multi_windows)
	  {
	     curwin = windowfor((char*)room, TRUE);

	     if(!curwin)
	       {
		  if(using_scrolledbuddy)
		    wprintw(main_window->window, "No window for room '%s'... creating.\n", scrolled_buddy->screenname);
		  else
		    wprintw(main_window->window, "No window for room '%s'... creating.\n", room);

		  if(current_window == main_window)
		    wrefresh(main_window->window);
		  addwindowtolist((char*)room, TRUE);
		  curwin = windowfor((char*)room, TRUE);
	       }

	     if(pref.window_popup_on_mesg)
	       current_window = curwin;
	  }

	wattrset(curwin->window, CP(colors.sendfore, colors.sendback));
	if(pref.timestamp)
	  {
	     time_value = time(NULL);
	     time_info = localtime(&time_value);
	     strftime(tbuff, 9, "%X", time_info);
	     wprintw(curwin->window, "%s ", tbuff);
	  }

	if(using_scrolledbuddy)
	  wprintw(curwin->window, "%s< ", scrolled_buddy->screenname);
	else
	  wprintw(curwin->window, "%s< ", room);

	wattrset(curwin->window, CP(colors.mainfore, colors.mainback));
	print_html(curwin, (char*)message);
	wprintw(curwin->window, "\n");

	if(curwin == current_window)
	  {
	     touchwin(curwin->window);
	     wrefresh(curwin->window);
	  }

	if(pref.logging)
	  log_room_message(room, username, message);
     }
   else
     alert("Could not send message to buddy.");

   if(away && autoreply == FALSE)
     {
	away = FALSE;
	firetalk_set_away(handle, "");
     }

   alarm(pref.away_timer);
}

void getmessage(void *c, const char * const who, const int automessage, const char * const message)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   window_node *curwin = current_window;
   buddylist_node *buddy_node;

   buddy_node = findbuddybyscreenname((char*)who);
   if(buddy_node == NULL)
     firetalk_im_add_buddy(handle, (char*)who);

   if(pref.logging)
     log_message((char*)who, (char*)message, RECIEVE);

   if(pref.multi_windows)
     {
	curwin = windowfor((char*)who, FALSE);

	if(!curwin)
	  {
	     if(buddy_node)
	       {
		  if(buddy_node->buddy_alias[0])
		    wprintw(main_window->window, "No window for %s... creating\n", buddy_node->buddy_alias);
		  else
		    wprintw(main_window->window, "No window for %s... creating\n", buddy_node->screenname);
	       }
	     else
	       wprintw(main_window->window, "No window for %s... creating\n", who);

	     if(current_window == main_window)
	       wrefresh(main_window->window);
	     addwindowtolist((char*)who, FALSE);
	     curwin = windowfor((char*)who, FALSE);
	     
	     if(pref.window_popup_on_mesg)
	       current_window = curwin;
	  }
     }

   strcpy(last_message_sender, who);
   wattrset(curwin->window, CP(colors.recvfore, colors.recvback));
   if(pref.timestamp)
     {
	time_value = time(NULL);
	time_info = localtime( &time_value );
	strftime( tbuff, 9, "%X", time_info );
	wprintw(curwin->window, "%s ", tbuff);
     }

   if(buddy_node)
     {
	if(buddy_node->buddy_alias[0])
	  wprintw(curwin->window, "%s> ", buddy_node->buddy_alias);
	else
	  wprintw(curwin->window, "%s> ", buddy_node->screenname);
     }
   else
     wprintw(curwin->window, "%s> ", who);

   wattrset(curwin->window, CP(colors.mainfore, colors.mainback));

   if(automessage)
     wprintw(curwin->window, "AUTOMESSAGE: ");

   print_html(curwin, (char*)message);
   wprintw(curwin->window, "\n");

   if(curwin == current_window)
     wrefresh(curwin->window);

   if(pref.beep)
     beep();

   if(away && should_send_away_message((char*)who))
     {
	if(away_message == NULL)
	  away_message = setawaymessage(0);
	send_message((char*)who, away_message->message, 1);
     }
}

void get_chatroom_message(void *c, const char * const room, const char * const from, const int automessage, const char * message)
{
   char tbuff[9];
   struct tm *time_info;
   time_t time_value;
   window_node *curwin = current_window;
   buddylist_node *buddy_node;

   buddy_node = findbuddybyscreenname((char*)from);

   if(pref.multi_windows)
     {
	curwin = windowfor((char*)room, TRUE);

	if(!curwin)
	  {
	     addwindowtolist((char*)room, TRUE);
	     wprintw(main_window->window, "No window for room '%s'... creating\n", room);
	     if(current_window == main_window)
	       wrefresh(main_window->window);

	     curwin = windowfor((char*)room, TRUE);

	     if(pref.window_popup_on_mesg)
	       current_window = curwin;
	  }
     }

   strcpy(last_message_sender, room);
   wattrset(curwin->window, CP(colors.recvfore, colors.recvback));
   if(pref.timestamp)
     {
	time_value = time(NULL);
	time_info = localtime( &time_value );
	strftime( tbuff, 9, "%X", time_info );
	wprintw(curwin->window, "%s ", tbuff);
     }

   wprintw(curwin->window, "%s:", room);

   if(buddy_node != NULL)
     {
	if(buddy_node->buddy_alias[0])
	  wprintw(curwin->window, "%s> ", buddy_node->buddy_alias);
	else
	  wprintw(curwin->window, "%s> ", buddy_node->screenname);
     }
   else
     wprintw(curwin->window, "%s> ", from);

   wattrset(curwin->window, CP(colors.mainfore, colors.mainback));

   if(automessage)
     wprintw(curwin->window, "AUTOMESSAGE: ");

   print_html(curwin, (char*)message);
   wprintw(curwin->window, "\n");

   if(curwin == current_window)
     wrefresh(curwin->window);

   if(pref.beep)
     beep();

   if(pref.logging)
     log_room_message((char*)room, (char*)from, (char*)message);

   if(away && should_send_away_message((char*)room))
     {
	if(away_message == NULL)
	  away_message = setawaymessage(0);
	send_message((char*)room, away_message->message, 1);
     }
}
