/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern char *command_list[];
extern int commandnum;
extern window_node *main_window;
extern window_node *current_window;
extern color_pref colors;
commandalias_node *commandaliasesroot = NULL;

/* adds or replaces an alias in the alias linked list */
void addcommandalias(char *name, char *command)
{
   commandalias_node *node;
   commandalias_node *prevnode = NULL;
   unsigned short i;

   if (name[0] != '/')
     {
	alert("The alias name must be a command, ie. start with /");
	return;
     }

   for (i = 0; i < commandnum; i++)
     {
	if (!strcmp(command_list[i], name))
	  {
	     alert("The alias name cannot be a built in command");
	     return;
	  }
     }

   if (!strcmp(name, command))
     {
	alert("Can't add an alias who's command is itself");
	return;
     }

   if (commandaliasesroot)
     {
	node = commandaliasesroot;
	if(!strcmp(node->name, name))
	  {
	     strcpy(node->command, command);
	     return;
	  }

	for(node = node->next; node; node = node->next)
	  {
	     if (!strcmp(node->name, name)) /* overwrite old values */
	       break;
	     prevnode = node;
	  }
	if (!prevnode->next)
	  {
	     prevnode->next = (commandalias_node *)MALLOC(sizeof(commandalias_node), "addcommandalias");
	     if (!prevnode->next)
	       {
		  alert("Couldn't allocate memory for new alias");
		  return;
	       }
	     prevnode->next->next = NULL;
	  }
	strcpy(prevnode->next->name, name);
	strcpy(prevnode->next->command, command);
     }
   else
     {
	commandaliasesroot = (commandalias_node *)MALLOC(sizeof(commandalias_node), "addcommandalias");
	if (!commandaliasesroot)
	  {
	     alert("Couldn't allocate memory for new alias");
	     return;
	  }
	commandaliasesroot->next = NULL;
	strcpy(commandaliasesroot->name, name);
	strcpy(commandaliasesroot->command, command);
     }
   return;
}

/* prints the current alias linked list */
void printcommandaliases(void)
{
   commandalias_node *temp;
   unsigned short i = 0;

   wattrset(current_window->window, CP(colors.aliasfore, colors.aliasback)|A_BOLD);
   if (!commandaliasesroot)
     {
	info("No aliases loaded");
	return;
     }
   wprintw(current_window->window, "Currently loaded aliases:\n");
   wattrset(current_window->window, CP(colors.aliasfore, colors.aliasback));
   for (temp = commandaliasesroot; temp; temp = temp->next)
     {
	wprintw(current_window->window, "[%d] %s %s\n", i, temp->name, temp->command);
	i++;
     }
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
   wrefresh(current_window->window);
   return;
}

/* clears the current alias linked list */
void clearcommandaliases(void)
{
   commandalias_node *temp;
   commandalias_node *next;

   for (temp = commandaliasesroot; temp; temp = next)
     {
	next = temp->next;
	FREE(temp, "clearcommandaliases");
     }
   commandaliasesroot = NULL;
   return;
}

/* searches the alias linked list for a name */
commandalias_node *findcommandalias(char *name)
{
   commandalias_node *temp;

   for (temp = commandaliasesroot; temp; temp = temp->next)
     {
	if (!strcmp(temp->name, name))
	  return temp;
     }
   return NULL;
}

/* deletes an alias from the alias linked list */
void deletecommandalias(char *name)
{
   commandalias_node *temp;
   commandalias_node *prevnode = NULL;

   for(temp = commandaliasesroot; temp; temp = temp->next)
     {
	if(!strcmp(temp->name, name))
	  {
	     if(temp == commandaliasesroot)
	       {
		  commandaliasesroot = commandaliasesroot->next;
		  FREE(temp, "deletecommandalias");
		  return;
	       }
	     else if(prevnode)
	       {
		  prevnode->next = temp->next;
		  FREE(temp, "deletecommandalias");
		  return;
	       }
	     else
	       {
		  FREE(temp, "deletecommandalias");
		  commandaliasesroot = NULL;
		  return;
	       }
	  }
	prevnode = temp;
     }
   alert("Alias not found");
   return;
}
