/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern buddylist_node *buddylist_head;
extern char username[];
extern char ntaim_path[];

void addbuddyalias(char *screenname, char *alias)
{
   char *stripedname = stripname(screenname);
   buddylist_node *cur = buddylist_head;

   while(cur)
     {
	if(!strcmp(stripedname, cur->stripedname))
	  {
	     int stringlen = strlen(alias);
	     if(stringlen > 63)
	       stringlen = 63;
	     strncpy(cur->buddy_alias, alias, stringlen);
	     cur->buddy_alias[stringlen] = 0;
	     break;
	  }
	cur = cur->next;
     }
   update_buddywin();
}

char *getbuddyalias(char *screenname)
{
   int fd, i = 0;
   char chr;
   char path[PATHSIZE];
   static char buffer[128];

   strcpy(path, ntaim_path);
   strcat(path, "/");
   strcat(path, username);
   strcat(path, ".aliases");

   fd = open(path, O_RDONLY);
   if(fd < 0)
     return NULL;

   while(read(fd, &chr, 1))
     {
	if(chr != ':')
	  buffer[i++] = chr;
	else
	  {
	     buffer[i] = 0;
	     if(!strcmp(stripname(screenname), buffer))
	       {
		  i = 0;
		  while(read(fd, &chr, 1))
		    {
		       if(chr != '\n')
			 buffer[i++] = chr;
		       else
			 {
			    buffer[i] = 0;
			    close(fd);
			    return buffer;
			 }
		    }
		  close(fd);
		  return NULL;
	       }
	     else
	       {
		  read(fd, &chr, 1);
		  while(chr != '\n')
		    read(fd, &chr, 1);
		  i = 0;
	       }
	  }
     }
   close(fd);

   return NULL;
}

void savebuddyaliases(void)
{
   int fd;
   char path[PATHSIZE];
   buddylist_node *cur = buddylist_head;

   strcpy(path, ntaim_path);
   strcat(path, "/");
   strcat(path, username);
   strcat(path, ".aliases");

   fd = open(path, O_WRONLY|O_CREAT, 0644);
   if(fd < 0)
     return;

   while(cur)
     {
	if(cur->buddy_alias[0])
	  {
	     write(fd, cur->stripedname, strlen(cur->stripedname));
	     write(fd, ":", 1);
	     write(fd, cur->buddy_alias, strlen(cur->buddy_alias));
	     write(fd, "\n", 1);
	  }
	cur = cur->next;
     }
   close(fd);
   info("Saved aliases successfully.");
}
