/*
toc.h - FireTalk TOC protocol declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _TOC_H
#define _TOC_H

#include <unistd.h>
#include <sys/time.h>

/* AOL/TOC Functions */
int toc_disconnect(void * const c);
void *toc_connect_server(const char * const server, const short port);
int toc_signon(void * const c, const char * const username, const char * const password);

int toc_im_add_buddy(void * const c, const char * const nickname);
int toc_im_remove_buddy(void * const c, const char * const nickname);
int toc_im_add_deny(void * const c, const char * const nickname);
int toc_im_remove_deny(void * const c, const char * const nickname);
int toc_im_upload_buddies(void * const c);
int toc_im_upload_denies(void * const c);
int toc_im_send_message(void * const c, const char * const dest, const char * const message, const int auto_flag);
int toc_im_send_action(void * const c, const char * const dest, const char * const message, const int auto_flag);
int toc_im_evil(void * const c, const char * const who);

int toc_chat_join(void * const c, const char * const room);
int toc_chat_part(void * const c, const char * const room);
int toc_chat_send_message(void * const c, const char * const room, const char * const message);
int toc_chat_send_action(void * const c, const char * const room, const char * const message);
int toc_chat_invite(void * const c, const char * const room, const char * const who, const char * const message);

int toc_save_config(void * const c);
int toc_get_info(void * const c, const char * const nickname);
int toc_set_info(void * const c, const char * const info);
int toc_set_away(void *c, const char * const message);
int toc_set_nickname(void * const c, const char * const nickname);
int toc_set_password(void * const c, const char * const oldpass, const char * const newpass);
int toc_got_data(void * const c);
int toc_get_fd(void *c);
int toc_set_idle(void *c);
int toc_compare_nicks(const char * const nick1, const char * const nick2);

#endif
