/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.util.Located;
import bossa.util.Location;

public class LocatedString
implements Located,
Comparable {
    public String content;
    Location loc;
    private boolean quoted;

    public LocatedString(String content, Location loc) {
        this(content, loc, false);
    }

    public LocatedString(String content) {
        this(content, Location.nowhere(), false);
    }

    public LocatedString(String content, Location loc, boolean quoted) {
        this.content = content;
        this.loc = loc;
        this.quoted = quoted;
    }

    public String toQuotedString() {
        if (this.quoted) {
            return "`" + this.content + "`";
        }
        return this.content;
    }

    public String toString() {
        return this.content;
    }

    @Override
    public Location location() {
        return this.loc;
    }

    public void append(String suffix) {
        this.content = this.content + suffix;
    }

    public void prepend(String prefix) {
        this.content = prefix + this.content;
    }

    public LocatedString cloneLS() {
        return new LocatedString(this.content, this.loc);
    }

    public LocatedString substring(int beginIndex, int endIndex) {
        return new LocatedString(this.content.substring(beginIndex, endIndex), this.loc);
    }

    public boolean equals(Object o) {
        if (o instanceof LocatedString) {
            return this.equals((LocatedString)o);
        }
        return false;
    }

    public final boolean equals(LocatedString s) {
        boolean res = this.content.equals(s.content);
        return res;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public int compareTo(Object o) {
        return this.content.compareTo(((LocatedString)o).content);
    }
}

