#ifdef INTERFACE
CLASS(NexuizServerCreateTab) EXTENDS(NexuizTab)
	METHOD(NexuizServerCreateTab, fill, void(entity))
	METHOD(NexuizServerCreateTab, gameTypeChangeNotify, void(entity))
	ATTRIB(NexuizServerCreateTab, title, string, "Create")
	ATTRIB(NexuizServerCreateTab, intendedWidth, float, 0.9)
	ATTRIB(NexuizServerCreateTab, rows, float, 22)
	ATTRIB(NexuizServerCreateTab, columns, float, 6.5)

	ATTRIB(NexuizServerCreateTab, mapListBox, entity, NULL)
	ATTRIB(NexuizServerCreateTab, sliderFraglimit, entity, NULL)
	ATTRIB(NexuizServerCreateTab, sliderTimelimit, entity, NULL)
	ATTRIB(NexuizServerCreateTab, checkboxFraglimit, entity, NULL)
ENDCLASS(NexuizServerCreateTab)
entity makeNexuizServerCreateTab();
#endif

#ifdef IMPLEMENTATION

entity makeNexuizServerCreateTab()
{
	entity me;
	me = spawnNexuizServerCreateTab();
	me.configureDialog(me);
	return me;
}

void fillNexuizServerCreateTab(entity me)
{
	entity e, e0;
	float n;

	me.TR(me);
		n = 9 + 1 * !!cvar("developer");
		// NOTE: not using ?: due to fteqcc bug
		// this actually means: cvar("developer") ? 10 : 9
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_dm", "DM"));
			e0 = e;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_tdm", "TDM"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_lms", "LMS"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_arena", "Arena"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_runematch", "Rune"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_domination", "Dom"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_keyhunt", "Key Hunt"));
			if(e.checked) e0 = NULL;
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_ctf", "CTF"));
			if(e.checked) e0 = NULL;
		if(cvar("developer"))
		{
			me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_assault", "Assault"));
				if(e.checked) e0 = NULL;
		}
		me.TD(me, 2, me.columns / n, e = makeNexuizGametypeButton(1, "g_onslaught", "Onslaught"));
			if(e.checked) e0 = NULL;
		if(e0)
		{
			//print("NO CHECK\n");
			e0.setChecked(e0, 1);
		}
	me.TR(me);
	me.TR(me);
	me.TR(me);
		me.TD(me, 1, 3, e = makeNexuizTextLabel(0, "Map list:"));
	me.TR(me);
		me.TD(me, me.rows - 7, 3, e = makeNexuizMapList());
		me.mapListBox = e;
	me.gotoRC(me, me.rows - 3, 0);
		me.TDempty(me, 0.5);
		me.TD(me, 1, 1, e = makeNexuizButton("All", '0 0 0'));
			e.onClick = MapList_All;
			e.onClickEntity = me.mapListBox;
		me.TD(me, 1, 1, e = makeNexuizButton("None", '0 0 0'));
			e.onClick = MapList_None;
			e.onClickEntity = me.mapListBox;
		me.TDempty(me, 0.5);

	me.gotoRC(me, 3, 3.5); me.setFirstColumn(me, me.currentColumn);
		me.TD(me, 1, 3, e = makeNexuizTextLabel(0, "Settings:"));
	me.TR(me);
		me.sliderTimelimit = makeNexuizSlider(1.0, 60.0, 0.5, "timelimit_override");
		me.TD(me, 1, 1, e = makeNexuizSliderCheckBox(0, 1, me.sliderTimelimit, "Time limit:"));
		me.TD(me, 1, 2, me.sliderTimelimit);
	me.TR(me);
		me.TDempty(me, 0.2);
		me.TD(me, 1, 2.8, e = makeNexuizSliderCheckBox(-1, 0, me.sliderTimelimit, "Use map specified default"));
	me.TR(me);
		me.sliderFraglimit = makeNexuizSlider(1.0, 2000.0, 5, "fraglimit_override");
		me.TD(me, 1, 1, e = makeNexuizSliderCheckBox(0, 1, me.sliderFraglimit, "Point limit:"));
			me.checkboxFraglimit = e;
		me.TD(me, 1, 2, me.sliderFraglimit);
	me.TR(me);
		me.TDempty(me, 0.2);
		me.TD(me, 1, 2.8, e = makeNexuizSliderCheckBox(-1, 0, me.sliderFraglimit, "Use map specified default"));
	me.TR(me);
	me.TR(me);
		me.TD(me, 1, 3, e = makeNexuizCheckBox(0, "g_antilag", "AntiLag"));
	me.TR(me);
	me.TR(me);
		me.TD(me, 1, 1, e = makeNexuizTextLabel(0, "Map voting:"));
		me.TD(me, 1, 2, e = makeNexuizTextSlider("g_maplist_votable"));
			e.addValue(e, "No voting", "0");
			e.addValue(e, "2 choices", "2");
			e.addValue(e, "3 choices", "3");
			e.addValue(e, "4 choices", "4");
			e.addValue(e, "5 choices", "5");
			e.addValue(e, "6 choices", "6");
			e.addValue(e, "7 choices", "7");
			e.configureNexuizTextSliderValues(e);
	me.TR(me);
		me.TD(me, 1, 3, e = makeNexuizCheckBox(0, "sv_vote_simple_majority", "Simple majority wins vcall"));
	me.TR(me);
	me.TR(me);
		me.TD(me, 1, 1, e = makeNexuizTextLabel(0, "Number of players:"));
		me.TD(me, 1, 2, makeNexuizSlider(1, 32, 1, "menu_maxplayers"));
	me.TR(me);
		me.TD(me, 1, 1, e = makeNexuizTextLabel(0, "Number of bots:"));
		me.TD(me, 1, 2, makeNexuizSlider(0, 7, 1, "bot_number"));
	me.TR(me);
		me.TDempty(me, 0.2);
		me.TD(me, 1, 0.8, e = makeNexuizTextLabel(0, "Bot skill:"));
		me.TD(me, 1, 2, e = makeNexuizTextSlider("skill"));
			e.addValue(e, "Botlike", "0");
			e.addValue(e, "Beginner", "1");
			e.addValue(e, "You will win", "2");
			e.addValue(e, "You can win", "3");
			e.addValue(e, "You might win", "4");
			e.addValue(e, "Advanced", "5");
			e.addValue(e, "Expert", "6");
			e.addValue(e, "Pro", "7");
			e.addValue(e, "Assassin", "8");
			e.addValue(e, "Unhuman", "9");
			e.addValue(e, "Godlike", "10");
			e.configureNexuizTextSliderValues(e);
			setDependent(e, "bot_number", 0, -1);
	me.TR(me);
		me.TDempty(me, 0.2);
		me.TD(me, 1, 0.8, e = makeNexuizTextLabel(0, "Bot names:"));
		me.TD(me, 1, 0.7, e = makeNexuizInputBox(1, "bot_prefix"));
			setDependent(e, "bot_number", 0, -1);
		me.TD(me, 1, 0.6, e = makeNexuizTextLabel(0.5, "Shadow"));
			setDependent(e, "bot_number", 0, -1);
		me.TD(me, 1, 0.7, e = makeNexuizInputBox(1, "bot_suffix"));
			setDependent(e, "bot_number", 0, -1);
	me.TR(me);
	me.TR(me);
		me.TD(me, 1, 1, e = makeNexuizButton("Mutators...", '0 0 0'));
			e.onClick = DialogOpenButton_Click;
			e.onClickEntity = main.mutatorsDialog;
			main.mutatorsDialog.refilterEntity = me.mapListBox;
		me.TD(me, 1, 2, e0 = makeNexuizTextLabel(0, string_null));
			e0.textEntity = main.mutatorsDialog;
			e0.allowCut = 1;

	me.gotoRC(me, me.rows - 1, 0);
		me.TD(me, 1, me.columns, e = makeNexuizButton("Start!", '0 0 0'));
			e.onClick = MapList_LoadMap;
			e.onClickEntity = me.mapListBox;
			me.mapListBox.startButton = e;

	me.gameTypeChangeNotify(me);
}

void GameType_ConfigureSliders(entity e, entity l, string pLabel, float pMin, float pMax, float pStep, string pCvar)
{
	e.configureNexuizSlider(e, pMin, pMax, pStep, pCvar);
	l.setText(l, pLabel);
}

void gameTypeChangeNotifyNexuizServerCreateTab(entity me)
{
	// tell the map list to update
	float gt;
	entity e, l;
	gt = MapInfo_CurrentGametype();
	e = me.sliderFraglimit;
	l = me.checkboxFraglimit;
	switch(gt)
	{
		case MAPINFO_TYPE_CTF:        GameType_ConfigureSliders(e, l, "Point limit:",  50,  500, 10, "g_ctf_capture_limit");      break;
		case MAPINFO_TYPE_DOMINATION: GameType_ConfigureSliders(e, l, "Point limit:",  50,  500, 10, "g_domination_point_limit"); break;
		case MAPINFO_TYPE_KEYHUNT:    GameType_ConfigureSliders(e, l, "Point limit:", 200, 1500, 50, "g_keyhunt_point_limit");    break;
		case MAPINFO_TYPE_RUNEMATCH:  GameType_ConfigureSliders(e, l, "Point limit:",  50,  500, 10, "g_runematch_point_limit");  break;
		case MAPINFO_TYPE_LMS:        GameType_ConfigureSliders(e, l, "Lives:",         3,   50,  1, "g_lms_lives_override");     break;
		default:                      GameType_ConfigureSliders(e, l, "Frag limit:",    5,  100,  5, "fraglimit_override");       break;
	}
	me.mapListBox.refilter(me.mapListBox);
}

#endif
