#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10792); 

name["english"] = "Textor Webmasters CGI Allows Remote Command Execution";
 script_name(english:name["english"]);

 desc["english"] = "
Textor Webmaster's Listre.pl CGI is installed on this host.
A security problem in this CGI allows execution of arbitrary 
commands with the privileges of the web server.

Solution: Contact the author for a patch.
Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5KP0N005FK.html";

 script_description(english:desc["english"]);

 summary["english"] = "Textor Webmasters List Record CGI Information Disclosure";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[0] = "/cgi-bin/common";
dir[1] = "/cgi-local";
dir[2] = "/scripts";
dir[3] = "/cgi_bin";
dir[4] = cgibin();

port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "/listrec.pl");
 if (is_cgi_installed(url))
 {
  security_warning(port);
  exit(0); 
 }
}
