#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10701);
 #script_bugtraq_id(2954);
 
 name["english"] = "php safemode";

 script_name(english:name["english"]]);
 
 desc["english"] = "
The remote host is running php 4.0.5.

There is a flaw in this version of PHP that allows
local users to circumvent the safe mode and to gain
the uid of the http process.


Solution : Upgrade to PHP 4.0.6
Risk factor : High";




 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for version of PHP";
 summary["francais"] = "Vrifie la version de PHP";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;
if(get_port_state(port))
{
 key = string("www/banner/", port);
 banner = get_kb_item(key);
 if(!banner)
 {
   soc = open_sock_tcp(port);
   req = http_get(item:"/", port:port);
   send(socket:soc, data:req);
   banner = recv(socket:soc, length:2000);
   close(soc);
 }

 serv = strstr(banner, "Server");
 if(ereg(pattern:".*PHP/4\.0\.5.*",
          string:serv))
 {
   security_warning(port);
 }
}
 
