/* $Id: SeqTable_sparse_index.cpp 407147 2013-07-18 14:46:15Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqtable.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqtable/SeqTable_sparse_index.hpp>

#include <objects/seqtable/seq_table_exception.hpp>
#include <util/bitset/bmfunc.h>
#include <util/bitset/bmserial.h>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CSeqTable_sparse_index::~CSeqTable_sparse_index(void)
{
}


#ifdef NCBI_COMPILER_GCC
const size_t CSeqTable_sparse_index::kInvalidIndex;
const size_t CSeqTable_sparse_index::kSkipped;
#endif

DEFINE_STATIC_MUTEX(sx_PrepareMutex_sparse_index);
static const size_t kBlockSize = 1024;


static inline size_t sx_CalcByteBitCount(Uint4 word)
{
    return bm::word_bitcount(word);
}


static inline size_t sx_CalcByteBitCount(Uint1 byte)
{
    return bm::bit_count_table<true>::_count[byte];
}


static inline size_t sx_CalcBlockBitCount(const char* block, size_t size)
{
    const bm::word_t* word_block = reinterpret_cast<const bm::word_t*>(block);
    const bm::word_t* word_block_end = word_block + size/sizeof(bm::word_t);
    size_t ret = bm::bit_block_calc_count(word_block, word_block_end);

    const char* tail_ptr = reinterpret_cast<const char*>(word_block_end);
    const char* block_end = block + size;
    for ( ; tail_ptr != block_end; ++tail_ptr ) {
        ret += sx_CalcByteBitCount(Uint1(*tail_ptr));
    }

    return ret;
}


static inline size_t sx_FindFirstNonZeroBit(Uint1 b)
{
    for ( size_t i = 0; i < 8; ++i, b <<= 1 ) {
        if ( b&0x80 ) {
            return i;
        }
    }
    return CSeqTable_sparse_index::kInvalidIndex;
}


static inline size_t sx_FindNextNonZeroBit(Uint1 b, size_t prev_i)
{
    b <<= prev_i+1;
    for ( size_t i = prev_i+1; i < 8; ++i, b <<= 1 ) {
        if ( b&0x80 ) {
            return i;
        }
    }
    return CSeqTable_sparse_index::kInvalidIndex;
}


static inline size_t sx_FindFirstNonZeroByte(const char* beg,
                                             const char* end)
{
    for ( const char* ptr = beg; ptr != end; ++ptr ) {
        if ( *ptr ) {
            return ptr - beg;
        }
    }
    return CSeqTable_sparse_index::kInvalidIndex;
}


static inline size_t sx_FindFirstNonZeroByte(const vector<char>& bytes,
                                             size_t index)
{
    size_t size = bytes.size();
    const char* ptr = &bytes[0];
    size_t offset = sx_FindFirstNonZeroByte(ptr+index, ptr+size);
    if ( offset == CSeqTable_sparse_index::kInvalidIndex ) {
        return CSeqTable_sparse_index::kInvalidIndex;
    }
    return index + offset;
}


void CSeqTable_sparse_index::x_Preprocess(void) const
{
    CMutexGuard guard(sx_PrepareMutex_sparse_index);
    if ( IsIndexes_delta() ) {
        const_cast<CSeqTable_sparse_index*>(this)->ChangeToIndexes();
    }
    else if ( IsBit_set_bvector() && !m_BitVector ) {
        const TBit_set& bit_set = GetBit_set_bvector();
        AutoPtr<bm::bvector<> > bv(new bm::bvector<>());
        bm::deserialize(*bv, (const unsigned char*)&bit_set[0]);
        m_BitVector.reset(bv.release());
    }
}


size_t CSeqTable_sparse_index::x_GetBytesBitCount(size_t byte_count) const
{
    const TBit_set& bytes = GetBit_set();
    size_t size = bytes.size();
    CMutexGuard guard(sx_PrepareMutex_sparse_index);
    size_t block_index  = byte_count / kBlockSize;
    size_t block_offset = byte_count % kBlockSize;
    if ( !m_BitCount ) {
        m_BitCount.reset(new SBitCount);
        m_BitCount->m_BlockBitCountSize = 0;
        m_BitCount->m_CacheBlock = numeric_limits<size_t>::max();
    }
    SBitCount& bc = *m_BitCount;
    for ( ; block_index > bc.m_BlockBitCountSize; ) {
        if ( !bc.m_BlockBitCount ) {
            size_t block_count = size / kBlockSize;
            bc.m_BlockBitCount.reset(new size_t[block_count]);
        }
        size_t bsize = bc.m_BlockBitCountSize;
        size_t count = sx_CalcBlockBitCount(&bytes[bsize*kBlockSize],
                                            kBlockSize);
        if ( bsize ) {
            count += bc.m_BlockBitCount[bsize-1];
        }
        bc.m_BlockBitCount[bsize] = count;
        bc.m_BlockBitCountSize = bsize+1;
    }
    size_t ret = block_index? bc.m_BlockBitCount[block_index-1]: 0;
    if ( block_offset ) {
        if ( !bc.m_CacheBlockBitCount ) {
            bc.m_CacheBlockBitCount.reset(new size_t[kBlockSize]);
        }
        if ( block_index != bc.m_CacheBlock ) {
            bc.m_CacheBlock = block_index;
            size_t count = 0;
            size_t block_pos = block_index*kBlockSize;
            size_t block_size = min(kBlockSize, size-block_pos);
            const char* block = &bytes[block_pos];
            for ( size_t i = 0; i < block_size; ++i ) {
                count += sx_CalcByteBitCount(Uint1(block[i]));
                bc.m_CacheBlockBitCount[i] = count;
            }
        }
        ret += bc.m_CacheBlockBitCount[block_offset-1];
    }
    return ret;
}


void CSeqTable_sparse_index::SetBit_set_bvector(const bm::bvector<>* bv)
{
    Reset();
    m_BitVector.reset(bv);
    bm::bvector<>::statistics stat;
    bv->calc_stat(&stat);
    TBit_set_bvector& arr = CSeqTable_sparse_index_Base::SetBit_set_bvector();
    arr.resize(stat.max_serialize_mem);
    bm::word_t* temp_block = bv->allocate_tempblock();
    size_t size = bm::serialize(*bv, (unsigned char*)&arr[0], temp_block);
    free(temp_block);
    arr.resize(size);
}


size_t CSeqTable_sparse_index::size(void) const
{
    x_EnsurePreprocessed();
    if ( IsIndexes() ) {
        const TIndexes& indexes = GetIndexes();
        return indexes.empty()? 0: indexes.back()+1;
    }
    else if ( IsBit_set() ) {
        return GetBit_set().size()*8;
    }
    else {
        return m_BitVector->size();
    }
}


size_t CSeqTable_sparse_index::x_GetFirstSetBitIndex(void) const
{
    x_EnsurePreprocessed();
    if ( IsIndexes() ) {
        const TIndexes& indexes = GetIndexes();
        return indexes.empty()? kInvalidIndex: indexes.front();
    }
    else if ( IsBit_set() ) {
        const TBit_set& bytes = GetBit_set();
        size_t byte_index = sx_FindFirstNonZeroByte(bytes, 0);
        if ( byte_index == kInvalidIndex ) {
            return kInvalidIndex;
        }
        return byte_index*8 + sx_FindFirstNonZeroBit(Uint1(bytes[byte_index]));
    }
    else {
        return m_BitVector->get_first();
    }
    
}


size_t CSeqTable_sparse_index::x_GetNextSetBitIndex(size_t index,
                                                    size_t set_bit_index) const
{
    // x_EnsurePreprocessed(); no need to call ensure - it's already called
    if ( IsIndexes() ) {
        const TIndexes& indexes = GetIndexes();
        if ( ++set_bit_index < indexes.size() ) {
            return indexes[set_bit_index];
        }
        else {
            return kInvalidIndex;
        }
    }
    else if ( IsBit_set() ) {
        const TBit_set& bytes = GetBit_set();
        size_t byte_index = index / 8;
        size_t bit_index = index % 8;
        bit_index = sx_FindNextNonZeroBit(Uint1(bytes[byte_index]), bit_index);
        if ( bit_index != kInvalidIndex ) {
            return byte_index*8 + bit_index;
        }
        byte_index = sx_FindFirstNonZeroByte(bytes, byte_index + 1);
        if ( byte_index == kInvalidIndex ) {
            return kInvalidIndex;
        }
        return byte_index*8 + sx_FindFirstNonZeroBit(Uint1(bytes[byte_index]));
    }
    else {
        index = m_BitVector->get_next(index);
        return index? index: kInvalidIndex;
    }
}


size_t CSeqTable_sparse_index::GetIndexAt(size_t index) const
{
    x_EnsurePreprocessed();
    if ( IsIndexes() ) {
        const TIndexes& indexes = GetIndexes();
        TIndexes::const_iterator iter =
            lower_bound(indexes.begin(), indexes.end(), index);
        if ( iter != indexes.end() && *iter == index ) {
            return iter - indexes.begin();
        }
        else {
            return kSkipped;
        }
    }
    else if ( IsBit_set() ) {
        const TBit_set& bytes = GetBit_set();
        size_t byte_index = index/8;
        if ( byte_index >= bytes.size() ) {
            return kSkipped;
        }
        Uint1 byte = bytes[byte_index];
        size_t bit_index = index%8; // most significant bit has index 0
        if ( !((byte<<bit_index)&0x80) ) {
            return kSkipped;
        }
        size_t count = sx_CalcByteBitCount(Uint1(byte>>(8-bit_index)));
        if ( byte_index ) {
            count += x_GetBytesBitCount(byte_index);
        }
        return count;
    }
    else {
        if ( !m_BitVector->get_bit(index) ) {
            return kSkipped;
        }
        return index == 0? 0: m_BitVector->count_range(0, index-1);
    }
}


bool CSeqTable_sparse_index::IsSelectedAt(size_t index) const
{
    x_EnsurePreprocessed();
    if ( IsIndexes() ) {
        const TIndexes& indexes = GetIndexes();
        TIndexes::const_iterator iter =
            lower_bound(indexes.begin(), indexes.end(), index);
        return iter != indexes.end() && *iter == index;
    }
    else if ( IsBit_set() ) {
        const TBit_set& bits = GetBit_set();
        size_t i = index/8;
        if ( i >= bits.size() ) {
            return false;
        }
        size_t j = index%8;
        return ((bits[i]<<j)&0x80) != 0;
    }
    else {
        return m_BitVector->get_bit(index);
    }
}


void CSeqTable_sparse_index::ChangeTo(E_Choice type)
{
    switch ( type ) {
    case e_Indexes:
        ChangeToIndexes();
        break;
    case e_Indexes_delta:
        ChangeToIndexes_delta();
        break;
    case e_Bit_set:
        ChangeToBit_set();
        break;
    case e_Bit_set_bvector:
        ChangeToBit_set_bvector();
        break;
    default:
        NCBI_THROW(CSeqTableException, eOtherError,
                   "requested sparse index type is invalid");
    }
}


void CSeqTable_sparse_index::ChangeToIndexes(void)
{
    if ( IsIndexes() ) {
        return;
    }
    TIndexes indexes;
    if ( IsIndexes_delta() ) {
        indexes.swap(SetIndexes_delta());
        size_t index = 0;
        NON_CONST_ITERATE ( TIndexes, it, indexes ) {
            index += *it;
            *it = index;
        }
    }
    else {
        for ( const_iterator it = begin(); it; ++it ) {
            indexes.push_back(it.GetIndex());
        }
    }
    Reset();
    SetIndexes().swap(indexes);
}


void CSeqTable_sparse_index::ChangeToIndexes_delta(void)
{
    if ( IsIndexes_delta() ) {
        return;
    }
    TIndexes_delta indexes;
    if ( IsIndexes() ) {
        indexes.swap(SetIndexes());
        size_t prev_index = 0;
        NON_CONST_ITERATE ( TIndexes_delta, it, indexes ) {
            size_t index = *it;
            *it = index - prev_index;
            prev_index = index;
        }
    }
    else {
        size_t prev_index = 0;
        for ( const_iterator it = begin(); it; ++it ) {
            size_t index = it.GetIndex();
            indexes.push_back(index-prev_index);
            prev_index = index;
        }
    }
    Reset();
    SetIndexes_delta().swap(indexes);
}



void CSeqTable_sparse_index::ChangeToBit_set(void)
{
    if ( IsBit_set() ) {
        return;
    }
    TBit_set bytes;
    size_t last_byte_index = 0;
    Uint1 last_byte = 0;
    for ( const_iterator it = begin(); it; ++it ) {
        size_t index = it.GetIndex();
        size_t byte_index = index / 8;
        if ( byte_index != last_byte_index ) {
            if ( bytes.capacity() < byte_index+1 ) {
                bytes.reserve(max(bytes.capacity(), byte_index+1)*2);
            }
            bytes.resize(last_byte_index);
            bytes.push_back(last_byte);
            last_byte_index = byte_index;
            last_byte = 0;
        }
        size_t bit_index = index % 8;
        last_byte |= 0x80 >> bit_index;
    }
    if ( last_byte ) {
        bytes.reserve(last_byte_index+1);
        bytes.resize(last_byte_index);
        bytes.push_back(last_byte);
    }
    Reset();
    SetBit_set() = bytes;
}



void CSeqTable_sparse_index::ChangeToBit_set_bvector(void)
{
    if ( IsBit_set_bvector() ) {
        return;
    }
    AutoPtr<bm::bvector<> > bv(new bm::bvector<>);
    for ( const_iterator it = begin(); it; ++it ) {
        size_t index = it.GetIndex();
        bv->set_bit(index);
    }
    bv->optimize();
    SetBit_set_bvector(bv.release());
}



END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE
