/***************************************************************************
                          gnuupload.h  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#if !defined(__GNUUPLOAD_H_INCLUDED__)
#define __GNUUPLOAD_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// MGnuUpload

class MGnuDirector;
class MGnuShare;
class MGnuPreferences;
class MAsyncFile;

struct SGnuUpload
{
	CString m_sFileName;
	int     m_nFileIndex;
	int     m_nFileLength;
	int     m_nBytesCompleted;
	int     m_nChangeTime;
	int     m_nStatus;
	int     m_nError;
	// remote peer info
	IP      m_ipHost;
	UINT    m_nPort;
	//
	CString m_sHandshake;
	// bandwidth
	double m_dRate;
	// numeric ID
	DWORD  m_dwID;
	// few static methods
	static LPCSTR GetErrorString(int nError);
};

#define UPLERR_NONE         0
#define UPLERR_NODATA       1
#define UPLERR_SOCKET_EROR  2
#define UPLERR_BAD_PUSH     3
#define UPLERR_BUSY         4
#define UPLERR_NOT_FOUND    5
#define UPLERR_REM_CANCELED 6
#define UPLERR_CONNECT_FAIL 7
#define UPLERR_BAD_REQUEST  8
#define UPLERR_NO_RESPONSE  10
#define UPLERR_TOO_SLOW 11


class MGnuUpload : public MAsyncSocket, public SGnuUpload
{
// Attributes
public:

// Operations
public:
	MGnuUpload(MGnuDirector*);
	virtual ~MGnuUpload();

	void PushFile();
	void UploadFile(CString sHandshake, bool bLock = true);
	
	void Send_HttpOK();
	void Send_HttpBusy();
	void Send_HttpNotFound();

	void StatusUpdate(DWORD);
	void BandwidthTimer();
	void ForceDisconnect();
	void UpdateSelectFlags();
	void SetMaxRate(double dMR){m_dMaxRate = dMR;}
public:
	MMutex m_mutex;
protected:
	MAsyncFile* m_pAFile;
	// File info

	// Bandwidth
	DWORD  m_dwBytes60;      // Bytes received in past 60 seconds
	DWORD  m_dwSecBytes;     // Bytes sent in last second
	int    m_nSecNum;	     // Number of elements in array
	int    m_nSecsUnderLimit;
	int	   m_nSecsDead;
	double m_dMaxRate;
	//
	int    m_nFileIndexPush;
	CString m_sFilePath;
	
	bool   m_bBelowRateLimit;
	bool   m_bBufferReady;

	MGnuDirector* m_pDirector;
// Overrides
public:
	public:
	virtual void OnClose(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnReceive(int nErrorCode);
	virtual void OnSend(int nErrorCode);
	
// async file notifiers
	void OnFileOpen(bool bLock = true);
	void OnFileRead(int Requested, int nRead, int nError);
	void OnFileError(int nError);
protected:
	MGnuUpload();                        // no implementation
	MGnuUpload(const MGnuUpload& rSrc);  // no implementation
	
// Implementation
protected:	
	MGnuShare*    m_pShare;
	MGnuPreferences* m_pPrefs;
	
	// Bandwidth
	DWORD m_dwAvgBytes[60]; // Average bytes from last 60 seconds
	int	  m_nSecPos;        // Position of next element insert
};

/////////////////////////////////////////////////////////////////////////////

#endif // __GNUUPLOAD_H_INCLUDED__
