/***************************************************************************
                          gnushare.cpp  -  implementation of the MGnuShare class
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

// the original version of this file was taken from Gnucleus (http://gnucleus.sourceforge.net)

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "controller.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <ctype.h>

#include "preferences.h"

#include "gnuhash.h"
#include "gnudirector.h"
#include "gnunode.h"
#include "gnushare.h"
#include "dir.h"
#include "asyncfile.h"
#include "event.h"

class MShareThread : public MThread {
public:
	MShareThread(MGnuShare* pS){m_pShare=pS;m_dwTotalFiles = 0;m_dwTotalSize  = 0;}
	~MShareThread()
	{
		ASSERT(finished());
	}
	// interlocked syncronous operations
	CString GetPath(DWORD);
	void AddSharedDir(CString path, bool bDeep);
	void ResetSharedDirs();
	//
	//bool GetFile(DWORD index, CString &file, int* phUploadFile, bool bCheckName);
	bool GetFile(DWORD index, CString &file, CString &filePath, bool bCheckName);
	void    GetShareCopy(std::vector<SharedFile>&);
	// delayed operations
	void PostQuery(QueryComp* pCompare){
		MLock lock(m_queuemutex);
		if ( !m_PendingQueries.push(pCompare) )
		{
			//TRACE3("PostQuery: dropping a query `",pCompare->Query,"'");
			// TODO: LogError
			delete pCompare;
			return;
		}
		m_Trigger.wakeAll(); }
	void PostMessage(DWORD dwMessage){
		MLock lock(m_queuemutex);
		m_PendingMessages.push(dwMessage);
		m_Trigger.wakeAll();
	}
	void StopThread(){
		MLock lock(m_queuemutex);
		m_PendingMessages.push(SHARE_STOP);
		m_Trigger.wakeAll();
		wait(&m_queuemutex);
	}
protected:	
	void LoadFiles();
	void RecurseLoad(CString, CString, bool, DWORD &, long long &);
private:
	MMutex m_queuemutex;
	MWaitCondition m_Trigger;
	std::queue<DWORD>     m_PendingMessages;
	TSimpleQueue<QueryComp*> m_PendingQueries;
	
	MMutex m_filesmutex;
	std::vector<SharedFile> m_SharedFiles;   // Each shared file
	std::vector<SharedDirectory> m_SharedDirectories;
	DWORD m_dwTotalFiles;
	DWORD m_dwTotalSize;

	MGnuShare*   m_pShare;
	
	MShareThread();
	void run();
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MGnuShare::MGnuShare(MGnuDirector* pCntr)
{	
	m_pDirector = pCntr;

	m_dwTotalFiles = 0;
	m_dwTotalSize  = 0;
	m_pDirector->AttachShare(this);
	m_pSearchSharedThread = NULL;
}

MGnuShare::~MGnuShare()
{
	m_pDirector->DetachShare(this);
	if (m_pSearchSharedThread->finished())
		delete m_pSearchSharedThread;
	else
	{
		TRACE("WARNING: failed to stop search thread");
	}

//	SharedDirectories.clear();	
//	SharedFiles.clear();
}

void MGnuShare::AppendQuery(QueryComp* pCompare)
{
	m_pSearchSharedThread->PostQuery(pCompare);
}

void MGnuShare::InitShare()
{
	m_pSearchSharedThread = new MShareThread(this);
	m_pSearchSharedThread->start();
	//sleep(1);
	//m_pSearchSharedThread->AddSharedDir("/mnt/mp3",true);
	//m_pSearchSharedThread->AddSharedDir("/data/nmr2/mz/Data/russian-music",true);
	if (strlen(m_pDirector->GetPrefs()->m_szSharePath))
	{
		m_pSearchSharedThread->AddSharedDir(m_pDirector->GetPrefs()->m_szSharePath,true);
		m_pSearchSharedThread->PostMessage(SHARE_LOAD);
	}
}

void MGnuShare::CloseShare()
{
	TRACE("Stoping search thread...");
	m_pSearchSharedThread->StopThread();
}

void MGnuShare::Rescan()
{
	m_pSearchSharedThread->ResetSharedDirs();
	m_pSearchSharedThread->AddSharedDir(m_pDirector->GetPrefs()->m_szSharePath,true);
	m_pSearchSharedThread->PostMessage(SHARE_LOAD);
}

void MGnuShare::ResetDirectories(DWORD &EventCount, LPHANDLE EventList)
{
	// Close wait events on all directories
	assert(0);
	/*for(int i = 1; i < EventCount; i++)
		FindCloseChangeNotification( EventList[i]);

	EventCount = 1;

	// Reset partial watch
	CString PartialPath = m_pDoc->m_pPrefs->m_PartialsInDir ? m_pDoc->m_pPrefs->m_DownloadPath + "\\Partials" : ".\\Partials";
	EventList[1] = FindFirstChangeNotification(PartialPath, false, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME);

	if(EventList[1] != INVALID_HANDLE_VALUE)
		EventCount++;

	// Reset wait events on all shared directories
	for(i = 0; i < SharedDirectories.size(); i++)
	{
		if(EventCount >= MAX_EVENTS)
			break;

		EventList[EventCount] = FindFirstChangeNotification(SharedDirectories[i].Name, SharedDirectories[i].Recursive, FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME);

		if(EventList[EventCount] != INVALID_HANDLE_VALUE)
			EventCount++;
	}*/
}

void MShareThread::AddSharedDir(CString path, bool bDeep)
{
	MLock lock(m_filesmutex);
	SharedDirectory sd;	
	sd.Name = ExpandPath(path);
	sd.Recursive = bDeep;
	sd.Size = 0;
	sd.FileCount = 0;
	
	m_SharedDirectories.push_back(sd);
}

void MShareThread::ResetSharedDirs()
{
	MLock lock(m_filesmutex);
	
	m_SharedDirectories.clear();
}

void MShareThread::LoadFiles()
{
	MLock lock(m_filesmutex);
	
	m_SharedFiles.clear();
	m_dwTotalFiles = 0;
	m_dwTotalSize  = 0;

	for(int i = 0; i < m_SharedDirectories.size(); i++)
	{
		m_SharedDirectories[i].FileCount = 0;
		m_SharedDirectories[i].Size = 0;
		RecurseLoad(m_SharedDirectories[i].Name, "", m_SharedDirectories[i].Recursive, m_SharedDirectories[i].FileCount, m_SharedDirectories[i].Size);
		m_dwTotalFiles += m_SharedDirectories[i].FileCount;
		m_dwTotalSize  += m_SharedDirectories[i].Size/1024;
	}
	
	m_pShare->m_dwTotalFiles = m_dwTotalFiles;
	m_pShare->m_dwTotalSize = m_dwTotalSize;
	//
	CString stmp;
	stmp.format("scanned %d directories... %d files %d Mbytes", m_SharedDirectories.size(), m_dwTotalFiles, m_dwTotalSize/1024);
	POST_MESSAGE(ES_GOODTOKNOW, stmp);
	// TODO: Send the propper message with all the info, etc, or at least with proper message ID
}

void MShareThread::RecurseLoad(CString FullPath, CString DirPath, bool doRecurse, DWORD &DirCount, long long &DirSize)
{
    DirEntryVec files;
    if (!ScanDir(files, FullPath, "", DirEntry::regular|DirEntry::dir))
    {
    	// TODO: messageID
    	POST_ERROR(ES_GOODTOKNOW, CString("RecurseLoad: error scanning the dir ") + FullPath);
    	return;
    }
    if (!files.size())
    {
    	// TODO: messageID
    	POST_ERROR(ES_UNIMPORTANT, CString("RecurseLoad: no files at ") + FullPath);
    	return;
    }
    for (int i = 0; i<files.size(); ++i)
    {
        //printf("\t%s\n",ppDirEntList[i]->d_name);
    	if (files[i].Type & DirEntry::dir)
    	{
    		if(doRecurse)
				RecurseLoad(files[i].Path, DirPath + "/" + files[i].Name, true, DirCount, DirSize);
    	}
    	else if (files[i].Type & DirEntry::regular)
    	{
    		DWORD   FileSize = files[i].Size;
			CString FileName = files[i].Name;
			CString FilePath  = files[i].Path;

			if(m_pShare->m_pDirector->GetPrefs()->m_bReplyFilePath && DirPath.length())
				FileName = DirPath + "/" + FileName;

			// some cleanups
			if(FileName[0] == '/')
				FileName = FileName.substr(1);

			// Make a file item
			SharedFile addFile;
			addFile.Path    = FilePath;
			addFile.Name	= FileName;
			MakeLower(FileName);
			addFile.NameLower   = FileName;
			addFile.Size		= FileSize;
			addFile.Matches		= 0;
			addFile.Uploads		= 0;

			m_SharedFiles.push_back(addFile);

			DirCount++;
			DirSize += FileSize;
    	}
    }
}

/*void MGnuShare::StopShare(DWORD dwFileIndex)
{
	SharedFiles[dwFileIndex].Name = "";
	SharedFiles[dwFileIndex].NameLower = "";
	SharedFiles[dwFileIndex].Dir = "";
}*/

CString MGnuShare::GetPath(DWORD index)
{
	return m_pSearchSharedThread->GetPath(index);
}

CString MShareThread::GetPath(DWORD index)
{
	std::vector<SharedFile>::iterator itFile;
	
    assert(0);
    /*
	CSingleLock QueueAccess(&m_QueueAccess);
	QueueAccess.Lock();

	if(QueueAccess.IsLocked())
	{
		DWORD i = 0;
		for (itFile = SharedFiles.begin(); itFile != SharedFiles.end(); itFile++)
		{
			if(index == i) 
				if((*itFile).Dir.c_str() != "")
				{
					QueueAccess.Unlock();
					return (*itFile).Dir.c_str();
				}
				else
				{
					QueueAccess.Unlock();
					return "";
				}

			i++;
		}

		QueueAccess.Unlock();
	}

	*/
	return "";
}

CString MGnuShare::GetRandString(CString Original)
{
	assert(0);
	/*if(SharedFiles.size())
	{
		int randpos = rand() % SharedFiles.size() + 0;

		CString FileName(SharedFiles[randpos].Name.c_str());

		// break it up into strings
		std::vector<CString> StringList;
		
		int pos = 0;
		while(FileName.Find(" ", pos) != -1)
		{
			CString newString = FileName.Mid(pos, FileName.Find(" ", pos) - pos);
			StringList.push_back(newString);

			pos = FileName.Find(" ", pos) + 1;
		}

		if(StringList.size())
		{	
			int listpos = rand() % StringList.size() + 0;

			CString test = StringList[listpos];

			if(StringList[listpos].GetLength() > 2)
				return StringList[listpos];
		}
	}*/

	return Original;
}

void MGnuShare::GetShareCopy(std::vector<SharedFile>& ShareCopy)
{
	m_pSearchSharedThread->GetShareCopy(ShareCopy);
}

void MShareThread::GetShareCopy(std::vector<SharedFile>& ShareCopy)
{
	MLock FilesAccess(m_filesmutex);
	ShareCopy = m_SharedFiles; //TODO: check if it really copies the list, not just references it
}

/*bool MGnuShare::GetFile(DWORD index, CString &file, int* phUploadFile, bool bCheckName)
{
	return m_pSearchSharedThread->GetFile(index, file, phUploadFile, bCheckName);
}*/

bool MGnuShare::GetFile(DWORD index, CString &file, CString &filePath, bool bCheckName)
{
	return m_pSearchSharedThread->GetFile(index, file, filePath, bCheckName);
}

/*bool MShareThread::GetFile(DWORD index, CString &fileName, int* phUploadFile, bool bCheckName)
{
	std::vector<SharedFile>::iterator itFile;
	ASSERT(phUploadFile);
	
	CString file = fileName;
	MakeLower(file);
	ReplaceSubStr(file,"\\","/");// for Windows dudes
	ReplaceSubStr(file,"//","/");// for any case
	DWORD i = 0;
	MLock FilesAccess(m_filesmutex);
	for (itFile = m_SharedFiles.begin(); itFile != m_SharedFiles.end(); itFile++)
	{
		if(index == i)
		{
			if (bCheckName && file != (*itFile).NameLower)
			{
				// lets give them one more chance -- some clients ignore the directory path
				CString s = (*itFile).NameLower;
				s = s.substr(s.rfind("/")+1);
				if (file != s)
				{
					//printf("GetFile: missmatched names '%s' and'%s'\n", file.c_str(), s.c_str());
					return false;
				}
			}
			if ( 0<= ((*phUploadFile)=open((*itFile).Path.c_str(), O_RDONLY|O_NONBLOCK)) )
			{
				(*itFile).Uploads++; // TODO: this is not correct for pushes
				//printf("GetFile: uploading '%s'\n", (*itFile).Name.c_str()); // the same
				if (!bCheckName)
					fileName = (*itFile).Name;
				return true;
			}
			// TODO: messageID
			printf("GetFile: failed to open '%s'\n", (*itFile).Path.c_str());
		}
		i++;
	}
	//printf("GetFile: wrong index\n");
	return false;
}*/

bool MShareThread::GetFile(DWORD index, CString &fileName, CString &filePath, bool bCheckName)
{
	std::vector<SharedFile>::iterator itFile;
	
	CString file = fileName;
	MakeLower(file);
	ReplaceSubStr(file,"\\","/");// for Windows dudes
	ReplaceSubStr(file,"//","/");// for any case
	DWORD i = 0;
	MLock FilesAccess(m_filesmutex);
	for (itFile = m_SharedFiles.begin(); itFile != m_SharedFiles.end(); itFile++)
	{
		if(index == i)
		{
			if (bCheckName && file != (*itFile).NameLower)
			{
				// lets give them one more chance -- some clients ignore the directory path
				CString s = (*itFile).NameLower;
				s = s.substr(s.rfind("/")+1);
				if (file != s)
				{
					//printf("GetFile: missmatched names '%s' and'%s'\n", file.c_str(), s.c_str());
					return false;
				}
			}
			(*itFile).Uploads++; // TODO: this is not correct for pushes
			filePath = (*itFile).Path;
			if (!bCheckName)
				fileName = (*itFile).Name;
			return true;
		}
		i++;
	}
	//printf("GetFile: wrong index\n");
	return false;
}

// hack to use basic_strings in queue, =( 
//struct EncapString {
//	CString str;
//};

void MShareThread::run()
{
	ASSERT(m_pShare);
	MGnuDirector*  pComm  = m_pShare->m_pDirector;;

	BYTE* QueryReply = new BYTE[65000]; // 1000 bytes extra for overrun
	
	std::vector<char*> QWords;
	std::vector<char*>::iterator itWord;
	int nQLen;
	char c;
	char* szWord;
	int i;

	std::vector<SharedFile>::iterator itFile;
	bool bNothingToDo;
	sleep(1);
	for(;;)
	{
		m_queuemutex.lock();
		bNothingToDo = m_PendingQueries.size()==0 && m_PendingMessages.size()==0;
		// Waiting for an event to be triggered, once it is, reload
		if (bNothingToDo)
			m_Trigger.wait(&m_queuemutex);
		// mutex is still locked at this point

		if(m_PendingMessages.size())
		{
			DWORD dwMessage = m_PendingMessages.front();
			m_PendingMessages.pop();
			
			m_queuemutex.unlock();
				
			switch(dwMessage)
			{
				case SHARE_LOAD:
					//pShare->ResetDirectories(EventCount, EventList);
					LoadFiles();
					//pShare->ShareMessage(WM_COMMAND, SHARE_RELOAD);
					break;
				case SHARE_STOP:
					delete [] QueryReply;
					return;
			}
			m_queuemutex.lock();
		}
		// mutex is still locked at this point
		// Pending queries to be compared with shared files
		while( m_PendingQueries.size() && m_PendingMessages.size()==0 )
		{
			QueryComp* pSearchQuery = m_PendingQueries.front();
			m_PendingQueries.pop();
			m_queuemutex.unlock();
			
			//printf("MShareThread: query = `%s'\n", pSearchQuery->Query);

			// Dont send results if no upload slots available
			/*if( (!pComm->GetPrefs()->m_bSendOnlyAvail) ||
			    pComm->GetPrefs()->m_nMaxUploads < 0   ||
			    pComm->CountUploading() < pComm->GetPrefs()->m_nMaxUploads )*/
			{
				// Clear word list
				QWords.clear();
				nQLen = strlen(pSearchQuery->Query);
				ASSERT(nQLen <= MAX_QUERY_LEN);
				// Break Query into individual words
				MakeWordList(pSearchQuery->Query, QWords);
				// Filter out searches for file types
				// or other crap which causes flood
				if( QWords.size() >= 1 &&
				    (QWords.size() > 1 || strlen(QWords[0]) > 3) )
				{
					// Search files
					BYTE* QueryReplyNext	= QueryReply;
					DWORD QueryReplyLength	= 0;
					BYTE  ReplyCount		= 0;
					bool  QueryMatch		= false;
					int i					= 0;
					MLock lock(m_filesmutex);

					for(itFile = m_SharedFiles.begin(); itFile != m_SharedFiles.end(); itFile++)
					{
						// if matched -- add to search reply
						if(MatchWordList((*itFile).NameLower, QWords))
						{
							if(pComm->GetPrefs()->m_nMaxReplies >= 0)
								if(pComm->GetPrefs()->m_nMaxReplies <= ReplyCount)	
									break;
							if(QueryReplyLength > 64000)
								break;
							
							ReplyCount++;
							(*itFile).Matches++;
							
							packet_QueryHitItem* pQHI = (packet_QueryHitItem*) QueryReplyNext;
							pQHI->le_Index = i;
							pQHI->le_Size = (*itFile).Size;
							
							QueryReplyNext   += 8;
							QueryReplyLength += 8;
							
							strcpy ((char*) QueryReplyNext, (*itFile).Name.c_str());
							QueryReplyNext   += (*itFile).Name.size() + 1;
							QueryReplyLength += (*itFile).Name.size() + 1;
							*QueryReplyNext = '\0';
							QueryReplyNext++;
							QueryReplyLength++;
						}
						i++;
					}
					
					// Send reply
					if(ReplyCount > 0)
					{
						pComm->Post_QueryHit(pSearchQuery, QueryReply, QueryReplyLength, ReplyCount);
						// too many quiery replies cause remote nodes to disconnect
						::usleep(100000); //100ms
					}
				}
			}
			//
			delete pSearchQuery;
			// kinda hack, but this effectively limits number of searches to ~30 per second
			::usleep(10000); //10ms
			m_queuemutex.lock();
		}
		m_queuemutex.unlock();
	}
}
