/*
 * Header of the proxy around Rhythmbox's D-Bus interface.
 *
 * Music Applet
 * Copyright (C) 2004-2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_RHYTHMBOX_DBUS_PROXY_H
#define MA_RHYTHMBOX_DBUS_PROXY_H

#include "ma-dbus-proxy.h"

#define MA_TYPE_RHYTHMBOX_DBUS_PROXY		(ma_rhythmbox_dbus_proxy_get_type ())
#define MA_RHYTHMBOX_DBUS_PROXY(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_RHYTHMBOX_DBUS_PROXY, MaRhythmboxDBusProxy))
#define MA_RHYTHMBOX_DBUS_PROXY_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_RHYTHMBOX_DBUS_PROXY, MaRhythmboxDBusProxyClass))
#define MA_IS_RHYTHMBOX_DBUS_PROXY(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_RHYTHMBOX_DBUS_PROXY))
#define MA_IS_RHYTHMBOX_DBUS_PROXY_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_RHYTHMBOX_DBUS_PROXY))
#define MA_RHYTHMBOX_DBUS_PROXY_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_RHYTHMBOX_DBUS_PROXY, MaRhythmboxDBusProxyClass))

typedef struct _MaRhythmboxDBusProxy		MaRhythmboxDBusProxy;
typedef struct _MaRhythmboxDBusProxyClass	MaRhythmboxDBusProxyClass;

struct _MaRhythmboxDBusProxy
{
	MaDBusProxy parent;
};

struct _MaRhythmboxDBusProxyClass
{
	MaDBusProxyClass parent_class;
};

GType		ma_rhythmbox_dbus_proxy_get_type (void);

MaProxy *	ma_rhythmbox_dbus_proxy_new (MaConf *conf);

#endif /* MA_RHYTHMBOX_DBUS_PROXY_H */
