/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.io.MixedDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.slog2.BufForDrawables;
import logformat.slog2.BufForShadows;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;

public class TreeNode
extends BufForDrawables {
    private List shadowbufs = new ArrayList();
    private boolean haveShadowBufsBeenSaved = false;
    private BufForShadows shadowbuf = null;
    private Map shadowdefs_map = null;
    private TreeNode childnode = null;

    public TreeNode() {
        super(true);
    }

    public TreeNode(TreeNode treeNode) {
        this();
        this.childnode = treeNode;
    }

    private void ensureNonNullShadowBuf() {
        if (this.shadowbuf == null) {
            this.shadowbuf = new BufForShadows(true);
            this.shadowbuf.setMapOfTopologyToShadowDef(this.shadowdefs_map);
        }
    }

    public void setTreeNodeID(TreeNodeID treeNodeID) {
        super.setTreeNodeID(treeNodeID);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setTreeNodeID(treeNodeID);
    }

    public void setMapOfTopologyToShadowDef(Map map) {
        this.shadowdefs_map = map;
    }

    public void add(Drawable drawable) {
        if (drawable instanceof Composite) {
            Composite composite = (Composite)drawable;
            Primitive[] primitiveArray = null;
            if (composite.getCategory() != null) {
                super.add(composite);
                this.ensureNonNullShadowBuf();
                primitiveArray = composite.getPrimitives();
                for (int i = 0; i < primitiveArray.length; ++i) {
                    this.shadowbuf.add(primitiveArray[i]);
                }
            } else {
                this.ensureNonNullShadowBuf();
                primitiveArray = composite.getPrimitives();
                for (int i = 0; i < primitiveArray.length; ++i) {
                    super.add(primitiveArray[i]);
                    this.shadowbuf.add(primitiveArray[i]);
                }
            }
        } else {
            Primitive primitive = (Primitive)drawable;
            super.add(primitive);
            this.ensureNonNullShadowBuf();
            this.shadowbuf.add(primitive);
        }
    }

    public void empty() {
        if (this.childnode != null && this.childnode.haveShadowBufsBeenSaved) {
            Iterator iterator = this.childnode.shadowbufs.iterator();
            while (iterator.hasNext()) {
                ((BufForShadows)iterator.next()).empty();
            }
            this.childnode.shadowbufs.clear();
            this.childnode.haveShadowBufsBeenSaved = false;
        }
        super.empty();
    }

    public void finalizeLatestTime(Drawable drawable) {
        if (this.childnode == null) {
            super.setLatestTime(drawable.getLatestTime());
        } else {
            super.setLatestTime(this.childnode.getLatestTime());
        }
        if (this.shadowbuf != null) {
            this.shadowbuf.setLatestTime(super.getLatestTime());
            this.shadowbuf.initializeMapOfCategoryWeights();
        }
    }

    public void mergeVerticalShadowBufs() {
        if (this.childnode != null) {
            Iterator iterator = this.childnode.shadowbufs.iterator();
            while (iterator.hasNext()) {
                BufForShadows bufForShadows = (BufForShadows)iterator.next();
                this.shadowbuf.mergeWith(bufForShadows);
                this.shadowbuf.affectTimeBounds(bufForShadows);
            }
        }
    }

    public void shiftHorizontalShadowBuf() {
        if (this.shadowbuf != null) {
            this.shadowbuf.finalizeMapOfCategoryWeights();
            this.shadowbufs.add(this.shadowbuf);
            this.shadowbuf = null;
        }
    }

    public void affectEarliestTime(double d) {
        super.affectEarliestTime(d);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.affectEarliestTime(d);
    }

    public void setEarliestTime(double d) {
        super.setEarliestTime(d);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setEarliestTime(d);
    }

    public void setFileBlockPtr(long l, int n) {
        super.setFileBlockPtr(l, n);
        this.ensureNonNullShadowBuf();
        this.shadowbuf.setFileBlockPtr(l, n);
    }

    public int getNodeByteSize() {
        int n = super.getByteSize() + 4;
        if (this.childnode != null) {
            Iterator iterator = this.childnode.shadowbufs.iterator();
            while (iterator.hasNext()) {
                BufForShadows bufForShadows = (BufForShadows)iterator.next();
                n += bufForShadows.getByteSize();
            }
        }
        return n;
    }

    public LineIDMap getIdentityLineIDMap() {
        LineIDMap lineIDMap = super.getIdentityLineIDMap();
        if (this.childnode != null) {
            Iterator iterator = this.childnode.shadowbufs.iterator();
            while (iterator.hasNext()) {
                BufForShadows bufForShadows = (BufForShadows)iterator.next();
                lineIDMap.putAll(bufForShadows.getIdentityLineIDMap());
            }
        }
        lineIDMap.setTitle("Identity Map");
        lineIDMap.setColumnLabels(new String[]{"LineID"});
        return lineIDMap;
    }

    public void summarizeCategories() {
        if (this.shadowbuf != null) {
            throw new RuntimeException("UnexpectedError: shadowbuf is NOT NULL! Aborting...");
        }
        if (this.shadowbufs.size() != 1) {
            throw new RuntimeException("UnexpectedError: shadowbufs[]'s size is " + this.shadowbufs.size() + "! Aborting...");
        }
        this.shadowbuf = (BufForShadows)this.shadowbufs.get(0);
        this.shadowbuf.summarizeCategories();
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        super.writeObject(mixedDataOutput);
        if (this.childnode != null) {
            mixedDataOutput.writeInt(this.childnode.shadowbufs.size());
            Iterator iterator = this.childnode.shadowbufs.iterator();
            while (iterator.hasNext()) {
                ((BufForShadows)iterator.next()).writeObject(mixedDataOutput);
            }
            this.childnode.haveShadowBufsBeenSaved = true;
        } else {
            mixedDataOutput.writeInt(0);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\t*** Start of TreeNode ***\n");
        stringBuffer.append(super.toString() + "\n");
        if (this.childnode != null) {
            Iterator iterator = this.childnode.shadowbufs.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                BufForShadows bufForShadows = (BufForShadows)iterator.next();
                stringBuffer.append("\t BufForShadows No. " + n + "\n");
                stringBuffer.append(bufForShadows + "\n");
                ++n;
            }
        }
        stringBuffer.append("\t*** End of TreeNode ***\n");
        return stringBuffer.toString();
    }

    public String toStringForInput() {
        StringBuffer stringBuffer = new StringBuffer("\t*** Start of TreeNode ***\n");
        stringBuffer.append(super.toString() + "\n");
        Iterator iterator = this.shadowbufs.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            BufForShadows bufForShadows = (BufForShadows)iterator.next();
            stringBuffer.append("\t BufForShadows No. " + n + "\n");
            stringBuffer.append(bufForShadows + "\n");
            ++n;
        }
        stringBuffer.append("\t*** End of TreeNode ***\n");
        return stringBuffer.toString();
    }
}

