/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.io.MixedRandomAccessFile;
import java.io.IOException;
import logformat.slog2.FileBlockPtr;

public class Header {
    public static final int BYTESIZE = MixedRandomAccessFile.getStringByteSize("SLOG 2.0.5") + 2 + 4 + 2 + 4 + 84;
    private String version_ID = "SLOG 2.0.5";
    private short num_children_per_node = (short)2;
    private int treeleaf_bytesize = 65536;
    private short max_treedepth = 0;
    private int max_buffer_bytesize = 0;
    public FileBlockPtr blockptr2categories = new FileBlockPtr();
    public FileBlockPtr blockptr2methoddefs = new FileBlockPtr();
    public FileBlockPtr blockptr2lineIDmaps = new FileBlockPtr();
    public FileBlockPtr blockptr2treeroot = new FileBlockPtr();
    public FileBlockPtr blockptr2treedir = new FileBlockPtr();
    public FileBlockPtr blockptr2annotations = new FileBlockPtr();
    public FileBlockPtr blockptr2postamble = new FileBlockPtr();

    public Header() {
    }

    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        mixedDataOutput.writeString(this.version_ID);
        mixedDataOutput.writeShort(this.num_children_per_node);
        mixedDataOutput.writeInt(this.treeleaf_bytesize);
        mixedDataOutput.writeShort(this.max_treedepth);
        mixedDataOutput.writeInt(this.max_buffer_bytesize);
        this.blockptr2categories.writeObject(mixedDataOutput);
        this.blockptr2methoddefs.writeObject(mixedDataOutput);
        this.blockptr2lineIDmaps.writeObject(mixedDataOutput);
        this.blockptr2treeroot.writeObject(mixedDataOutput);
        this.blockptr2treedir.writeObject(mixedDataOutput);
        this.blockptr2annotations.writeObject(mixedDataOutput);
        this.blockptr2postamble.writeObject(mixedDataOutput);
    }

    public Header(MixedDataInput mixedDataInput) throws IOException {
        this();
        this.readObject(mixedDataInput);
    }

    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        short s = (short)"SLOG 2.0.5".length();
        this.version_ID = mixedDataInput.readStringWithLimit(s);
        this.num_children_per_node = mixedDataInput.readShort();
        this.treeleaf_bytesize = mixedDataInput.readInt();
        this.max_treedepth = mixedDataInput.readShort();
        this.max_buffer_bytesize = mixedDataInput.readInt();
        this.blockptr2categories.readObject(mixedDataInput);
        this.blockptr2methoddefs.readObject(mixedDataInput);
        this.blockptr2lineIDmaps.readObject(mixedDataInput);
        this.blockptr2treeroot.readObject(mixedDataInput);
        this.blockptr2treedir.readObject(mixedDataInput);
        this.blockptr2annotations.readObject(mixedDataInput);
        this.blockptr2postamble.readObject(mixedDataInput);
    }

    public boolean isSLOG2() {
        return this.version_ID != null && this.version_ID.startsWith("SLOG 2");
    }

    public String getCompatibleVersionMessage() {
        if (this.version_ID != null && this.version_ID.compareTo("SLOG 2.0.5") == 0) {
            return null;
        }
        return "Incompatible Version IDs detected! \nThe logfile's version ID is " + this.version_ID + ",\n" + "but this input program reads logfile of version " + "SLOG 2.0.5" + ".\n";
    }

    public void setTreeLeafByteSize(int n) {
        this.treeleaf_bytesize = n;
    }

    public int getTreeLeafByteSize() {
        return this.treeleaf_bytesize;
    }

    public void setNumChildrenPerNode(short s) {
        this.num_children_per_node = s;
    }

    public short getNumChildrenPerNode() {
        return this.num_children_per_node;
    }

    public void setMaxTreeDepth(short s) {
        this.max_treedepth = s;
    }

    public short getMaxTreeDepth() {
        return this.max_treedepth;
    }

    public void setMaxBufferByteSize(int n) {
        this.max_buffer_bytesize = n;
    }

    public int getMaxBufferByteSize() {
        return this.max_buffer_bytesize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\t SLOG-2 Header:\n");
        stringBuffer.append("version = " + this.version_ID + "\n");
        stringBuffer.append("NumOfChildrenPerNode = " + this.num_children_per_node + "\n");
        stringBuffer.append("TreeLeafByteSize = " + this.treeleaf_bytesize + "\n");
        stringBuffer.append("MaxTreeDepth = " + this.max_treedepth + "\n");
        stringBuffer.append("MaxBufferByteSize = " + this.max_buffer_bytesize + "\n");
        stringBuffer.append("Categories  is " + this.blockptr2categories + "\n");
        stringBuffer.append("MethodDefs  is " + this.blockptr2methoddefs + "\n");
        stringBuffer.append("LineIDMaps  is " + this.blockptr2lineIDmaps + "\n");
        stringBuffer.append("TreeRoot    is " + this.blockptr2treeroot + "\n");
        stringBuffer.append("TreeDir     is " + this.blockptr2treedir + "\n");
        stringBuffer.append("Annotations is " + this.blockptr2annotations + "\n");
        stringBuffer.append("Postamble   is " + this.blockptr2postamble + "\n");
        return stringBuffer.toString();
    }
}

