
/*
 * @(#)comliste.h 1.3 01/01/25
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Fichier d'inclusion  : comliste.h   Auteur               : Mikael CAM
 * Cadre                : Projet Xshow  Membres de l'equipe  : Messieurs
 * FAUCHEUX David, MALIGORNE Christophe,  OLLAGNIER Patrick et CAM Mikael.
 * Superviseur          : M. SADOU Salah Groupe d'audit       : Messieurs
 * ADAM Michel et FRISON Patrice.  Derniere M.A.J.      : 11/4/95
 * 
 * Pour l'IUT de Vannes - Departement INFORMATIQUE
 */

#ifndef __MIMEP_COMLISTE_H__
#define __MIMEP_COMLISTE_H__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../common/option.h"

#define  Command  char*

/* Structures de la liste des parametres des fenetres visibles sur l'ecran
 * source
 */

typedef struct format_com {
    Command c_name;
    struct format_com *suivant;
    struct format_com *precedent;
} format_com;

typedef struct Liste_commands {
    format_com *tete;
    format_com *queue;
    format_com *courant;
} Liste_com;

/* interfaces des fonctions de gestion de la liste des parametres des
 * fenetres visibles sur l'ecran source
 */

void       AjouteListe    (Liste_com *, format_com *);
void       CreeListe      (Liste_com *);
format_com *courant       (Liste_com *);
void       OteEltListe    (Liste_com *, format_com *);
int        FinListe       (Liste_com *);
format_com *position_tete (Liste_com *);
void       remplie_comm   (format_com *, Command, Liste_com *);
format_com *Trouve        (Command, Liste_com *);

#endif /* __MIMEP_COMLISTE_H__ */
