/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.6 2003/08/25 10:09:55 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <pcre.h>

#include "mconfig.h"
#include "mrecord.h"
#include "mio.h"

#define M_FROM_ARRAY_SIZE 4096 /* bit large but better save than sorry for now */

typedef struct {
	char*	id;
	char*	sender;
	int	bytes_in;
	int	nrcpts;
} from_entry;

typedef struct {
	char	*inputfilename;
	
	mfile	inputfile;
	buffer	*buf;

	pcre	*match_syslog_postfix;
	pcre	*match_syslog_amavis;
	pcre	*match_postfix_from;
	pcre	*match_postfix_to;
	pcre	*match_postfix_cleanup;
	pcre	*match_postfix_smtpd;
	pcre	*match_postfix_smtp;
	pcre	*match_postfix_pickup;
	pcre	*match_postfix_time_stamp;
	pcre	*match_postfix_pipe;
	pcre	*match_postfix_reload;
	pcre	*match_postfix_warning;
	pcre	*match_postfix_daemon;
	pcre	*match_postfix_terminating;
	pcre	*match_postfix_dict_eval_action;
	pcre	*match_postfix_dir_forest;
	pcre	*match_postfix_queue;
	pcre_extra	*match_syslog_extra_postfix;
	pcre_extra	*match_syslog_extra_amavis;
	pcre_extra	*match_postfix_extra_from;
	pcre_extra	*match_postfix_extra_to;
	pcre_extra	*match_postfix_extra_cleanup;
	pcre_extra	*match_postfix_extra_smtpd;
	pcre_extra	*match_postfix_extra_smtp;
	pcre_extra	*match_postfix_extra_pickup;
	pcre_extra	*match_postfix_extra_time_stamp;
	pcre_extra	*match_postfix_extra_pipe;
	pcre_extra	*match_postfix_extra_reload;
	pcre_extra	*match_postfix_extra_warning;
	pcre_extra	*match_postfix_extra_daemon;
	pcre_extra	*match_postfix_extra_terminating;
	pcre_extra	*match_postfix_extra_dict_eval_action;
	pcre_extra	*match_postfix_extra_dir_forest;
	pcre_extra	*match_postfix_extra_queue;

	/* Extra stuff to make modlogan keep state during analysis */
	int         from_count;
	from_entry  from_list[ M_FROM_ARRAY_SIZE ];
	
	int         year;
	int         last_month;
	
} config_input;

int mplugins_input_postfix_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
