/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: misc.h,v 1.11 2002/01/01 11:44:50 ostborn Exp $
*/

#ifndef _MISC_H_
#define _MISC_H_

#include <pcre.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include "mconfig.h"


typedef struct {
	char r,g,b;
} rgb_tripple;

int html3torgb3(const char *html3, rgb_tripple * rgb);
int is_htmltripple(const char *col);
char *urlescape(char *url);
char *url_decode(const char *s);
char *url_encode(const char *s);
int hex2int(unsigned char c);
int strmatch(pcre *pattern, pcre_extra *study, const char *str);
char *substitute(mconfig *ext_conf, pcre *match, pcre_extra *study, char *subst, const char *str);

typedef struct {
	struct timeval start_wall;
	struct timeval stop_wall;
	long int span_wall;
	struct rusage start_rusage;
	struct rusage stop_rusage;
	long int span_user;
	long int span_system;
} mtimer;

#define MTIMER_START(x) \
	gettimeofday(&(x.start_wall), NULL); \
	getrusage(RUSAGE_SELF, &(x.start_rusage));

#define MTIMER_STOP(x) \
	gettimeofday(&(x.stop_wall), NULL); \
	getrusage(RUSAGE_SELF, &(x.stop_rusage));

#define MTIMER_CALC(x) \
	x.span_wall += ((x.stop_wall.tv_sec * 1000.0 + x.stop_wall.tv_usec / 1000.0) - (x.start_wall.tv_sec * 1000.0 + x.start_wall.tv_usec / 1000.0)); \
	x.span_user += ((x.stop_rusage.ru_utime.tv_sec * 1000.0 + x.stop_rusage.ru_utime.tv_usec / 1000.0) - (x.start_rusage.ru_utime.tv_sec * 1000.0 + x.start_rusage.ru_utime.tv_usec / 1000.0)); \
	x.span_system += ((x.stop_rusage.ru_stime.tv_sec * 1000.0 + x.stop_rusage.ru_stime.tv_usec / 1000.0) - (x.start_rusage.ru_stime.tv_sec * 1000.0 + x.start_rusage.ru_stime.tv_usec / 1000.0));
	
#define MTIMER_GET_WALL_MSEC(x) \
	x.span_wall
	
#define MTIMER_GET_USER_MSEC(x) \
	x.span_user
	
#define MTIMER_GET_SYSTEM_MSEC(x) \
	x.span_system
	
#define MTIMER_RESET(x) \
	x.span_wall = 0; \
	x.span_user = 0; \
	x.span_system = 0; \
	x.start_wall.tv_sec = 0; \
	x.start_wall.tv_usec = 0; \
	x.stop_wall.tv_sec = 0; \
	x.stop_wall.tv_usec = 0; \
	x.start_rusage.ru_utime.tv_sec = 0; \
	x.start_rusage.ru_utime.tv_usec = 0; \
	x.stop_rusage.ru_utime.tv_sec = 0; \
	x.stop_rusage.ru_utime.tv_usec = 0; \
	x.start_rusage.ru_stime.tv_sec = 0; \
	x.start_rusage.ru_stime.tv_usec = 0; \
	x.stop_rusage.ru_stime.tv_sec = 0; \
	x.stop_rusage.ru_stime.tv_usec = 0;

#endif
