#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <regex.h>

#include "udm_config.h"
#include "udm_utils.h"
#include "udm_common.h"
#include "udm_mimetype.h"
#include "udm_xmalloc.h"


/********* AddType stuff *********************/

typedef struct mime_struct {
	int	flags;
	regex_t	regex;
	char *	mime_type;
	char *	regstr;
} UDM_MIME;

#define ERRSTRSIZE 100
#define NS 10


int UdmAddType(UDM_ENV * Conf,char * mime_type,char * regstr, int flags){
	char regerrstr[ERRSTRSIZE];
	int err;
	UDM_MIME * Mime;

	if(Conf->nmimes>=Conf->mmimes){
		if(Conf->mmimes){
			Conf->mmimes+=16;
			Conf->Mime=UdmXrealloc(Conf->Mime,Conf->mmimes*sizeof(UDM_MIME));
		}else{
			Conf->mmimes=16;
			Conf->Mime=UdmXmalloc(Conf->mmimes*sizeof(UDM_MIME));
		}
	}
	Mime=(UDM_MIME*)Conf->Mime;
	Mime[Conf->nmimes].mime_type=strdup(mime_type);
	Mime[Conf->nmimes].regstr=strdup(regstr);
	Mime[Conf->nmimes].flags=flags;

	if(Mime[Conf->nmimes].flags&UDM_MIME_REGEX){
		if(Mime[Conf->nmimes].flags&UDM_MIME_CS){
			err=regcomp(&(Mime[Conf->nmimes].regex),regstr,REG_EXTENDED);
		}else{
			err=regcomp(&(Mime[Conf->nmimes].regex),regstr,REG_EXTENDED|REG_ICASE);
		}
		if(err){
			regerror(err,&(Mime[Conf->nmimes].regex),regerrstr,ERRSTRSIZE);
			Conf->errcode=1;
			sprintf(Conf->errstr,"Wrong regex in config file: %s: %s", regstr,regerrstr);
			free(Mime[Conf->nmimes].mime_type);
			free(Mime[Conf->nmimes].regstr);
			return(1);
		}
	}
	Conf->nmimes++;
	return(0);
}

void UdmFreeTypes(UDM_ENV * Conf){
	size_t i;
	UDM_MIME * Mime=(UDM_MIME*)Conf->Mime;
	
	for(i=0;i<Conf->nmimes;i++){
		free(Mime[i].regstr);
		free(Mime[i].mime_type);
		if(Mime[i].flags&UDM_MIME_REGEX)
			regfree(&(Mime[i].regex));
	}
	Conf->nmimes=Conf->mmimes=0;
	UDM_FREE(Conf->Mime);
}

char * UdmContentType(UDM_ENV * Conf,const char *url){
	size_t i;
	regmatch_t subs[NS];
	int err;
	UDM_MIME * Mime=(UDM_MIME*)Conf->Mime;

	for(i=0;i<Conf->nmimes;i++){
		if(Mime[i].flags&UDM_MIME_REGEX){
			err=regexec(&(Mime[i].regex),url,NS,subs,0);
		}else{
			if(Mime[i].flags&UDM_MIME_CS){
				err=UdmStrMatch(url,Mime[i].regstr);
			}else{
				err=UdmStrCaseMatch(url,Mime[i].regstr);
			}
		}
		if(!err)return(Mime[i].mime_type);
	}
	return(NULL);
}
