      FUNCTION XMNCMI(XX,YY,NP,DPAR,NUSER,WFERR)
C
C     This is a user defined function consisting of 2 Gaussians,
C     both with the same  width, where the ratio of the areas
C     and the separation are the extra free parameters
C
C     XX     is first variable
C     YY     is the second variable
C     NP     is number of parameters
C     DPAR   are the parameters in DOUBLE PRECISION
C     NUSER  is the user function number
C     WFERR  is the error on the function (0 in most cases)
C
      IMPLICIT NONE
C
      REAL          XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM
      COMMON/MNUSR/ XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM
      LOGICAL QDEBUG
      INTEGER NDEBUG
      COMMON/MNDBG/ QDEBUG,NDEBUG
C     Mn_Fit registers - Do not overwrite this common block
      REAL REGIS
      COMMON/MNREGI/REGIS(0:400)
C
      DOUBLE PRECISION XMNCMI,XMNCLC
      EXTERNAL XMNCLC
      REAL XX,YY
      INTEGER NP,NUSER
      DOUBLE PRECISION DPAR(20),WFERR,WXX,WYY,WMN1,WMN2,WPAR(3)
      INTEGER NCALL,II
C
      DATA NCALL/0/
C
      NCALL = NCALL + 1
      WXX = DBLE(XX)
      WYY = DBLE(YY)
C
C     First Gaussian (function 6) - copy the parameters to local storage
      WPAR(1) = DPAR(1)
      WPAR(2) = DPAR(2)
      WPAR(3) = DPAR(3)
      WMN1 = XMNCLC(6,WPAR,3,0,XX,YY)
C
C     Second Gaussian - calculate the parameters
      WPAR(1) = DPAR(1) * DPAR(4)
      WPAR(2) = DPAR(2) + DPAR(5)
      WPAR(3) = DPAR(3)
      WMN2 = XMNCLC(6,WPAR,3,0,XX,YY)
C
      XMNCMI = WMN1 + WMN2
C
      IF (NCALL.LE.10 .OR. MOD(NCALL,100).EQ.0) THEN
          WRITE(6,*) 'NCALL',NCALL,', DPAR',(DPAR(II),II=1,NP)
     +     ,WMN1,WMN2,XMNCMI
      ENDIF
C
      END
