      FUNCTION XMNCMJ(XX,YY,NP,DPAR,NUSER,WFERR)
C
C     Framework for a COMIS defined function
C
C     XX     is first variable
C     YY     is the second variable
C     NP     is number of parameters
C     DPAR   are the parameters in DOUBLE PRECISION
C     NUSER  is the user function number
C     WFERR  is the error on the function (0 in most cases)
C
C     The bin widths are stored in the MNUSR.INC include file
C     You should copy in this file explicitly to use them as COMIS
C     does not recognize the INCLUDE command
C
      DOUBLE PRECISION XMNCMJ
      DOUBLE PRECISION DPAR(20),WFERR
      DOUBLE PRECISION DXX,DYY,DZ1,DZ2,ZS2PI
      INTEGER NUSER
      INTEGER NCALL,NCALL2
      DATA ZS2PI /  0.3989422 /
      DATA NCALL/0/,NCALL2/0/
C
      DXX = DBLE(XX)
      DYY = DBLE(YY)
C
      XMNCMJ = 0.0
      WFERR  = 0.0
      IF(NUSER.LE.1) THEN
          IF(DPAR(3).NE.0.0) THEN
              DZ1 = 1.0 / DPAR(3)
              DZ2 = DXX - DPAR(2)
              DZ2 = -0.5 * (DZ1*DZ2)**2
              IF(DABS(DZ2).LE.36.0D0) XMNCMJ=DPAR(1)*DZ1*ZS2PI*DEXP(DZ2)
          END IF
C
          NCALL = NCALL + 1
          IF(NCALL.LE.10 .OR. MOD(NCALL,100).EQ.0) THEN
              TYPE NUSER,DXX,XMNCMJ
          ENDIF
      ELSE
          XMNCMJ = DPAR(1) + DPAR(2)*DXX
          NCALL2 = NCALL2 + 1
          IF(NCALL2.LE.10 .OR. MOD(NCALL2,100).EQ.0) THEN
              TYPE NUSER,DPAR(1),DPAR(2),DXX,XMNCMJ
          ENDIF
      ENDIF
C
      END
