      SUBROUTINE TVCAP( IC_I, KWTYPE, NGRNUM, IERR)
C-----
C     To turn on/off capture window.
C     All the devices can be found in the TVDEV subroutine
C     IC           : Index of device name
C     KWTYPE       : Workstation id, only if device is unknown
C                    otherwise it is gotten from IPUNIT
C     NGRNUM       : Grinnel number
C     LUNTTO         : Logical unit for info output
C-----
*
      implicit none
*
#if ( defined(VMS) )
      INCLUDE '($SSDEF)'
#endif

C
#include "mngrn.inc"
#include "mnlun.inc"
C
#if ( defined(HIGZ) )
#include "hiflag.inc"
#include "hiatt.inc"
#include "himeta.inc"
#endif
*
      integer ic_i, kwtype, ngrnum, ierr
C
      integer ic, lpdsav, lpusav, i, ntdev, ioerr, nconid, idelim, lent
      integer ncol
      real    rval
      CHARACTER*80 TEXT
      CHARACTER*40 COMAND,TDEVNM
      CHARACTER*22 TWINDOW
#if ( defined(PLTSUB) )
      CHARACTER*80 TMNDIR
      CHARACTER*20 TNAM
#endif
      integer lnblnk

      INTEGER NCAPDV
      LOGICAL QSAMSV,QASWSV,QCOLR
      DATA TWINDOW/'Mn_Fit Plotting Window'/
      DATA NCAPDV/0/
C
      IERR = 0
      IC = IC_I
C
#if ( defined(HIGZ) )
      LPDSAV = 0
      LPUSAV = -1
C
C     Special behaviour if no output device selected
C
      IF(IC.EQ.0) THEN
          DO 600 I=1,MPDEV
              IF(I.GT.1 .AND. QPDEV(I)) CALL IDAWK(IPDEV(I))
              QPDEV(I) = .FALSE.
600       CONTINUE
          LPDEV = 0
          LPUNIT = 0
          CALL MN_MES(LUNTTO,'ME','No output device selected')
      ENDIF
C
      COMAND = TPDEV(IC)
      TDEVNM = TPDEV(IC)
      IF(COMAND.EQ.'Unknown') THEN
          TDEVNM = 'Device'
          IF (IPUNIT(IC).NE.0) KWTYPE = IPUNIT(IC)
C
C         Device numbers below 0 mean HIGZ Postscript
C
          IF(KWTYPE.LT.0) THEN
              IC     = MPSOF + MPHRD
              TDEVNM = 'HIGZ Postscript'
              WRITE(TDEVNM(18:),'(I7)',IOSTAT=IOERR) KWTYPE
          ELSE
              WRITE(TDEVNM(8:),'(I7)',IOSTAT=IOERR) KWTYPE
          ENDIF
      ENDIF
      NTDEV = LNBLNK(TDEVNM)
C
C     DEVICE IS ALREADY OPEN
C
      IF(QPOP(IC)) THEN
C
C         DEVICE HAS ALREADY BEEN SELECTED
C
          IF(QPDEV(IC)) THEN
              CALL MN_MES(LUNTTO,'ME',' ' // TDEVNM(1:NTDEV) //
     +         ' is already on')
C
C         DEVICE MUST BE SWITCHED BACK ON
C
          ELSE
              DO 1200 I=1,MPDEV
                  IF(QPDEV(I)) THEN
                      LPDSAV = I
                      LPUSAV = IPUNIT(I)
                      QSAMSV = QSAMDV
                      QASWSV = QASWCH
                      IF(I.GT.1) CALL IDAWK(IPDEV(I))
                  ENDIF
                  QPDEV(I) = .FALSE.
1200          CONTINUE
              TEKACT = .FALSE.
              METACT = .FALSE.
C
              QPDEV(IC) = .TRUE.
              LPDEV = IC
              LPUNIT = IPUNIT(IC)
              CALL MN_MES(LUNTTO,'ME',' ' // TDEVNM(1:NTDEV) //
     +         ' selected')
              GFLAG = .TRUE.
              IWTYPE = LPUNIT
              IF(LPDEV.GT.1 .AND. LPDEV.LE.MPSOF) THEN
                  CALL IACWK(IPDEV(LPDEV))
                  TEKACT = .TRUE.
              ELSEIF(LPDEV.GT.MPSOF) THEN
                  CALL IACWK(IPDEV(LPDEV))
                  METACT = .TRUE.
                  IF(IPUNIT(LPDEV).LT.0) GFLAG = .FALSE.
              ENDIF
          ENDIF
C
C     OPEN A NEW DEVICE
C
      ELSE
          DO 2200 I=1,MPDEV
              IF(QPDEV(I)) THEN
                   LPDSAV = I
                   LPUSAV = IPUNIT(I)
                   QSAMSV = QSAMDV
                   QASWSV = QASWCH
                   IF(I.GT.1) CALL IDAWK(IPDEV(I))
              ENDIF
              QPDEV(I) = .FALSE.
2200      CONTINUE
          TEKACT = .FALSE.
          METACT = .FALSE.
C
          QASWCH = .TRUE.
C
C         GET A LOGICAL UNIT NUMBER
C
#endif
#if ( defined(HIGZ) )
          IF(IC.GT.1) CALL CLEO_GETLUN(NCONID,'TVCAP')
C
C         Set up the workstation type
C
          IF (COMAND.NE.'Unknown') THEN
              LPUNIT = IPUNIT(IC)
          ELSE
              LPUNIT = KWTYPE
          ENDIF
C
C         Null device
C
          IF(IC.EQ.1) THEN
              NCAPDV = 0
              NCONID = 0
C
C         Screen devices
C
          ELSEIF(IC.LE.MPSOF) THEN
              NCAPDV = 1
#endif
#if ( defined(HIGZ) ) && ( defined(X11) )
              QSAMDV = .TRUE.
C
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
              IF(COMAND.EQ.'Tektronix') THEN
                  QSAMDV = .TRUE.
                  CALL WAITYQ('Give logical name of Tektronix' //
     1             ' terminal or <CR> for this terminal: ')
                  NCHR = ISLTYQ(.TRUE.,IDELIM,TEXT)
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
C
C             VAX STATION
C
              ELSEIF(COMAND.EQ.'Vaxstation' .OR. COMAND.EQ.'VS2000' .OR.
     +               COMAND.EQ.'VS3200'     .OR. COMAND.EQ.'VS3200' .OR.
     +               COMAND.EQ.'VSII'       .OR. COMAND.EQ.'CVSII') THEN
C
                  QSAMDV = .FALSE.
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
C
C             Decwindows
C
              ELSEIF(COMAND.EQ.'Decwindows' .OR. COMAND.EQ.'Motif') THEN
C
                  QSAMDV = .FALSE.
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
C
C             VT240
C
              ELSEIF(COMAND.EQ.'VT240' .OR. COMAND.EQ.'CVT240' .OR.
     +               COMAND.EQ.'VT340') THEN
                  QSAMDV = .TRUE.
C
                  CALL WAITYQ('Give logical name of' //
     1             ' terminal or <CR> for this terminal: ')
                  NCHR = ISLTYQ(.TRUE.,IDELIM,TEXT)
#endif
#if ( defined(HIGZ) )
C
C             PERICOM or FALCO or XTERM terminal
C
              ELSE IF(COMAND.EQ.'Falco' .OR.
     +                COMAND.EQ.'Pericom' .OR.
     +                COMAND.EQ.'Xterm') THEN
                  QSAMDV = .TRUE.
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
C
C             USER KNOWN DEVICE
C
C         Some changes made July 4, 1991 by D.N. Brown, to allow for
C         proper functioning with VT1200's.  I.Brock commands have been
C         commented out for now.
C
              ELSE IF(COMAND.EQ.'Unknown') THEN
                  QSAMDV = .TRUE.
                  LPUNIT = KWTYPE
#endif
#if ( defined(HIGZ) ) && ( !defined(X11) )
              ENDIF
#endif
#if ( defined(HIGZ) )
C
C         HARDCOPY DEVICES
C
          ELSE
              NCAPDV = 2
              TEXT = TFHRD
C
              IF(COMAND.EQ.'Metafile') THEN
                  IF(TFHRD.EQ.' ') TEXT = 'plot.meta'
C
              ELSEIF(COMAND(1:).EQ.'EPostscript' .OR.
     +               COMAND(2:).EQ.'EPostscript') THEN
*ICB                  write(6
*ICB     +             ,'('' Resetting number of Epost pages counter'')')
*ICB                  NP113 = 0
                  IF(TFHRD.EQ.' ') TEXT = 'plot.eps'
C
              ELSEIF(COMAND(1:).EQ.'Postscript' .OR.
     +               COMAND(2:).EQ.'Postscript' .OR.
     +               COMAND(3:).EQ.'Postscript') THEN
                  IF(TFHRD.EQ.' ') TEXT = 'plot.ps'
                  lpunit = -(1000*nspaper + mod(iabs(lpunit),1000))
C
              ELSEIF(LPUNIT.EQ.-113) THEN
                  IF(TFHRD.EQ.' ') TEXT = 'plot.eps'
C
              ELSEIF(LPUNIT.LT.0) THEN
                  IF(TFHRD.EQ.' ') TEXT = 'plot.ps'
                  lpunit = -(1000*nspaper + mod(iabs(lpunit),1000))
C
              ELSEIF(COMAND.EQ.'Unknown') THEN
                  IF(TFHRD.EQ.' ') TEXT = 'plot.dat'
C
              ELSEIF(TFHRD.EQ.' ') THEN
                  TEXT = 'plot.dat'
              ENDIF
C
              CALL MN_FIL(-43,NCONID,TEXT,IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
              LENT = LNBLNK(TEXT)
              IF(LENT.GT.45) THEN
                  WRITE(TXTMES,'('' TVCAP: Hardcopy to unit'',I3
     +             ,'', File: '',A,''...'')',IOSTAT=IOERR)
     +             NCONID,TEXT(1:42)
              ELSE
                  WRITE(TXTMES,'('' TVCAP: Hardcopy to unit'',I3
     +             ,'', File: '',A)',IOSTAT=IOERR) NCONID,TEXT(1:LENT)
              ENDIF
              CALL MN_MES(LUNTTO,'ME',TXTMES)
          ENDIF
C
          QPDEV(IC) = .TRUE.
          QPOP(IC)  = .TRUE.
          LPDEV     = IC
          IPDEV(IC)  = NCAPDV
          IPUNIT(IC) = LPUNIT
          ICONID(IC) = NCONID
          NDVLST     = 0
C
C         OPEN AND ACTIVATE THE WORKSTATION
C
          CALL MN_MES(LUNTTO,'ME',' ' // TDEVNM(1:NTDEV) //
     +         ' selected')
          IF(LPDEV.GT.1) THEN
              GFLAG = .TRUE.
              GRFLAG = .TRUE.
              CALL IOPWK(IPDEV(LPDEV),NCONID,LPUNIT)
              IWTYPE = LPUNIT
              IF(LPDEV.LE.MPSOF) THEN
                  CALL IACWK(IPDEV(LPDEV))
                  TEKACT = .TRUE.
              ELSEIF(LPDEV.GT.MPSOF) THEN
                  CALL IACWK(IPDEV(LPDEV))
                  METACT = .TRUE.
                  FILOPN = .TRUE.
                  IF(IPUNIT(LPDEV).LT.0) GFLAG = .FALSE.
              ENDIF
#endif
#if ( defined(HIGZ) ) && ( defined(X11) )
C
C             Set up the colours for X Windows
C
              IF(COMAND.NE.'Falco' .AND. COMAND.NE.'Xterm') THEN
                  CALL IGQ('NCOL',RVAL)
                  NCOL = NINT(RVAL)
*ICB                  write(6,'('' Number of colours'',I4)') NCOL
                  IF(NCOL.GT.2) THEN
                      CALL IGSG(1)
                      CALL ISCR(IPDEV(LPDEV),0,1.,1.,1.)
                      CALL ISCR(IPDEV(LPDEV),1,0.,0.,0.)
                      CALL ISCR(IPDEV(LPDEV),2,1.,0.,0.)
                      CALL ISCR(IPDEV(LPDEV),3,0.,1.,0.)
                      CALL ISCR(IPDEV(LPDEV),4,0.,0.,1.)
                      CALL ISCR(IPDEV(LPDEV),5,1.,1.,0.)
                      CALL ISCR(IPDEV(LPDEV),6,1.,0.,1.)
                      CALL ISCR(IPDEV(LPDEV),7,0.,1.,1.)
                  ENDIF
              ENDIF
#endif
#if ( defined(HIGZ) )
C
C             Set colours on or off
C
              QCOLR = QCOLOUR
              CALL TVCOLR(QCOLR)
          ENDIF
      ENDIF
C
C     Switch back to alphanumeric mode.
C
      IF(LPDEV.GT.1 .AND. LPDEV.LE.MPSOF .AND. QSAMDV) THEN
          CALL IGSA(IPDEV(LPDEV))
          LPUNIT= 0
      ENDIF
C
      RETURN
C
9000  CONTINUE
      IERR = 1
      LENT = MAX0(LNBLNK(TEXT),1)
      CALL M_EMSG('TVCAP','Could not open hardcopy file: ' //
     + TEXT(1:LENT))
      CALL MN_ERR('TVCAP'
     + ,'The previous output device will be reactivated')
      IF(LPDSAV.GT.0 .AND. LPUSAV.GT.0) THEN
          LPDEV = LPDSAV
          IPUNIT(LPDEV) = LPUSAV
          QPDEV(LPDEV) = .TRUE.
          QSAMDV = QSAMSV
          QASWCH = QASWSV
          CALL IACWK(IPDEV(LPDEV))
          IF(LPDEV.LE.MPSOF .AND. QSAMDV) THEN
              CALL IGSA(IPDEV(LPDEV))
              LPUNIT= 0
          ENDIF
      ENDIF
C
#endif
#if ( defined(PLTSUB) )
      COMAND = TPDEV(IC)
C
      IF(COMAND.EQ.'Grinnel') THEN
100       CONTINUE
          IF(NGRNUM.LT.0) THEN
110           CONTINUE
              CALL WAITYQ('Give Grinnel number (0-15): ')
              NGRNUM = INTTYQ(.TRUE.,IDELIM)
              IF(IDELIM.GT.0) GOTO 110
          ENDIF
C
          IF( NGRNUM.LT.0 .OR. NGRNUM.GT.15 ) THEN
              NGRNUM = -1
              CALL M_EMSG('TVCAP'
     +         ,'Grinnel number must be in the range 0 - 15')
              GOTO 100
          ENDIF
      ENDIF
C
C     DEVICE IS ALREADY OPEN
C
      IF(QPOP(IC)) THEN
C
C         DEVICE HAS ALREADY BEEN SELECTED
C
           IF(QPDEV(IC) .AND.
     1        (IC.NE.2 .OR. (IC.EQ.2 .AND. NGRNUM.EQ.ICONID(IC)))) THEN
               LEND = LNBLNK(TPDEV(IC))
               IF(IC.NE.2) THEN
                    WRITE(TEXT,1000) TPDEV(IC)(1:LEND)
1000                FORMAT(1X,A,' is already on')
               ELSE
                    WRITE(TEXT,1010) TPDEV(IC)(1:LEND),NGRNUM
1010                FORMAT(1X,A,I3,' is already on')
               ENDIF
               CALL MN_MES(LUNTTO,'ME',TEXT)
C
C         DEVICE MUST BE SWITCHED BACK ON
C
           ELSE
               DO I=1,MPDEV
                   QPDEV(I) = .FALSE.
               ENDDO
               QPDEV(IC) = .TRUE.
               LPDEV = IC
               LPUNIT = IPUNIT(IC)
               IF(IC.EQ.2) THEN
                   ICONID(LPDEV) = NGRNUM
                   CALL GRNSET(NGRNUM)
               ENDIF
               LEND = LNBLNK(TPDEV(IC))
               IF(IC.NE.2) THEN
                   WRITE(TEXT,1100) TPDEV(IC)(1:LEND)
1100               FORMAT(1X,A,' selected')
               ELSE
                   WRITE(TEXT,1110) TPDEV(IC)(1:LEND),NGRNUM
1110               FORMAT(1X,A,I3,' selected')
               ENDIF
               CALL MN_MES(LUNTTO,'ME',TEXT)
               CALL PLTOPT(IPUNIT(IC))
           ENDIF
C
C     OPEN A NEW DEVICE
C
      ELSE
          DO I=1,MPDEV
              QPDEV(I) = .FALSE.
          ENDDO
          QASWCH = .TRUE.
C
C         SCREEN DEVICES
C
          IF(IC.LE.MPSOF) THEN
            IF(COMAND.EQ.'Grinnel') THEN
                 CALL GRNSET(NGRNUM)
              ELSE IF(COMAND.EQ.'Tektronix' .OR. COMAND.EQ.'T10' .OR.
     1           COMAND.EQ.'T12') THEN
  200             CONTINUE
                  CALL WAITYP('Give logical name of Tektronix' //
     1             ' terminal or <CR> for this terminal: ')
                  JSTR = ISTRNG(.TRUE.,TEXT,NCHAR)
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR TEKTRONIX
C
                  TNAM = 'MN_FIT_DIR'
                  CALL M_TLOGI(TNAM,NNN,ISTAT,TMNDIR)
                  CALL M_SLOGI('TEK_INIT'
     1             ,TMNDIR(1:NNN) // 'TEK_INIT_TEK.DAT')
                  CALL M_SLOGI('TEK_LEAVE'
     1             ,TMNDIR(1:NNN) // 'TEK_LEAVE_TEK.DAT')
C
                  IF(NCHAR.GT.0) THEN
                      QSAMDV = .FALSE.
                      CALL PLTOPT(IPUNIT(IC))
                      CALL PLTFIL(TEXT(1:NCHAR))
                  ELSE
                      QSAMDV = .TRUE.
                      QASWCH = .FALSE.
                  ENDIF
C
C             VAX STATION
C
              ELSE IF(COMAND.EQ.'Vaxstation') THEN
                  CALL PLTOPT(IPUNIT(IC))
                  LDN = LNBLNK(TWINDOW)
                  CALL PLTFIL(TWINDOW(:LDN))
C
                  QSAMDV = .FALSE.
C
C             DECWindows
C
              ELSE IF(COMAND.EQ.'Decwindows') THEN
                  CALL PLTOPT(IPUNIT(IC))
                  LDN = LNBLNK(TWINDOW)
                  CALL PLTFIL(TWINDOW(:LDN))
C
                  QSAMDV = .FALSE.
C
C             Versaterm
C
              ELSE IF(COMAND.EQ.'Versaterm') THEN
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR TEKTRONIX
C
                  TNAM = 'MN_FIT_DIR'
                  CALL M_TLOGI(TNAM,NNN,ISTAT,TMNDIR)
                  CALL M_SLOGI('TEK_INIT'
     1             ,TMNDIR(1:NNN) // 'TEK_INIT_VERSATERM.DAT')
                  CALL M_SLOGI('TEK_LEAVE'
     1             ,TMNDIR(1:NNN) // 'TEK_LEAVE_VERSATERM.DAT')
C
                  QSAMDV = .TRUE.
                  QASWCH = .FALSE.
C
C             VT240
C
              ELSE IF(COMAND.EQ.'VT240') THEN
                  CALL WAITYP('Give logical name of Tektronix' //
     1             ' terminal or <CR> for this terminal: ')
                  JSTR = ISTRNG(.TRUE.,TEXT,NCHAR)
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR TEKTRONIX
C
                  ISTAT = LIB$DELETE_LOGICAL('TEK_INIT')
                  ISTAT = LIB$DELETE_LOGICAL('TEK_LEAVE')
C
                  IF(NCHAR.GT.0) THEN
                      QSAMDV = .FALSE.
                      CALL PLTOPT(IPUNIT(IC))
                      CALL PLTFIL(TEXT(1:NCHAR))
                  ELSE
                      QSAMDV = .TRUE.
                  ENDIF
C
C             Falco terminal
C
              ELSE IF(COMAND.EQ.'Falco') THEN
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR TEKTRONIX
C
                  TNAM = 'MN_FIT_DIR'
                  CALL M_TLOGI(TNAM,NNN,ISTAT,TMNDIR)
                  CALL M_SLOGI('TEK_INIT'
     1             ,TMNDIR(1:NNN) // 'TEK_INIT_FALCO.DAT')
                  CALL M_SLOGI('TEK_LEAVE'
     1             ,TMNDIR(1:NNN) // 'TEK_LEAVE_FALCO.DAT')
C
                  QSAMDV = .TRUE.
C
C             USER KNOWN DEVICE
C
              ELSE IF(COMAND.EQ.'Unknown') THEN
                  IPUNIT(IC) = KWTYPE
                  QSAMDV = .TRUE.
              ENDIF
C
C         HARDCOPY DEVICES
C
          ELSE
              IF(COMAND.EQ.'Tektronix') THEN
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR TEKTRONIX
C
                  TNAM = 'MN_FIT_DIR'
                  CALL M_TLOGI(TNAM,NNN,ISTAT,TMNDIR)
                  CALL M_SLOGI('TEK_INIT'
     1             ,TMNDIR(1:NNN) // 'TEK_INIT_TEK.DAT')
                  CALL M_SLOGI('TEK_LEAVE'
     1             ,TMNDIR(1:NNN) // 'TEK_LEAVE_TEK.DAT')
C
              ELSE IF(COMAND.EQ.'LN03') THEN
C
C                 SET UP THE LOGICAL NAMES WITH ESCAPE CHARACTERS FOR LN03
C                 TEKTRONIX EMULATION
C
                  TNAM = 'MN_FIT_DIR'
                  CALL M_TLOGI(TNAM,NNN,ISTAT,TMNDIR)
                  CALL M_SLOGI('TEK_INIT'
     1             ,TMNDIR(1:NNN) // 'TEK_INIT_LN03.DAT')
                  CALL M_SLOGI('TEK_LEAVE'
     1             ,TMNDIR(1:NNN) // 'TEK_LEAVE_LN03.DAT')
C
              ELSE IF(COMAND.EQ.'Unknown') THEN
                  IPUNIT(IC) = KWTYPE
              ENDIF
          ENDIF
C
          QPDEV(IC) = .TRUE.
          QPOP(IC)  = .TRUE.
          ICONID(IC) = NGRNUM
          LPDEV  = IC
          LPUNIT = IPUNIT(IC)
          XANGLE = 0.0
          IF(QPVERT(IC)) XANGLE = 90.0
          NDVLST = 0
C
          LEND = LNBLNK(TPDEV(IC))
          IF(IC.NE.2) THEN
              WRITE(TEXT,11200) TPDEV(IC)(1:LEND),XANGLE
11200         FORMAT(1X,A,' selected, Angle =',F5.1)
          ELSE
              WRITE(TEXT,11210) TPDEV(IC)(1:LEND),ICONID(IC),XANGLE
11210         FORMAT(1X,A,I3,' selected, Angle =',F5.1)
          ENDIF
          CALL MN_MES(LUNTTO,'ME',TEXT)
C
          CALL PLTOPN( LPUNIT, XANGLE, 0.0, 0.0)
C
C         MAKE SURE TEKTRONIX GETS THE ESCAPE CHARACTERS
C
          IF(COMAND.EQ.'LN03') THEN
              CALL PLTOPT(0)
              CALL PLTOPT(LPUNIT)
          ENDIF
      ENDIF
C
#endif

      END
