      subroutine m_scmd(idelim,ierr)
*
*-----------------------------------------------------------------------
*
*     Sets various command strings.
*     EDIT      Editor
*     SHELL     Shell
*     PAGER     Pager
*     DUMP      Dumping commands and file
*     HARDCOPY  Hardcopy file
*
*     Called by MN_SET
*
*-----------------------------------------------------------------------
*
      implicit none
*
#include "mnpar.inc"
#include "mncmd.inc"
#include "mnlun.inc"
#include "mnflg.inc"
#include "mngrn.inc"
*
      integer idelim,ierr
*
      integer mdump
      parameter (mdump = 7)
      CHARACTER*10 DMPNAM(MDUMP)
*
      character*80 txt1
      character*80 filnam
      integer nchar,lcmd,lun,lent
      logical qopen
*
      integer  isltyq,iqstyq,icmtyq,lnblnk
      external isltyq,iqstyq,icmtyq
*
      DATA DMPNAM/'SCREEN', 'TTY', '>', 'LPT', 'CLOSE', 'FILE', ' '/
*
*     Allow > in command
*
      call icmsym(tspsym // '>')
*
      if(comnd1.eq.'SHOW') then
        write(txtmes,'(1x,a,t30,a)') 'Edit command is:',tedit
        call mn_mes(luntto,'M',txtmes)
        write(txtmes,'(1x,a,t30,a)') 'Shell command is:',tshell
        call mn_mes(luntto,'M',txtmes)
        write(txtmes,'(1x,a,t30,a)') 'Pager command is:',tpager
        call mn_mes(luntto,'M',txtmes)
        lent = max0(1,min0(49,lnblnk(fil_dp)))
        write(txtmes,'(1x,a,t30,a)') 'Dump filename is:',fil_dp(:lent)
        call mn_mes(luntto,'M',txtmes)
        if(lundmp.eq.luntto) then
          txtmes = ' Dump output unit is to terminal'
        else
          txtmes = ' Dump outut is to file'
        endif
        call mn_mes(luntto,'M',txtmes)
        lent = max0(1,min0(49,lnblnk(tfhrd)))
        write(txtmes,'(1x,a,t30,a)') 'Hardcopy filename is'
     +   ,tfhrd(:lent)
        call mn_mes(luntto,'M',txtmes)
        call mn_mes(luntto,'E',' ')
        goto 9000
      endif
*
      if(comnd2.eq.'EDIT') then
        CALL WAITYQ('Give edit command: ')
        NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
        IF(NCHAR.GT.0) THEN
          TEDIT = ' '
          TEDIT = TXT1(1:NCHAR)
        ENDIF
C
C       Change the default shell command
C
      ELSEIF(COMND2.EQ.'SHELL') THEN
        CALL WAITYQ('Give shell (e.g. /bin/csh): ')
        NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
        IF(NCHAR.GT.0) THEN
          TSHELL = TXT1(1:NCHAR)
        ENDIF
C
C       Change the default pager command - null string also possible
C
      ELSEIF(COMND2.EQ.'PAGER') THEN
        CALL WAITYQ('Give pager command (e.g. more, type/page): ')
        NCHAR = IQSTYQ(.TRUE.,IDELIM,TXT1)
        IF(NCHAR.GT.0) THEN
          TPAGER = TXT1(1:NCHAR)
        ELSEIF(NCHAR.EQ.0) THEN
          TPAGER = ' '
        ENDIF
C
C       CHANGE OUTPUT UNIT FOR DISPLAY, DUMP, HIST DUMP COMMANDS
C
      ELSEIF(COMND2.EQ.'DUMP') THEN
        CALL WAITYQ('Screen|TTY or >|LPT or CLOSE or FILE: ')
        LCMD = ICMTYQ(.TRUE.,IDELIM,DMPNAM)
        CALL MN_DCK(IDELIM,LCMD,MDUMP,DMPNAM,IERR)
        IF(IERR.EQ.2) CALL MN_UNK('MN_SET')
        IF(IERR.GT.0) GOTO 9000
C
C       Direct output to screen
C
        IF(LCMD.EQ.1 .or. lcmd.eq.2) THEN
          LUNDMP = LUNTTO
C
C       Direct output to a file
C
        ELSEIF(LCMD.EQ.3 .or. lcmd.eq.4) THEN
          if(lcmd.eq.3 .and. idelim.eq.0) then
            NCHAR = 0
            CALL WAITYQ('Give filename for dump file: ')
            TXT1 = ' '
            NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
            IF(NCHAR.GT.0) THEN
              FIL_DP = ' '
              FIL_DP = TXT1(1:NCHAR)
            ENDIF
          endif
          LUNDMP = LUNLPT
          INQUIRE(UNIT=LUNDMP,OPENED=QOPEN)
          IF(.NOT.QOPEN) THEN
            FILNAM = FIL_DP
            IF(FILNAM.EQ.' ') FILNAM = 'mn_dump.dat'
            CALL MN_FIL(-33,LUNDMP,FILNAM,IDELIM,IERR)
          ELSE
            IERR = 0
          ENDIF
C
          IF(IERR.NE.0) THEN
            CALL MN_ERR('MN_SET'
     1       ,'Dump output will go to terminal')
            LUNDMP = LUNTTO
            GOTO 9000
          ENDIF
C
C       Close the output file and switch back to screen
C
        ELSEIF(LCMD.EQ.5) THEN
          LUN = LUNLPT
          INQUIRE(UNIT=LUN,OPENED=QOPEN,NAME=FILNAM)
          IF(QOPEN) THEN
            WRITE(LUNTTO,'('' Closing dump unit'',I3
     1       ,/,'' File: '',A)') LUN,FILNAM
            CLOSE(UNIT=LUN)
          ENDIF
          LUNDMP = LUNTTO
C
C       Set the output filename
C
        ELSE IF(LCMD.EQ.6) THEN
          NCHAR = 0
          CALL WAITYQ('Give filename for dump file: ')
          TXT1 = ' '
          NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
          IF(NCHAR.GT.0) THEN
            FIL_DP = ' '
            FIL_DP = TXT1(1:NCHAR)
          ENDIF
        ENDIF
C
C       SET THE FILENAME FOR HARDCOPIES
C       ONLY APPLIES TO GKS VERSION. PLTSUB HAS ITS OWN FILENAMES
C
      ELSEIF(COMND2.EQ.'HARDCOPY') THEN
        CALL WAITYQ('Give filename for hardcopies: ')
        NCHAR = ISLTYQ(.TRUE.,IDELIM,TXT1)
        IF(NCHAR.GT.0) THEN
          TFHRD = ' '
          TFHRD = TXT1(1:NCHAR)
        ENDIF
      endif
*
 9000 continue
      call icmsym(tspsym)
*
      end
