      SUBROUTINE M_LEG1(NLEG,RBUF,NWPPT,THETA,PHI,NCOLI,THICKI
     1 ,NBINX,AXLO,AXHI,NBINY,AYLO,AYHI,ismodu
     1 ,ZLO,ZHI,zllo,XLO,XHI,YLO,YHI,XPLO,XPHI,YPLO,YPHI)
C
C
C     ******************************************************************
C     *                                                                *
C     *                                                                *
C     *       HPLOT 3-D VIEWING ROUTINE                                *
C     *       MODE = 1 means lego plot
C     *       MODE = 2 means surface mode
C     *       CONTENTS OF CELLS ARE REPRESENTED AS BOXES               *
C     *       WITH AUTOMATIC HIDDEN LINES REMOVAL                      *
C     *                                                                *
C     *                                                                *
C     ******************************************************************
C
C
#include "mnlun.inc"
#include "mnpij.inc"
C
      REAL RBUF(*)
      PARAMETER (MPNTMX=5000)
*
      integer nleg,nwppt,ncoli,nbinx,nbiny,ismodu(3)
      real theta,phi,thicki,axlo,axhi,aylo,ayhi,zlo,zhi,xlo,xhi,ylo,yhi
     + ,xplo,xphi,yplo,yphi
C
#include "mnscr.inc"
      REAL XXLOW,XXHIG,YYLOW,YYHIG,RES,DRES,WORK(MPNTMX)
      EQUIVALENCE(SCRATCH(1),XXLOW)
      EQUIVALENCE(SCRATCH(2),XXHIG)
      EQUIVALENCE(SCRATCH(3),YYLOW)
      EQUIVALENCE(SCRATCH(4),YYHIG)
      EQUIVALENCE(SCRATCH(5),RES)
      EQUIVALENCE(SCRATCH(6),DRES)
      EQUIVALENCE(SCRATCH(7),WORK(1))
C
      INTEGER NCHAX,NCHAY
      REAL XT,YT,A11,A13,A21,A22,A23,XC,ZSCALE,ZMIN
      COMMON/M9LEG/NCHAX,NCHAY,XT,YT
     + ,A11,A13,A21,A22,A23,XC,ZSCALE,ZMIN
C
      REAL XPT(5),YPT(5)
      real thedeg,phideg,thick,algins
      integer nsym,ncol,n
C
C     ------------------------------------------------------------------
C
C----
C     DEFINE VIEWING ANGLES
C----
      THEDEG=THETA
      PHIDEG=PHI
      IF(PHIDEG.LE.0.)PHIDEG=30.
      IF(PHIDEG.GE.90.)PHIDEG=30.
      IF(THEDEG.LE.0.)THEDEG=30.
      IF(THEDEG.GE.90.)THEDEG=30.
C
C     RESOLUTION SET TO 0.5*CALCOMP PEN WIDTH
C
      RES    = 0.02
      DRES   = 1./RES
      NSYM   = 1
      NCOL   = NCOLI
      THICK  = THICKI
      ALGINS = 0.0
CICB  ALGINS = 0.5
CICB  ALGINS = 1.5
C
C     Move the picture over and up 1.5cm (ALGINS) to allow room for the scale
C     Should not do this as there is space in the margin or between the plots
C     anyway for this.
C
      XXLOW = XPLO + ALGINS
      XXHIG = XPHI
      YYLOW = YPLO + ALGINS
      YYHIG = YPHI
C
C     For a lego plot also allow room for the box
C
      IF(NLEG.EQ.1) YYHIG = YYHIG - 0.05*(YPHI-YPLO)
C
      N =(XXHIG-XXLOW)*DRES+1
      IF(N.GT.MPNTMX) THEN
          CALL MN_ERR('M_LEG1'
     +     ,'Not enough intermediate storage space available')
          GOTO 9000
      ENDIF
      CALL VFILL(WORK,N,0.)
*
*     Check the z limits for a log scale
*
      if(ismodu(3).eq.2 .and. (zlo.eq.0.0 .or. zlo*zhi.le.0.0)) then
          call mn_err('M_LEG1'
     +     ,'Z limits not correct for lego plot with log scale')
          goto 9000
      endif
C
C     Decide which bins to plot
C
      dx = (axhi - axlo) / float(nbinx)
      nchax1 = min0(nbinx,max0(0,nint((xlo - axlo) / dx))) + 1
      nchax2 = min0(nbinx,max0(1,nint((xhi - axlo) / dx)))
      dy = (ayhi - aylo) / float(nbiny)
      nchay1 = min0(nbiny,max0(0,nint((ylo - aylo) / dy))) + 1
      nchay2 = min0(nbiny,max0(1,nint((yhi - aylo) / dy)))
C
C     Redefine xlo,xhi to be edges of bins
C
      NCHAX = nchax2 - nchax1 + 1
      NCHAY = nchay2 - nchay1 + 1
      xlo = axlo + float(nchax1-1)*dx
      xhi = axlo + float(nchax2)  *dx
      ylo = aylo + float(nchay1-1)*dy
      yhi = aylo + float(nchay2)  *dy
C
C     ------------------------------------------------------------------
C
C     COMPUTE ROTATION MATRIX
C
      THE  = THEDEG * DRAD
      PH   = PHIDEG * DRAD
      SINTH= SIN(THE)
      A11  = COS(PH)
      A13  = -SIN(PH)
      A21  = -SINTH*A13
      A22  = COS(THE)
      A23  = SINTH*A11
C
C     COMPUTE NORMALIZATION FACTORS
C
      U1=A11*NCHAX
      U2=A13*NCHAY
C     XC=(XXHIG-XXLOW-2.0*ALGINS)/(U1-U2)
C     XT=XXLOW - XC*U2 + ALGINS
C     YT=YYLOW + 2.0*ALGINS
      XC=(XXHIG-XXLOW)/(U1-U2)
      XT=XXLOW - XC*U2
      YC=(YYHIG-YYLOW) / (A21*NCHAX + A23*NCHAY)
      IF(YC.LT.XC) XC = YC
      YT=YYLOW
C
      YL = YYLOW + NCHAY*XC*A23
      IF(YL.LT.(YYLOW+NCHAX*XC*A21)) YL = YYLOW + NCHAX*XC*A21
C
C     Take advantage of the fact I have already calculated ZLO,ZHI
C     Doesn't work properly!
C
      if(ismodu(3).eq.2) then
          ZS3 = (YYHIG - YL) / (A22 *
     +     (alog10(ZHI/zllo) - alog10(zlo/zllo)))
      else
          ZS3 = (YYHIG - YL) / (A22 * (ZHI - ZLO))
      endif
      ZS2 = (YYHIG - YT) /
     + (A21*FLOAT(NCHAX) + A23*FLOAT(NCHAY))
c     ZMAX = -(ZHI - ZLO)
      if(ismodu(3).eq.2) then
          DZ   = alog10(ZHI/zllo) - alog10(zlo/zllo)
      else
          DZ   = ZHI - ZLO
      endif
C
      ZSCALE = 1.0E+31
      Y0 = YYHIG - YYLOW
      DO 30 J=nchay1,nchay2
          Y0 = Y0 - A23*XC
          Y1 = Y0
          DO 20 I=nchax1,nchax2
              Y1 = Y1 - A21*XC
              NPTR = NWPPT*(NBINX*(J-1) + (I-1))
              if(ismodu(3).eq.2) then
                  zz = amin1(zhi,amax1(zlo,rbuf(nptr+1)))
                  z = alog10(zz/zllo) - alog10(zlo/zllo)
              else
                  Z = amin1(dz,amax1(0.0,RBUF(NPTR+1) - ZLO))
              endif
              IF(Z.LE.1.0E-31) GO TO 20
              ZCMIN = Y1 / (Z * A22)
              IF(ZSCALE.GT.ZCMIN) THEN
                  ZSCALE = ZCMIN
                  IF((YL+ZSCALE*A22*Z).GT.YYHIG) THEN
C                      WRITE(6,'('' M_LEG1: Scale too big'')')
                      ZSCALE = (YYHIG-YL) / (A22*Z)
                  ENDIF
              ENDIF
  20      CONTINUE
  30  CONTINUE
C
C     Rescale ZSCALE because the upper limit may be different from the
C     maximum number of entries
C
c     ZSCALE = ZSCALE * ZMAX / (ZHI - ZLO)
c     IF(ZMAX.LE.0.)GO TO 9000
      IF(NLEG.EQ.1) THEN
          if(ismodu(3).eq.2) then
              ZMIN = 0.03 * alog10(ZHI/zlo)
          else
              ZMIN = 0.03 * (ZHI - ZLO)
          endif
      ELSE
          ZMIN = 0.0
      ENDIF
C      write(6,'('' ZSCALE ='',1PG11.4,'' ZS2 ='',1PG11.4
C     + '' ZS3 ='',1PG11.4)')
C     + ZSCALE,ZS2,ZS3
C
C     Take the smaller of the 2 scale factors ZSCALE and ZS3
C
      ZSCALE = AMIN1(ZSCALE,ZS3)
C
C     LOOP ON CELLS TO DRAW PICTURE
C
      DO 90 J=nchay1,nchay2
          DO 80 I=nchax1,nchax2
              NPTR = NWPPT*(NBINX*(J-1) + (I-1))
              if(ismodu(3).eq.2) then
                  Z = alog10(AMAX1(AMIN1(RBUF(NPTR+1),ZHI),ZLO)/ZLLO) -
     +             alog10(zlo/zllo)
              else
                  Z = AMAX1(AMIN1(RBUF(NPTR+1),ZHI),ZLO)  - ZLO
              endif
C
C             FIND OUT THE Z OF THE CHANNEL BEFORE
C
              ZXLAST = 0.0
              ZYLAST = 0.0
              if(ismodu(3).eq.2) then
                  IF(I.GT.nchax1)
     +             ZXLAST = alog10(AMAX1(AMIN1(RBUF(NPTR-NWPPT+1)
     +             ,ZHI),ZLO) / ZLLO) - alog10(zlo/zllo)
                  IF(J.GT.nchay1)
     +             ZYLAST = alog10(AMAX1(AMIN1(RBUF(NPTR-NBINX*NWPPT+1)
     +             ,ZHI),ZLO) / ZLLO) - alog10(zlo/zllo)
              else
                  IF(I.GT.nchax1)
     +             ZXLAST = AMAX1(AMIN1(RBUF(NPTR-NWPPT+1)
     +             ,ZHI),ZLO) - ZLO
                  IF(J.GT.nchay1)
     +             ZYLAST = AMAX1(AMIN1(RBUF(NPTR-NBINX*NWPPT+1)
     +             ,ZHI),ZLO) - ZLO
              endif
C
C             Lego plot
C
              IF(NLEG.EQ.1) THEN
                  IF(Z.GE.0.) THEN
                      X0=XC*FLOAT(I-nchax1)
                      Y0=XC*FLOAT(J-nchay1)
                      Z0=ZSCALE*(Z+ZMIN)
                      X1=X0+XC
                      Y1=Y0+XC
                      UL0=A11*X0+A13*Y0+XT
                      ULX=A11*X1+A13*Y0+XT
                      ULY=A11*X0+A13*Y1+XT
                      VL0=A21*X0+A23*Y0+YT
                      VLX=A21*X1+A23*Y0+YT
                      VLY=A21*X0+A23*Y1+YT
                      VH0=A21*X0+A22*Z0+A23*Y0+YT
                      VHX=A21*X1+A22*Z0+A23*Y0+YT
                      VHY=A21*X0+A22*Z0+A23*Y1+YT
                      UHXY=A11*X1+A13*Y1+XT
                      VHXY=A21*X1+A22*Z0+A23*Y1+YT
C
                      NPT = 0
                      IF(J.EQ.nchay1 .OR. ZYLAST.LE.0.0) THEN
                          NPT = NPT + 1
                          XPT(NPT) = UL0
                          YPT(NPT) = VL0
                      ENDIF
                      NPT = NPT + 1
                      XPT(NPT) = ULX
                      YPT(NPT) = VLX
                      NPT = NPT + 1
                      XPT(NPT) = ULX
                      YPT(NPT) = VHX
                      CALL MN_HID(0,XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
                      NPT = 3
                      XPT(1) = UL0
                      YPT(1) = VL0
                      XPT(2) = UL0
                      YPT(2) = VH0
                      XPT(3) = ULX
                      YPT(3) = VHX
                      CALL MN_HID(0,XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
                      NPT = 0
                      IF(I.EQ.nchax1 .OR. ZXLAST.LE.0.0) THEN
                          NPT = 2
                          XPT(1) = ULY
                          YPT(1) = VLY
                          XPT(2) = UL0
                          YPT(2) = VL0
                          CALL MN_HID(0,XPT,YPT,NPT
     +                     ,NSYM,XUNIT,NCOL,THICK)
                      ENDIF
                      NPT = 3
                      XPT(1) = ULY
                      YPT(1) = VLY
                      XPT(2) = ULY
                      YPT(2) = VHY
                      XPT(3) = UL0
                      YPT(3) = VH0
                      CALL MN_HID(0,XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
                      NPT = 3
                      XPT(1) = ULY
                      YPT(1) = VHY
                      XPT(2) = UHXY
                      YPT(2) = VHXY
                      XPT(3) = ULX
                      YPT(3) = VHX
                      CALL MN_HID(0,XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
                  ENDIF
C
C             Surface plot
C
              ELSEIF(NLEG.EQ.2) THEN
                  X0=XC*(FLOAT(I-nchax1) - 0.5)
                  Y0=XC*(FLOAT(J-nchay1) - 0.5)
                  X1=X0+XC
                  Y1=Y0+XC
                  Z1 = ZSCALE*(Z+ZMIN)
                  XPT(1) = A11*X1+A13*Y1+XT
                  YPT(1) = A21*X1+A22*Z1+A23*Y1+YT
C
C                 Draw the y line, then the x line so MN_HID works properly
C
                  IF(J.GT.nchay1) THEN
                      Z0 = ZSCALE*(ZYLAST+ZMIN)
                      XPT(2) = A11*X1+A13*Y0+XT
                      YPT(2) = A21*X1+A22*Z0+A23*Y0+YT
                      CALL MN_HID(0,XPT,YPT,2,NSYM,XUNIT,NCOL,THICK)
                  ENDIF
                  IF(I.GT.nchax1) THEN
                      Z0 = ZSCALE*(ZXLAST+ZMIN)
                      XPT(2) = A11*X0+A13*Y1+XT
                      YPT(2) = A21*X0+A22*Z0+A23*Y1+YT
                      CALL MN_HID(0,XPT,YPT,2,NSYM,XUNIT,NCOL,THICK)
                  ENDIF
              ENDIF
C
  80      CONTINUE
  90  CONTINUE
C
 9000 CONTINUE
      END
