      SUBROUTINE MN_PRJ(NMODE,IDA,IDB)
C
C-----------------------------------------------------------------------------
C     Makes a projection of a plot
C     NMODE = 0 Just make the projection
C     NMODE = 1 Plot the projection also
C     NMODE = 2 Profile histogram of an Ntuple - errors are r.m.s.
C     NMODE = 3 Profile histogram of an Ntuple - errors are error on mean
C     NMODE = 4 Filter an Ntuple. This means you apply the cuts and then
C               those events that are selected get written to a new Ntuple.
C-----------------------------------------------------------------------------
C
      EXTERNAL QMNCUT
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncwn.inc"
#include "mncmd.inc"
#include "mncut.inc"
#include "mnprj.inc"
#include "mntpl.inc"
#include "mnhpj.inc"
#include "mntim.inc"
#include "mnflg.inc"
#include "mntyq.inc"
#include "mnlun.inc"
*
      integer nmode,ida,idb
C
      integer ibin(mdimmx)
      real admn(mdimmx),adif(mdimmx)
      character*32 tname(mdimmx+1)
      integer ivar(mdimmx),ielem(9,mdimmx),iloc(mdimmx)
     + ,idbin2(mdimmx),ibin2(mdimmx),ins2(mdimmx),iwt(2),ilocw(2)
      real rval2(mdimmx),adlo2(mdimmx),adhi2(mdimmx),adif2(mdimmx)
     + ,acont2(3**3)
CICB     + ,ADTEM(MDIMMX), ADTEM2
      integer mvloop
      parameter (mvloop = 10)
      integer nvloop,ivloop(mvloop),ivarv(mvloop),isubv(mvloop)
     + ,ieloop(3,mvloop)
C
C       Variable ADTEM,2 added 9-Jul-91 by DN Brown to get correct limits
C       in automatic binning of expressions.

      CHARACTER*32 TVAR2(MDIMMX)
      CHARACTER*32 TNAME2(MDIMMX)
      CHARACTER*255 TFILE,TFUNC
C
      CHARACTER*255 TXT1,TXT2,CONCAT,CONCT0
      character txpr*255
C
      LOGICAL QMNCUT,QPASS,QINS,QEXPR,QWT,QWTERR,QPROF,QLIMS
     + ,qread,QLIMA(MDIMMX),q2loop
      LOGICAL QERRL1,QERRH1,QERRL2
      integer idb2,nh,nh2,noff,noffl,noffh,n2loop
      integer jelem(9),nv,ii,jj,nn,nvaro,nvarg
*
      logical  hntnew,qcwntp
      external hntnew
*
      DATA IDB2/1/
C
      IF(IDA.LE.0) THEN
          CALL WAITYQ('Give histogram number: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(IDA.LE.0) GOTO 9000
      ENDIF
C
C     CHECK THAT THE HISTOGRAM EXISTS
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4
     1        ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_PRJ',TXTERR)
          GOTO 9000
      ENDIF
      IF(NDIM.EQ.0) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4
     1        ,''  Invalid dimension'',I4)') IDA,IDB,NDIM
          CALL MN_ERR('MN_PRJ',TXTERR)
          GOTO 9000
      ENDIF
      IF (NDIM.GT.0 .AND. NMODE.EQ.4) THEN
          WRITE(TXTERR,'(''You can only filter an Ntuple.''
     +        ,'' Plot'',I7,I4,'' has dimension'',I4)')
     +        IDA,IDB,NDIM
          CALL MN_ERR('MN_PRJ',TXTERR)
          GOTO 9000
      ENDIF
      IF(NMODE.EQ.2 .OR. NMODE.EQ.3) THEN
        IF(NDIM.GE.-1 .AND. NDIM.LE.1) THEN
          WRITE(TXTERR,'(''You cannot make a profile plot''
     +     ,'' from a histogram or a series of points.'')')
          CALL MN_ERR('MN_PRJ',TXTERR)
          GOTO 9000
        ENDIF
      ENDIF
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL1,QERRH1)
C
C     COPY THE VARIABLE NAMES TO LOCAL STORAGE
C
      CALL TCOPY(TDNAM(1,NH),TNAME,IABS(NDIM))
      TNAME(IABS(NDIM)+1) = ' '
*
*     Find out if it is a CWN
*     Only refetch the Ntuple if autofetching is turned on (default)
*
      qcwntp = .false.
      if(ndim.lt.0 .and. nwdat.le.0) then
          if(qafetch) then
              nh2 = nh
          else
              nh2 = -nh
          endif
          call m_intp(ida,idb,nh2,ierr)
          if(ierr.ne.0) goto 9000
          idh = ida
          qcwntp = hntnew(idh)
      endif
C
C     Flag that I am projecting and fill the Ntuple common
C
      QPROJ  = .TRUE.
      NHP    = NH
      ID     = IDA
      NVAR   = IABS(NDIM)
      CALL UCOPY_r(ADLO(1),RLIM(1),NVAR)
      CALL UCOPY_r(ADHI(1),RLIM(NVAR+1),NVAR)
      TITLE = TDTIT(NH)
      CALL TCOPY(TDNAM(1,NH),TAGS(1),NVAR)
      IDNEVT = 0
      VIDN1  = 0.0
      VIDN2  = 0.0
      VIDN3  = 0.0
      q2loop = .false.
      n2loop = 0
C
C     Find out which variables I want to project onto
C     If IERR < 0 this means it is an expression that should be parsed
C     and a flag set corrrespondingly
C
      NNUM   = 0
      NVEXPR = 0
      QEXPR  = .FALSE.
      QWT    = .FALSE.
      QWTERR = .FALSE.
      QPROF  = .FALSE.
      NWEXPR = 0
      IF(NMODE.LT.4) THEN
          IF(.NOT.QRFILE .AND. IDELIM.LT.0) THEN
              CALL MN_MES(LUNTTO,'M'
     +            ,' You can give the variable number,' //
     +            ' name or an expression')
              CALL MN_MES(LUNTTO,'E'
     +            ,' An expression should contain no blanks or' //
     +            ' be enclosed in parentheses ()')
          ENDIF
 2000     CONTINUE
          CALL WAITYQ('Give variables to project onto: ')
          CALL M_VGET(3,NH,NVAL,txpr,JELEM,IDELIM,IERR)
          IF(IERR.GT.0) THEN
              GOTO 9000
          ELSEIF(IERR.LT.0) THEN
              CALL M_EPRS(1,NVAL,txpr,IDELIM,IERR)
              IF(IERR.NE.0) then
                 call m_emsg('MN_PRJ','Maybe variable name mistyped')
                 GOTO 9000
              endif
              call vzero_i(jelem,9)
              QEXPR = .TRUE.
          ENDIF
C
C         See if the weight has been given.
C         If so skip the # and parse the expression.
C
          IF(NVAL.EQ.0 .AND. IERR.EQ.0 .AND. IDELIM.EQ.ICHAR('#')) THEN
              CALL STRTYQ(1,txpr)
C
C             See if the variable number has been given
C
              call m_vget(3,nh,nval,txpr,jelem,idelim,ierr)
              if(ierr.gt.0) then
                  goto 9000
C
C             Parse the expression
C
              elseif(ierr.lt.0) then
                  CALL M_EPRS(3,NVAL,txpr,IDELIM,IERR)
                  IF(IERR.NE.0) GOTO 9000
                  call vzero_i(jelem,9)
              endif
              if(.not.qwt) then
                  QWT   = .TRUE.
                  iwt(1) = nval
              else
                  QWTERR = .TRUE.
                  iwt(2) = nval
              endif
              nvarg = nvarg + 1
              call ucopy_i(jelem,ielem(1,nvarg),9)
              ivar(nvarg) = nval
              IF(.NOT.QWTERR .AND. IDELIM.EQ.0) GOTO 2000
              GOTO 2100
          ENDIF
C
          IF(NVAL.EQ.0) GOTO 2100
C
          NNUM  = NNUM + 1
          nvarg = nnum
          IVAR(NNUM)  = NVAL
          tvar2(nnum) = txpr
          call ucopy_i(jelem,ielem(1,nnum),9)
          IF(IDELIM.EQ.0 .AND. NNUM.LT.NVAR) GOTO 2000
C
 2100     CONTINUE
          NDIM2 = NNUM
          IF(NDIM2.LE.0) THEN
              CALL MN_ERR('MN_PRJ','No valid variables given')
              GOTO 9000
          ENDIF
*
*         When making profile plots use the y-axis as a weight
*         and make sure that I have given 2 variables to project onto
*
          IF(NMODE.EQ.2 .OR. NMODE.EQ.3) THEN
              IF(NDIM2.EQ.2) THEN
                  QPROF = .TRUE.
              ELSE
                  CALL MN_ERR('MN_PRJ'
     +             ,'You must give the x and y axes for a profile plot')
                  GOTO 9000
              ENDIF
          ENDIF
C
      ELSEIF(NMODE.EQ.4) THEN
          NDIM2 = IABS(NDIM)
          DO 2200 I=1,IABS(NDIM)
              IVAR(I)    = I
              ielem(1,i) = 1
              ielem(2,i) = 0
 2200     CONTINUE
      ENDIF
C
      TXT1 = 'Give secondary ID for projection (<CR>=   ):'
      WRITE(TXT1(40:42),'(I3)',IOSTAT=IOERR) IDB2
      LENT = LENOCC(TXT1)
      CALL WAITYQ(TXT1(1:LENT+1))
      CALL MN_SEC(IDB2,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
*
*     Time mode
*
      NTMOD2 = 0
      nsdat2 = 0
      nstim2 = 0
*
*     See if the x-axis mode is date or time
*
      if(ismods(1).eq.3) then
          if(nmtime.ne.1) then
              txtmes = ' Date/time mode set to date' //
     +         ' with no reference date - plot stored in days'
              call mn_mes(luntto,'ME',txtmes)
          endif
          nmtime = 1
          ndtref = 0
          ntmref = 0
*
      elseif(ismods(1).eq.4) then
          if(nmtime.ne.2) then
              txtmes = ' Date/time mode set to time' //
     +         ' with no reference date - plot stored in hours'
              call mn_mes(luntto,'ME',txtmes)
          endif
          nmtime = 2
          ndtref = 0
          ntmref = 0
      endif
      if(ismods(1).eq.3 .or. ismods(1).eq.4) then
          ntmod2 = nmtime
          nsdat2 = ndtref
          nstim2 = ntmref
      endif
C
C     Setup the default local binning and limits. If the variables are an
C     expression use the limits to calculate the new expression limits.
C
      QLIMS = .FALSE.
      DO 2500 I=1,NDIM2
          QLIMA(I) = .FALSE.
          IF(IVAR(I).GT.0) THEN
              IF(IVAR(I).LE.IABS(NDIM)) THEN
                  IDBIN2(I) = IDBIN(IVAR(I))
                  ADLO2(I)  = ADLO(IVAR(I))
                  ADHI2(I)  = ADHI(IVAR(I))
                  TNAME2(I) = TNAME(IVAR(I))
              ELSE
                  IDBIN2(I) = 100
                  ADLO2(I)  = EDLO
                  ADHI2(I)  = EDHI
                  IF(IVAR(I).EQ.2) THEN
                      TNAME2(I) = 'Y'
                  ELSE
                      TNAME2(I) = 'Z'
                  ENDIF
              ENDIF
          ELSE
              IF(NDIM.GT.0) THEN
                  IDBIN2(I) = 100
              ELSE
                  IDBIN2(I) = 0
              ENDIF
C       The following loop samples 100 points to find the minimum and
C       maximum of the given expression.
C              DO 2510 IT = 1, 100
C                  ADTEM(IVETV(1,1,-IVAR(I)))=ADLO(IVETV(1,1,-IVAR(I))) +
C     +                FLOAT(IT)/100.*
C     +                (ADHI(IVETV(1,-IVAR(I)))-ADLO(IVETV(1,1,-IVAR(I))))
C                  ADTEM(I) = ADTEM(IVETV(1,1,-IVAR(I)))
C                  ADTEM(-IVAR(I)) = ADTEM(IVETV(1,1,-IVAR(I)))
C                  CALL UCOPY_r(ADTEM,RVAL,NVAR)
C                  ADTEM2 = AM_VAR(-IVAR(I),ierr)
C                  IF(IT.EQ.1)THEN
C                      ADLO2(I) = ADTEM2
C                      ADHI2(I) = ADTEM2
C                  ELSE
C                      ADLO2(I) = MIN(ADLO2(I),ADTEM2)
C                      ADHI2(I) = MAX(ADHI2(I),ADTEM2)
C                  ENDIF
C 2510         CONTINUE
*
*             For CWN I cannot estimate the limits - set them to 0
*             The CWN has also not yet been initialized, so AM_VAR is
*             not correct.
*
              if(qcwntp) then
                  adlo2(i) = 0.0
                  adhi2(i) = 0.0
              else
                  CALL UCOPY_r(ADLO,RVAL,NVAR)
                  ADLO2(I)  = AM_VAR(-IVAR(I),ierr)
                  CALL UCOPY_r(ADHI,RVAL,NVAR)
                  ADHI2(I)  = AM_VAR(-IVAR(I),ierr)
              endif
              IF(LENOCC(TVEXPR(-IVAR(I))).GT.LEN(TNAME2(I))) THEN
                  IF(I.EQ.1) THEN
                      TNAME2(I) = 'X'
                  ELSEIF(I.EQ.2) THEN
                      TNAME2(I) = 'Y'
                  ELSEIF(I.EQ.3) THEN
                      TNAME2(I) = 'Z'
                  ENDIF
              ELSE
                  TNAME2(I) = TVEXPR(-IVAR(I))
              ENDIF
          ENDIF
 2500 CONTINUE
C
C     BINNED HISTOGRAM INPUT
C
      IF(NDIM.GT.0) THEN
C
C         If we are projecting onto an expression find out the binning
C
          IF(QEXPR) THEN
              IF(IDELIM.LT.0) THEN
                  CALL MN_MES(LUNTTO,'ME'
     +                ,' -1 bins mean use automatic binning')
              ENDIF
              NBIN = 0
              DO 3100 II=1,IABS(NDIM2)
                  if(ii.eq.1) then
                      nbmod2 = ntmod2
                  else
                      nbmod2 = 0
                  endif
                  IF(NBIN.LT.0) THEN
                      NBIN = -1
                  ELSE
                      NBIN = IDBIN2(II)
                  ENDIF
                  BLO  = ADLO2(II)
                  BHI  = ADHI2(II)
                  if(idelim.lt.0) then
                      lent = max0(1,lnblnk(tvar2(ii)))
                      txtmes = tvar2(ii)(:lent) // ' axis:'
                      call mn_mes(luntto,'ME',txtmes)
                  endif
                  IF(QPROF .AND. II.EQ.2) THEN
                      CALL MN_BLM(4,nbmod2,IDELIM,'NTUPLE ' // COMND2
     +                 ,NBIN,BLO,BHI,NNUM,IERR)
                      NBIN = 1
                      IF(NNUM.EQ.0 .OR.
     +                   (BLO.EQ.0.0 .AND. BHI.EQ.0.0)) THEN
                          BLO = -1.0E+31
                          BHI = +1.0E+31
                      ENDIF
                  ELSE
                      CALL MN_BLM(1,nbmod2,IDELIM,'NTUPLE ' // COMND2
     +                 ,NBIN,BLO,BHI,NNUM,IERR)
                  ENDIF
                  IF(IERR.NE.0) GOTO 9000
C
                  IF(NBIN.NE.0) THEN
                      IDBIN2(II) = IABS(NBIN)
                      ADLO2(II)  = BLO
                      ADHI2(II)  = BHI
                  ENDIF
                  ADIF2(II) = (ADHI2(II)-ADLO2(II)) / FLOAT(IDBIN2(II))
 3100         CONTINUE
C
C         For profile plots set the y limits and calculate step sizes
C
          ELSEIF(QPROF) THEN
              if(idelim.lt.0) then
                  lent = max0(1,lnblnk(tvar2(ii)))
                  txtmes = tvar2(2)(:lent) // ' axis:'
                  call mn_mes(luntto,'ME',txtmes)
              endif
              CALL MN_BLM(2,nbmod2,IDELIM,'NTUPLE ' //COMND2
     +         ,NBIN,BLO,BHI,NNUM,IERR)
              NBIN = 1
              IF(IERR.NE.0) GOTO 9000
              IF(NNUM.EQ.0 .OR. (BLO.EQ.0.0 .AND. BHI.EQ.0.0)) THEN
                  BLO = -1.0E+31
                  BHI = +1.0E+31
              ENDIF
              IDBIN2(2) = IABS(NBIN)
              ADLO2(2)  = BLO
              ADHI2(2)  = BHI
              DO 3130 II=1,IABS(NDIM2)
                  ADIF2(II) = (ADHI2(II)-ADLO2(II)) / FLOAT(IDBIN2(II))
 3130         CONTINUE
          ELSE
              DO 3150 II=1,IABS(NDIM2)
                  ADIF2(II) = (ADHI2(II)-ADLO2(II)) / FLOAT(IDBIN2(II))
 3150         CONTINUE
          ENDIF
C
          QERRL2  = .TRUE.
          IF(QPROF) THEN
              NWPPT2 = 4
              NPNT2  = IDBIN2(1)
          ELSEIF(NDIM2.EQ.1) THEN
              NWPPT2 = 2
              NPNT2  = IDBIN2(1)
          ELSE
              NWPPT2 = 2
              NPNT2  = IDBIN2(1) * IDBIN2(2)
          ENDIF
          NWRD2  = NWPPT2 * NPNT2
C
C         Initialize things to make reading in the histogram faster
C
          DO 3200 II=1,NDIM
              ADIF(II) = (ADHI(II)-ADLO(II)) / FLOAT(IDBIN(II))
              ADMN(II) = ADLO(II) + 0.5*ADIF(II)
 3200     CONTINUE
          DO 3250 II=NDIM+1,MDIMMX
              IDBIN(II) = 1
 3250     CONTINUE
          IBIN(1) = 0
          DO 3300 NN=2,IABS(NDIM)
              IBIN(NN) = 1
              RVAL(NN) = ADMN(NN)
 3300     CONTINUE
          IF(NDIM.GT.2) THEN
              NPTR  = 2*NPTRD - 1 - NWPPT
          ELSEIF(NDIM.GT.0) THEN
              NPTR  = NPTRD - NWPPT
          ENDIF
C
C     UNBINNED SCATTER PLOT INPUT
C
      ELSEIF(NDIM.LT.0) THEN
C
C         FIND OUT WHAT BINNING I WANT FOR THE PROJECTION
C
          IF(NMODE.LT.4) THEN
              IF(IDELIM.LT.0) THEN
                  CALL MN_MES(LUNTTO,'M'
     1                ,'  0 bins means keep as a true scatter plot')
                  CALL MN_MES(LUNTTO,'ME'
     +                ,' -1 bins mean use automatic binning')
              ENDIF
              IF(NDIM2.EQ.1) THEN
                  NBIN = -1
              ELSE
                  NBIN = 0
              ENDIF
              DO 3400 II=1,IABS(NDIM2)
                  if(ii.eq.1) then
                      nbmod2 = ntmod2
                  else
                      nbmod2 = 0
                  endif
                  IF(NBIN.LT.0) NBIN = -1
                  BLO  = ADLO2(II)
                  BHI  = ADHI2(II)
                  if(idelim.lt.0) then
                      lent = max0(1,lnblnk(tvar2(ii)))
                      txtmes = tvar2(ii)(:lent) // ' axis:'
                      call mn_mes(luntto,'ME',txtmes)
                  endif
                  IF(QPROF .AND. II.EQ.2) THEN
                      CALL MN_BLM(4,nbmod2,IDELIM,'NTUPLE ' // COMND2
     +                 ,NBIN,BLO,BHI,NNUM,IERR)
                      NBIN = 1
                      IF(NNUM.EQ.0 .OR.
     +                   (BLO.EQ.0.0 .AND. BHI.EQ.0.0)) THEN
                          BLO = -1.0E+31
                          BHI = +1.0E+31
                      ENDIF
                  ELSEIF(NBIN.EQ.0 .AND. II.EQ.2) THEN
                      CALL MN_BLM(4,nbmod2,IDELIM,'NTUPLE ' // COMND2
     +                 ,NBIN,BLO,BHI,NNUM,IERR)
                  ELSE
                      CALL MN_BLM(6,nbmod2,IDELIM,'NTUPLE ' // COMND2
     +                 ,NBIN,BLO,BHI,NNUM,IERR)
                  ENDIF
                  IF(IERR.NE.0) GOTO 9000
                  IF(NNUM.GT.1 .AND. (BLO.NE.0.0 .OR. BHI.NE.0.0)) THEN
                      QLIMS     = .TRUE.
                      QLIMA(II) = .TRUE.
                  ENDIF
C
                  IDBIN2(II) = IABS(NBIN)
                  IF(BLO.NE.0.0 .OR. BHI.NE.0.0) THEN
                      ADLO2(II)  = BLO
                      ADHI2(II)  = BHI
                  ENDIF
                  IF(IDBIN2(II).GT.0) THEN
                      ADIF2(II) = (ADHI2(II)-ADLO2(II)) /
     +                    FLOAT(IDBIN2(II))
                  ELSEIF(NNUM.EQ.1 .OR.
     +                   (ADLO2(II).EQ.0.0 .AND. ADHI2(II).EQ.0.0)) THEN
                      GOTO 3450
                  ENDIF
 3400         CONTINUE
C
 3450         CONTINUE
              IF(IDBIN2(1).LE.0) THEN
                  NDIM2 = -NDIM2
                  CALL VZERO_i(IDBIN2,IABS(NDIM2))
              ENDIF
          ELSEIF(NMODE.EQ.4) THEN
              NDIM2 = -NDIM2
              CALL VZERO_i(IDBIN2,IABS(NDIM2))
          ENDIF
C
          IF(NDIM2.GT.0) THEN
              QERRL2 = .TRUE.
              IF(QPROF) THEN
                  NWPPT2 = 4
                  NPNT2  = IDBIN2(1)
              ELSEIF(IABS(NDIM2).EQ.1) THEN
                  NWPPT2 = 2
                  NPNT2  = IDBIN2(1)
              ELSE
                  NWPPT2 = 2
                  NPNT2  = IDBIN2(1) * IDBIN2(2)
              ENDIF
              NWRD2  = NPNT2 * NWPPT2
          ELSE
              QERRL2 = .FALSE.
              IF(QWTERR) QERRL2 = .TRUE.
              NWPPT2 = IABS(NDIM2)
              IF(NDIM2.EQ.-1) THEN
                  NWPPT2 = NWPPT2 + 1
                  IF(.NOT.QWT) QERRL2 = QERRL1
                  IF(QERRL2) THEN
                      NWPPT2 = 2 * NWPPT2
                  ENDIF
              ENDIF
              NPNT2  = 0
              NSPC2  = 100
              NWRD2  = NSPC2 * NWPPT2
          ENDIF
      ENDIF
C
C     Change the number of dimensions to 1 for a profile plot
C
      IF(QPROF) THEN
          IF(IDBIN2(1).LE.0) THEN
              CALL MN_ERR('MN_PRJ','A profile plot must be binned')
              GOTO 9000
          ENDIF
          NDIM2 = 1
      ENDIF
C
C     Get the number of events to scan if given
C
      CALL M_NEVT(IDELIM,NEVT1,NEVT2,IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Find out what sorts of cuts I have. Translate variable names to numbers
C     if possible, parse expressions and compile Comis functions.
C     Always parse the cuts as type 2 or 3 and see if type 2 becomes type 1.
C
      NCEXPR = 0
      DO 4000 NN=1,NCUSE
          NC = ICUSE(NN)
C
C         Cut expression - see if it is a simple cut
C         A simple cut is variable (name/number) and a number
C
          IF(ICTYPE(NC).ge.1 .and. ICTYPE(NC).le.3) THEN
              CALL QUOTYQ(TCVAR(NC))
              CALL M_VGET(2,NH,NVAL,txpr,jELEM,IDELIM,IERR)
              IF(IERR.LT.0) THEN
                  CALL M_EPRS(2,NVAL,txpr,IDELIM,IERR)
                  NELEM = 1
                  IF(IERR.NE.0) GOTO 9000
              ELSEIF(IERR.GT.0) THEN
                  GOTO 9000
              ENDIF
              ICVAR(1,NC) = NVAL
              call ucopy_i(jelem,icvar(2,nc),9)
C
C             See if the value is a number
C
              CALL QUOTYQ(TCVAL(NC))
              RNUM = VALTYQ(.TRUE.,IDELIM)
              NCHFND = NCHSCN()
              IF(IDELIM.LT.0 .AND. NCHFND.GT.0) THEN
                  if(icvar(1,nc).gt.0) then
                      ictype(nc) = 1
                  else
                      ICTYPE(NC) = 2
                  endif
                  RCVAL(1,NC)  = RNUM
              ELSE
                  CALL RESTYQ
                  CALL M_VGET(2,NH,NVAL,txpr,jELEM,IDELIM,IERR)
                  IF(IERR.LT.0) THEN
                      CALL M_EPRS(2,NVAL,txpr,IDELIM,IERR)
                      NELEM = 1
                      IF(IERR.NE.0) GOTO 9000
                  ELSEIF(IERR.GT.0) THEN
                      GOTO 9000
                  ENDIF
                  ICVAL(1,NC) = NVAL
                  call ucopy_i(jelem,icval(2,nc),9)
              ENDIF
C
C         Comis Cut - Compile the function
C
          ELSEIF(ICTYPE(NC).EQ.4) THEN
              CALL M_FCMS(0,TCVAR(NC),TFILE,TFUNC,NADR,IERR)
              IF(IERR.NE.0) GOTO 9000
              ICVAR(1,NC) = NADR
              call vzero_i(ICVAR(2,NC),9)
              TCVAL(NC)   = TFUNC
          ENDIF
 4000 CONTINUE
C
      IF(NCUSE.GT.0) THEN
          IF(.NOT.QRFILE .OR.
     +       (QRFILE .AND. QECHO)) THEN
              CALL MN_MES(LUNTTO,'ME',' The following cuts will be' //
     +         ' applied when making the projection:')
              CALL MN_CDP(0)
          ENDIF
      ENDIF
C
C     GET SPACE FOR THE NEW HISTOGRAM
C
      NBPPT2 = 0
*
      CALL MN_HNW(IDA,IDB2,NDIM2,NWRD2,NH2,NPTRH2,NPTRD2,NWH2
     +    ,NBPPT2,NTMOD2)
      IF(NH2.LE.0) GOTO 9000
C
      DO 4100 I=IABS(NDIM2)+1,2
          IDBIN2(I) = 1
 4100 CONTINUE
      CALL VZERO_r(ACONT2,3**3)
C
      IF(NDIM2.GT.0) CALL VZERO_r(RDAT(NPTRD2),NWRD2)
C
      IF(QPROF) THEN
          NVARO = IABS(NDIM2) + 1
      ELSE
          NVARO = IABS(NDIM2)
      ENDIF
C
C     Store list of variables to get for CWN's
C     Use nvarg as variable as this also includes the weight
C
      if(qcwntp) then
          call m_prjv(nvarg,nvaro,ivar,ielem)
      else
          nvcwn = 0
      endif
C
C     Initialize the reading in of the Ntuple, but do not read it in again
*     as this has already been done in m_intp.
C
      IF(NDIM.LT.0) THEN
          CALL M_NTPPNT(IDA,IDB,-1,IERR,RVAL)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
C     See if there are any extra variables to get
C     Store the location of the variables I want
*     See if there is an output variable with more than 1 element
C
      if(qcwntp) then
          call m_chkv(idh,ierr)
          if(ierr.ne.0) goto 9000
          nvloop = 0
          do i=1,nvarg
*
*             Straightforward variable - find out where it is in ivcwn
*
              if(ivar(i).gt.0) then
                  do nn=1,nvcwn
                      if(ivcwn(nn).eq.ivar(i)) then
                          iloc(i) = nn
                          if(ielem(2,i).gt.0) then
                              nnum = ielem(2,i)
                              n1 = ielem(2+nnum-1,i)
                              n2 = ielem(2+nnum,i)
                              if(n1.lt.n2 .or. n1*n2.lt.0) then
                                  if(nvloop.lt.mvloop) then
                                      nvloop = nvloop + 1
                                      ivloop(nvloop) = i
                                      ivarv(nvloop)  = nn
                                  else
                                      txterr='You can have a maximum' //
     +                                 ' of 10 loops over variables'
                                      call mn_err('MN_PRJ',txterr)
                                      goto 9000
                                  endif
                              endif
                          endif
                      endif
                  enddo
*
*             Look inside the expression
*
              else
                  iloc(i) = ivar(i)
                  ne = -ivar(i)
                  do nsub=1,lvexpr(ne)
                      if(ivetv(1,nsub,ne).gt.0 .and.
     +                   ivetv(3,nsub,ne).gt.0) then
                          nnum = ivetv(3,nsub,ne)
                          n1 = ivetv(3+nnum-1,nsub,ne)
                          n2 = ivetv(3+nnum,nsub,ne)
                          if(n1.lt.n2 .or. n1*n2.lt.0) then
                              if(nvloop.lt.mvloop) then
                                  nvloop = nvloop + 1
                                  ivloop(nvloop) = -i
                                  isubv(nvloop)  = nsub
                                  ivarv(nvloop)  = ne
                              else
                                  txterr='You can have a maximum' //
     +                             ' of 10 loops over variables'
                                  call mn_err('MN_PRJ',txterr)
                                  goto 9000
                              endif
                          endif
                      endif
                  enddo
              endif
          enddo
*
*         Store the location of the weights
*
          do i=1,2
              if((i.eq.1 .and. qwt) .or.
     +           (i.eq.2 .and. qwterr)) then
                  ilocw(i) = iloc(nvaro) + i
              endif
          enddo
      else
          nvcwn = 0
          call ucopy_i(ivar,iloc,nvaro)
          call ucopy_i(iwt,ilocw,2)
      endif
*
*     Point to jump to if we are doing 2 loops over the data
*
 4900 continue
      if(q2loop) then
          n2loop = n2loop + 1
          if(n2loop.eq.1) then
          else
          endif
      endif
*
*     Main loop over the data
*
      DO 6000 NP=NEVT1,NEVT2
          qread = .false.
*
*         Setup the element number(s) to get
*
          if(qcwntp) then
              do i=1,nvaro
*
*                 A normal variable
*
                  if(ivar(i).gt.0) then
                      nelem = 1
                      nfact = 1
                      nv   = ivar(i)
                      nnum = ielem(2,i)
                      do nn=1,ivsub(1,nv)-1
                          nelem = nelem + (ielem(2+nn,i)-1)*nfact
                          nfact = nfact * ivsub(2+nn,nv)
                      enddo
                      if(nnum.gt.ivsub(1,nv)) then
                          n1 = ielem(2+ivsub(1,nv),i)
                          n2 = ielem(2+ivsub(1,nv)+1,i)
                      elseif(nnum.gt.0 .and. nnum.eq.ivsub(1,nv)) then
                          n1 = ielem(2+ivsub(1,nv),i)
                          n2 = n1
                      else
                          n1 = ielem(1,i)
                          n2 = ielem(1,i)
                      endif
*
                      if(.not.qread .and.
     +                   (n1.lt.0 .or. n2.lt.0)) then
                          qread = .true.
                          call m_ntppnt(ida,idb,np,ierr,rval)
                          if(ierr.ne.0) goto 9000
                      endif
                      if(n1.lt.0) then
                          call m_ntpvar(-n1,1,nn,rnum,ierr)
                          n1 = nn
                      endif
                      if(n2.lt.0) then
                          call m_ntpvar(-n2,1,nn,rnum,ierr)
                          n2 = nn
                      endif
                      if(n2.le.0 .or. n2.lt.n1) goto 6000
                      nelem_max = nelem + (n2-1)*nfact
                      nelem     = nelem + (n1-1)*nfact
                      if(nelem.le.0) goto 6000
                      if(nelem.gt.ivelem(nv)) then
                          write(txterr,'(''Trying to get element'',I5
     +                     ,'' of variable'',I4)') nelem,nv
                          call mn_err('MN_PRJ',txterr)
                          goto 9000
                      endif
                      ielem(1,i)    = nelem
                      do j=1,nvloop
                          if(i.eq.ivloop(j)) then
                              nelem_loop     = nelem - nfact
                              nelem_loop_max = nelem_max
                              ieloop(1,j) = nelem_loop
                              ieloop(2,j) = nelem_loop_max
                              ieloop(3,j) = nfact
                          endif
                      enddo
*
*                 An expression
*
                  else
                      ne = -ivar(i)
                      do nsub=1,lvexpr(ne)
                        if(ivetv(1,nsub,ne).gt.0) then
                          nelem = 1
                          nfact = 1
                          nv   = ivetv(1,nsub,ne)
                          nnum = ivetv(3,nsub,ne)
                          do nn=1,ivsub(1,nv)-1
                            nelem = nelem +(ivetv(3+nn,nsub,ne)-1)*nfact
                            nfact = nfact * ivsub(2+nn,nv)
                          enddo
                          if(nnum.gt.ivsub(1,nv)) then
                              n1 = ivetv(3+ivsub(1,nv),nsub,ne)
                              n2 = ivetv(3+ivsub(1,nv)+1,nsub,ne)
                          elseif(nnum.gt.0.and.nnum.eq.ivsub(1,nv)) then
                              n1 = ivetv(3+ivsub(1,nv),nsub,ne)
                              n2 = n1
                          else
                              n1 = ivetv(2,nsub,ne)
                              n2 = ivetv(2,nsub,ne)
                          endif
*
                          if(.not.qread .and.
     +                       (n1.lt.0 .or. n2.lt.0)) then
                              qread = .true.
                              call m_ntppnt(ida,idb,np,ierr,rval)
                              if(ierr.ne.0) goto 9000
                          endif
                          if(n1.lt.0) then
                              call m_ntpvar(-n1,1,nn,rnum,ierr)
                              n1 = nn
                          endif
                          if(n2.lt.0) then
                              call m_ntpvar(-n2,1,nn,rnum,ierr)
                              n2 = nn
                          endif
                          if(n2.le.0 .or. n2.lt.n1) goto 6000
                          nelem_max = nelem + (n2-1)*nfact
                          nelem     = nelem + (n1-1)*nfact
                          if(nelem.le.0) goto 6000
                          if(nelem.gt.ivelem(nv)) then
                            write(txterr,'(''Trying to get element'',I5
     +                       ,'' of variable'',I4)') nelem,nv
                            call mn_err('MN_PRJ',txterr)
                            goto 9000
                          endif
                          ivetv(2,nsub,ne) = nelem
                          do j=1,nvloop
                              if(i.eq.-ivloop(j) .and.
     +                           nsub.eq.isubv(j)) then
                                  nelem_loop     = nelem - nfact
                                  nelem_loop_max = nelem_max
                                  ieloop(1,j) = nelem_loop
                                  ieloop(2,j) = nelem_loop_max
                                  ieloop(3,j) = nfact
                              endif
                          enddo
                        endif
                      enddo
                  endif
              enddo
          endif
*
*         Start of loop over element numbers
*
 5000     continue
          if(qcwntp .and. nvloop.ne.0) then
              do j=1,nvloop
                  ieloop(1,j) = ieloop(1,j) + ieloop(3,j)
                  if(ieloop(1,j).gt.ieloop(2,j)) goto 6000
                  if(ivloop(j).gt.0) then
                      ielem(1,ivloop(j))         = ieloop(1,j)
                      iecwn(1,ivarv(j))          = ieloop(1,j)
                  else
                      ivetv(2,isubv(j),ivarv(j)) = ieloop(1,j)
                  endif
              enddo
          endif
C
C         BINNED N-DIMENSIONAL HISTOGRAM
C
          IF(NDIM.GT.0) THEN
              IBIN(1) = IBIN(1) + 1
              RVAL(1) = ADMN(1) + FLOAT(IBIN(1)-1)*ADIF(1)
              IF(IBIN(1).GT.IDBIN(1)) THEN
                  DO 5200 NN=2,IABS(NDIM)
                      IF(IBIN(NN-1).GT.IDBIN(NN-1)) THEN
                          IBIN(NN-1) = 1
                          RVAL(NN-1) = ADMN(NN-1)
                          IBIN(NN) = IBIN(NN) + 1
                          RVAL(NN) = ADMN(NN) +
     1                        FLOAT(IBIN(NN)-1)*ADIF(NN)
                      ENDIF
 5200             CONTINUE
              ENDIF
C
              NPTR = NPTR + NWPPT
C
C             Get the number of entries
C
              if(qwt) then
              else
                  BENT = AMNE(NP,NH,NERR)
                  IF(.NOT.QERRL1) THEN
                      DBENT = BENT
                  ELSE
                      DBENT = AMNDEN(NP,NH,NERR)**2
                  ENDIF
                  rval(ndim+1) = bent
              endif
C
C         UNBINNNED N-DIMENSIONAL SCATTER PLOT
C
          ELSE
              CALL M_NTPPNT(IDA,IDB,NP,IERR,RVAL)
              IF(IERR.NE.0) GOTO 9000
C
              IF(NDIM.EQ.-1) THEN
                  IF(NWPPT.EQ.1) THEN
                      BENT = 1.0
                  ELSE
                      BENT = RVAL(2)
                  ENDIF
                  DBENT = 0.0
                  IF(QERRL1) DBENT = RVAL(4) * RVAL(4)
              ELSEIF(QWT) THEN
                  if(iwt(1).gt.0) then
                      if(qcwntp) then
                          call m_ntpvar(iwt(1),ielem(1,nvaro+1)
     +                     ,nval,bent,ierr)
                          if(ierr.ne.0) goto 9000
                      else
                          bent = rval(ilocw(1))
                      endif
                  else
                      BENT  = AM_WGT(-iwt(1))
                  endif
                  IF(QWTERR) THEN
                      if(iwt(2).gt.0) then
                          if(qcwntp) then
                              call m_ntpvar(iwt(2),ielem(1,nvaro+2)
     +                         ,nval,dbent,ierr)
                              if(ierr.ne.0) goto 9000
                          else
                              dbent = rval(ilocw(2))
                          endif
                      else
                          DBENT = AM_WGT(-iwt(2))
                      endif
                  ELSE
                      DBENT = BENT
                  ENDIF
                  dbent = dbent**2
              ELSE
                  BENT  = 1.0
                  DBENT = 1.0
              ENDIF
          ENDIF
C
C         Calculate the output variables
C
          IF(NMODE.LT.4) THEN
              DO 5300 I=1,NVARO
                  IF(IVAR(I).GT.0) THEN
                      if(qcwntp) then
                          call m_ntpvar(ivar(i),ielem(1,i)
     +                     ,nval,rval2(i),ierr)
                          if(ierr.ne.0) goto 9000
                      else
                          rval2(i) = rval(iloc(i))
                      endif
                  ELSE
                      RVAL2(I) = AM_VAR(-ILOC(I),ierr)
                      if(ierr.ne.0) goto 9000
                  ENDIF
 5300         CONTINUE
          ELSE
              CALL UCOPY_r(RVAL,RVAL2,NVARO)
          ENDIF
C
C         Store the variables needed for COMIS functions
C
          IDNEVT = NP
          VIDN1 = RVAL2(1)
          IF(NVARO.GT.1) THEN
              VIDN2 = RVAL2(2)
          ELSE
              VIDN2 = BENT
          ENDIF
          IF(NVARO.GT.2) THEN
              VIDN3 = RVAL2(3)
          ELSEIF(NVARO.GT.1) THEN
              VIDN3 = BENT
          ENDIF
C
C         Apply the cuts if there are any
C
          IF(NCUSE.LE.0) THEN
              QPASS = .TRUE.
          ELSE
              QPASS = QMNCUT(NH,QCWNTP,RVAL,NDIM)
          ENDIF
          IF(.NOT.QPASS) GOTO 6000
C
          IF(NDIM2.GT.0) THEN
C
C             Calculate the bin numbers
C
              QINS = .TRUE.
              DO 5700 I=1,NVARO
                  IF(RVAL2(I).GE.ADLO2(I)) THEN
                      IBIN2(I) =
     +                 IFIX((RVAL2(I) - ADLO2(I)) / ADIF2(I)) + 1
                  ELSE
                      IBIN2(I) =
     +                 IFIX((RVAL2(I) - ADLO2(I)) / ADIF2(I))
                  ENDIF
                  INS2(I) = (IDBIN2(I) + IBIN2(I) - 1) / IDBIN2(I)
                  INS2(I) = MAX0(0,MIN0(2,INS2(I)))
                  QINS = QINS .AND. INS2(I).EQ.1
 5700         CONTINUE
C
              IF(QINS) THEN
                  IF(NDIM2.EQ.1) THEN
                      NPTR2 = NPTRD2 + (IBIN2(1)-1)*NWPPT2
                  ELSEIF(NDIM2.EQ.2) THEN
                      NPTR2 = NPTRD2 +
     +                    (IDBIN2(1)*(IBIN2(2)-1)+(IBIN2(1)-1))*NWPPT2
                  ENDIF
                  IF(QPROF) THEN
                      RDAT(NPTR2)   = RDAT(NPTR2) + BENT*RVAL2(2)
                      RDAT(NPTR2+1) = RDAT(NPTR2+1) +
     +                 BENT*RVAL2(2)*RVAL2(2)
                      RDAT(NPTR2+2) = RDAT(NPTR2+2) + BENT
                  ELSE
                      RDAT(NPTR2) = RDAT(NPTR2) + BENT
                      IF(QERRL2) RDAT(NPTR2+1) = RDAT(NPTR2+1) + DBENT
                  ENDIF
              ENDIF
C
C             Get the element number for the ACONT array
C
              IF(NDIM2.LE.3) THEN
                  NREG = 1
                  DO 5800 I=1,NDIM2
                      NREG = NREG + 3**(I-1)*INS2(I)
 5800             CONTINUE
                  ACONT2(NREG) = ACONT2(NREG) + BENT
              ENDIF
          ELSE
C
C             Decide whether to keep the point
C
              IF(QLIMS) THEN
                  nreg = 0
                  DO 5900 I=1,IABS(NDIM2)
                      IF(QLIMA(I) .AND.
     +                   (RVAL2(I).LT.ADLO2(I) .OR.
     +                    RVAL2(I).GT.ADHI2(I))) THEN
                          if(ndim2.eq.-1) then
                              if(rval2(i).lt.adlo2(i)) then
                                  acont2(1) = acont2(1) + bent
                              else
                                  acont2(3) = acont2(3) + bent
                              endif
                          elseif(ndim2.eq.-2) then
                              if(rval2(i).lt.adlo2(i)) then
                                  acont2(nreg+1) = acont2(nreg+1) + bent
                              else
                                  acont2(nreg+3) = acont2(nreg+3) + bent
                              endif
                              nreg = nreg + 3
                          endif
                          GOTO 6000
                      ENDIF
 5900             CONTINUE
              ENDIF
C
              NPNT2 = NPNT2 + 1
              IF(NPNT2.GT.NSPC2) THEN
                  NSPC2 = NSPC2 + 100
                  NWRD2 = NSPC2*NWPPT2
                  CALL M_MORE(NPTRH2,NPTRD2,NWRD2,IERR)
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
              NPTR2 = NPTRD2 + (NPNT2-1)*NWPPT2
              IF(NDIM2.EQ.-1) THEN
                  RDAT(NPTR2) = RVAL2(1)
                  RDAT(NPTR2 + 1) = BENT
                  IF(QERRL2) then
                      RDAT(NPTR2 + 2) = 0.0
                      RDAT(NPTR2 + 3) = DBENT
                  ENDIF
                  acont2(2) = acont2(2) + bent
              ELSEIF(NDIM2.LT.-1) THEN
                  CALL UCOPY_r(RVAL2,RDAT(NPTR2),IABS(NDIM2))
                  if(ndim2.eq.-2) acont2(5) = acont2(5) + bent
              ENDIF
          ENDIF
*
*         If we are looping over the elements of a CWN, goto next one
*
          if(qcwntp .and. nvloop.ne.0) goto 5000
 6000 CONTINUE
      if(q2loop .and. n2loop.eq.1) goto 4900
C
C     NOW FILL IN ALL THE REST OF THE STUFF FOR THE PROJECTED HISTOGRAM
C     INTO THE RIGHT SPOT
C
      EDENT2 = 0.0
      EDLO2  = +1.0E+30
      EDHI2  = -1.0E+30
      DY     = 0.0
      IF(NDIM2.GT.0) THEN
          NPTR2 = NPTRD2 - NWPPT2 - 1
          DO 7100 II=1,NPNT2
              NPTR2 = NPTR2 + NWPPT2
              IF(QPROF) THEN
                  SUMY  = RDAT(NPTR2 + 1)
                  SUMY2 = RDAT(NPTR2 + 2)
                  WGT   = RDAT(NPTR2 + 3)
                  IF(WGT.GT.0.0) THEN
                      Y = SUMY / WGT
                      RDAT(NPTR2 + 1) = Y
                      IF(NMODE.EQ.2) THEN
                          DY = SQRT(ABS(SUMY2/WGT - Y**2) / WGT)
                      ELSE
                          DY = SQRT(ABS(SUMY2/WGT - Y**2))
                      ENDIF
                      RDAT(NPTR2 + 2) = DY
                      RDAT(NPTR2 + 3) = DY
                      RDAT(NPTR2 + 4) = WGT
                  ELSE
                      Y = 0.0
                      RDAT(NPTR2 + 1) = 0.0
                      RDAT(NPTR2 + 2) = 0.0
                  ENDIF
              ELSE
                  Y   = RDAT(NPTR2 + 1)
                  IF(QERRL2) THEN
                      DY2 = RDAT(NPTR2 + 2)
                      DY  = SQRT(ABS(DY2))
                      RDAT(NPTR2 + 2) = DY
                  ENDIF
              ENDIF
              EDENT2 = EDENT2 + Y
              EDLO2 = AMIN1(EDLO2,Y-DY)
              EDHI2 = AMAX1(EDHI2,Y+DY)
 7100     CONTINUE
C
C     Set the X limits for a series of points if necessary
C
      ELSE IF(NDIM2.EQ.-1) THEN
          QLIMS = ADLO2(1).NE.0.0      .OR. ADHI2(1).NE.0.0 .OR.
     +            ADLO2(1).LT.ADHI2(1)
          NPTR2 = NPTRD2 - NWPPT2
          IF(.NOT.QLIMS) THEN
              ADLO2(1) = +1.0E+30
              ADHI2(1) = -1.0E+30
          ENDIF
          DO 7200 II=1,NPNT2
              NPTR2 = NPTR2 + NWPPT2
              X   = RDAT(NPTR2 + 0)
              Y   = RDAT(NPTR2 + 1)
              DX  = 0.0
              IF(QERRL2) THEN
                  DX  = RDAT(NPTR2 + 2)
                  DY2 = RDAT(NPTR2 + 3)
                  DY  = SQRT(ABS(DY2))
                  RDAT(NPTR2 + 3) = DY
              ENDIF
              IF(.NOT.QLIMS) THEN
                  ADLO2(1) = AMIN1(ADLO2(1),X-DX)
                  ADHI2(1) = AMAX1(ADHI2(1),X+DX)
              ENDIF
              EDENT2 = EDENT2 + Y
              EDLO2 = AMIN1(EDLO2,Y-DY)
              EDHI2 = AMAX1(EDHI2,Y+DY)
 7200     CONTINUE
C
C     Set the X limits for a scatter plot or Ntuple if necessary
C
      ELSE
          QLIMS = .FALSE.
          DO JJ=1,IABS(NDIM2)
              QLIMS = QLIMS .OR.
     +         (ADLO2(JJ).NE.0.0 .OR. ADHI2(JJ).NE.0.0 .OR.
     +          ADLO2(JJ).LT.ADHI2(JJ))
          ENDDO
          IF(.NOT.QLIMS) THEN
              DO JJ=1,IABS(NDIM2)
                  ADLO2(JJ) = +1.0E+30
                  ADHI2(JJ) = -1.0E+30
              ENDDO
*
              NPTR2 = NPTRD2 - NWPPT2
              DO II=1,NPNT2
                  NPTR2 = NPTR2 + NWPPT2
                  DO JJ=1,IABS(NDIM2)
                      X = RDAT(NPTR2 + JJ - 1)
                      ADLO2(JJ) = AMIN1(ADLO2(JJ),X)
                      ADHI2(JJ) = AMAX1(ADHI2(JJ),X)
                  ENDDO
              ENDDO
          ENDIF
          NWRD2  = NPNT2 * NWPPT2
          EDENT2 = FLOAT(NPNT2)
          EDLO2  = 0.0
          EDHI2  = 0.0
          IF(EDENT2.GT.0.0) EDHI2 = 1.0
      ENDIF
C
C     Protect limits on number of entries against crazy values
C
      if(abs(edlo2).lt.1.0e-31) edlo2 = 0.0
      if(abs(edhi2).lt.1.0e-31) edhi2 = 0.0
C
      NWTOT2 = NWH2 + NWRD2
C
C     CREATE THE TITLE FOR THE PROJECTION
C     IF WE HAVE REDUCED THE NUMBER OF DIMENSIONS
C
      TXT1 = TDTIT(NH)
      IF(IABS(NDIM2).LT.IABS(NDIM) .AND. IABS(NDIM2).LE.2) THEN
          LENT = LENOCC(TXT1)
          if(iabs(ndim2).eq.1) then
              nn = 1
          else
              nn = 2
          endif
          IF(TXT1.EQ.' ' .OR. TXT1.EQ.'No Name') THEN
              TXT2 = TVAR2(nn)
          ELSEIF(TXT1(LENT:LENT).EQ.'.') THEN
              TXT2 = CONCAT(TXT1,TVAR2(nn))
          ELSE
              TXT2 = CONCT0(TXT1,'.')
              TXT1 = CONCAT(TXT2,TVAR2(nn))
              TXT2 = TXT1
          ENDIF
          IF(IABS(NDIM2).EQ.1) THEN
              TXT1 = CONCAT(TXT2,'axis')
              TXT2 = TXT1
          ELSE
              TXT1 = CONCAT(TXT2,'vs')
              TXT2 = CONCAT(TXT1,TVAR2(1))
          ENDIF
          TXT1 = TXT2
      ENDIF
C
C     FILL IN THE HEADER
C
      CALL M_RTIM(NHDAT2,NHTIM2)
      CALL MN_HDU(RDAT(NPTRH2),NWTOT2,NWH2,NWRD2,IDA,IDB2
     1    ,NDIM2,NWPPT2,NPNT2,NHDAT2,NHTIM2,NSDAT2,NSTIM2,NTMOD2
     +    ,EDENT2,EDLO2,EDHI2,IDBIN2,ADLO2,ADHI2,NBPPT2,ACONT2)
      CALL MN_PTU(NH2,NWTOT2,IDA,IDB2,NPTRH2,NPTRD2
     1    ,TXT1,'*'//TDFIL(NH),' ',TNAME2)
      CALL MN_MSU(IDA,IDB2,NDIM2,NWH2,NH2)
C
C     Make a plot of the projection if it has been requested
C
      IF(NMODE.EQ.1) THEN
          CALL M_NDRW(IDA,IDB2)
      ENDIF
C
 9000 CONTINUE
      QPROJ = .FALSE.
C
      END
