$!
$! COM file to run MN_FIT from either your terminal or a file
$! To run from a terminal say
$! DO MN_FIT                at Cornell
$! @DISK$L32:[BROCK]MN_FIT  on VXCERN
$! MN_FIT                   on the L3 online cluster
$!
$! To run from a file add filename.ext to the above syntax
$! The screen device or a blank line should be included in filename.ext.
$!
$! Author Ian C. Brock  Jan 9, 1987
$! Last changed: Nov 8, 1990
$!
$! If a parameter starts with the symbol defined by Par_Flag,
$ Par_Flag = "-"
$! then it is interpreted as a special parameter. The currently
$! defined special parameters are:
$!
$! Parameter   Action
$!
$! -?           Help
$! -TEST        Use the test version
$! -USER        Use a user version (give the exe name if it is not the default)
$! -OLD         Use the old version
$! -DEV         Use the development version
$! -DISPLAY     Use L3 online display version
$! -GKSGRAL     Use the GKSGRAL version
$! -VAXGKS      Use the VAXGKS version (equivalent to DECGKS)
$! -DECGKS      Use the DECGKS version (equivalent to VAXGKS)
$! -DGKS3D      Use the DEC GKS 3D version
$! -DI3000      Use the DI3000 version
$! -X11         Use the X11 version
$! -NODE        Hostname for the display in X-windows version
$! -TRANSPORT   Transport mechanism for the display in X-windows version
$! -SERVER      Server number for the display in X-windows version
$! -PLTSUB      Use the PLTSUB version
$! -RUN         Run parameters - only with cpc version at present
$! -DBG         Run Mn_Fit in debug
$! -CPC         Run CPC version of Mn_Fit
$!
$ If "''DebugIt'" .eqs. "" Then $ Debugit = 0
$!
$ job    = f$mode()
$ on error then $goto end
$ trun   = "run/nodebug"
$ tfname = "mn_fit_exe:mn_fit"
$ tgks   = ""
$ tfile  = ""
$ xnode  = ""
$ xtrans = ""
$ xserv  = ""
$ rparam = ""
$!
$! Set up the default graphics package
$!
#include "grafpack.inc"
$!
$ GoSub Check_Params
$!
$! Set up the Control_Y exit if not debugging Mn_Fit
$!
$ if f$locate("nodeb",trun).lt.f$length(trun) then $on control_y then $goto end
$!
#include "mn_logic.inc"
$!
$! Set up special stuff for GKSGRAL
$!
$ if tgks.eqs."g"
$  then
$     def gks_window mn_fit_dir:
$!
$!     These definitions needed for GKSGRAL 7.4/2.6 and earlier.
$!
$!     twindow = ""
$!     cop mn_fit_dir:mn_fit_window.dat []window.dat
$!     twindow = f$search("window.dat.")
$!     cernlib graflib
#endif
#if ( defined(L3) )
$!
$!    On L3 VMS machines find out which directory to put FOR092 in
$!
$     user = f$user()
$     luser = f$length(user)
$     comma = f$locate(",",user)
$     if comma.lt.luser then user = "[" + f$extract(comma+1,luser-comma,user)
$     open/write/err=try_sys$login aa l3$scr:'user'junk.tmp
$     close aa
$     delete/nolog/noconf l3$scr:'user'junk.tmp.
$     l_for092 = "l3$scr:" + user
$     goto end_for092
$try_sys$login:
$     l_for092 = "sys$login"
$     goto end_for092
$end_for092:
#endif
#if ( !defined(L3) )
$     l_for092 = "sys$login"
#endif
$ endif
$!
$! For X windows version get the node name and transport mode
$!
$ if tgks.eqs."x"
$  then
#endif
#if ( defined(CLEO) )
$    pornam = f$getdvi("TT","TT_ACCPORNAM")
$    start = f$locate("L",pornam)
$    finis = f$locate(".",pornam)
$    lents = finis - start
$    machine = f$extract(start,lents,pornam)
$    if machine .eqs. ""
$     then
$      machine = f$trnlnm("sys$node")
$      machine = f$extract(0,f$locate(":",machine),machine)
$     endif
#endif
#if ( !defined(CLEO) )
$    machine = f$trnlnm("sys$node")
$    machine = f$extract(0,f$locate(":",machine),machine)
#endif
$    tdisplay = f$trnlnm("decw$display")
$    if tdisplay.eqs."" .or. -
        xnode.nes."" .or. xtrans.nes."" .or. xserv.nes.""
$     then
$        if xnode.eqs."" then  $xnode = machine
$        if xtrans.eqs."" then $xtrans = "DECNET"
$        if xserv.eqs.""
$         then
$            write sys$output "Setting DISPLAY to node ''xnode' via ''xtrans'"
$            set display/create/node='xnode'/transport='xtrans'
$        else
$            write sys$output "Setting DISPLAY to node ''xnode' via", -
              " ''xtrans', server ''xserv'"
$            set display/create/node='xnode'/transport='xtrans'/server='xserv'
$        endif
$    else
$        write sys$output "Using default setting of DISPLAY:"
$        show display
$    endif
$ endif
$!
$ if tfile.eqs."" then $goto inter
$!
$! read commands from a file
$!
$ open/read/err=open_err aa 'tfile'
$ tfilename = f$search(tfile)
$ close aa
$ def/user sys$input 'tfilename'
$ GOTO run
$OPEN_ERR:
$ WRITE SYS$OUTPUT "Could not open file: ",tfile,"  Aborting"
$ GOTO END
$!
$! Running from a terminal
$!
$INTER:
$ ASS/USER SYS$COMMAND SYS$INPUT
$ GOTO RUN
$RUN:
$ if tgks.eqs."g"
$  then
$    write sys$output "Defining FOR092 as ",l_for092
$    def/user for092 'l_for092'
$    def/user gks$fonts gks_root:[dat]
$!   def/user gks_window mn_fit_dir
$ endif
$realrun:
$ if f$locate("nodeb",trun).lt.f$length(trun)
$  then
$    mn_fit_run = "$''tfname'_''tgks'.exe"
$ else
$    mn_fit_run = "''trun' ''tfname'_''tgks'"
$    rparam = ""
$ endif
$ on error then $goto end
$ mn_fit_run 'rparam'
$END:
$! if tgks.eqs."_g"
$!  then
$!    if twindow.nes."" then $delete/noconf 'twindow'
$! endif
$ exit
$!
$! Start of Check_Params subroutines.
$!
$Check_Params:
$ Par = 1
$Check_Params_Loop:
$ If Par    .eq.  9  Then $ Goto Check_Params_End
$ If Debugit Then $ Show Symbol P'Par'
$ If P'Par' .eqs. "" Then $ Goto Check_Params_End
$ If F$Locate(Par_Flag,P'Par') .eq. 0
$  Then
$    GoSub Check_Params_Found_One
$ Else
$    tfile = P'Par'
$ EndIf
$ Par = Par + 1
$ GoTo Check_Params_Loop
$Check_Params_end:
$ Return ! Check_Params
$!
$Check_Params_Found_One:
$ Good_Par = 0
$ Label_tmp = F$Edit(F$Extract(1,3,P'Par'),"UPCASE")
$ If f$extract(0,1,Label_tmp) .eqs. "?"   Then $ GoSub HELP
$ If f$extract(0,1,Label_tmp) .eqs. "H"   Then $ GoSub HELP
$ If f$extract(0,2,Label_tmp) .eqs. "TE"  Then $ GoSub TEST
$ If f$extract(0,1,Label_tmp) .eqs. "T"   Then $ GoSub TRANS
$ If f$extract(0,1,Label_tmp) .eqs. "S"   Then $ GoSub SERVER
$ If f$extract(0,1,Label_tmp) .eqs. "U"   Then $ GoSub USER
$ If f$extract(0,1,Label_tmp) .eqs. "O"   Then $ GoSub OLD
$ If f$extract(0,1,Label_tmp) .eqs. "G"   Then $ GoSub GKSGRAL
$ If f$extract(0,3,Label_tmp) .eqs. "DEV" Then $ GoSub DEV
$ If f$extract(0,3,Label_tmp) .eqs. "DIS" Then $ GoSub DISPLAY
$ If f$extract(0,2,Label_tmp) .eqs. "DE"  Then $ GoSub DECGKS
$ If f$extract(0,1,Label_tmp) .eqs. "V"   Then $ GoSub DECGKS
$ If f$extract(0,2,Label_tmp) .eqs. "DG"  Then $ GoSub DGKS3D
$ If f$extract(0,3,Label_tmp) .eqs. "DI3" Then $ GoSub DI3000
$ If f$extract(0,1,Label_tmp) .eqs. "X"   Then $ GoSub X11
$ If f$extract(0,1,Label_tmp) .eqs. "N"   Then $ GoSub NODE
$ If f$extract(0,1,Label_tmp) .eqs. "P"   Then $ GoSub PLTSUB
$ If f$extract(0,3,Label_tmp) .eqs. "RUN" Then $ GoSub RUN_PARAM
$ If f$extract(0,2,Label_tmp) .eqs. "DB"  Then $ GoSub DEBUG
$ If f$extract(0,2,Label_tmp) .eqs. "CP"  Then $ GoSub CPC
$ If .not. Good_Par
$  Then
$     Write Sys$Output -
       "MN_FIT: Parameter P''Par' =(",P'Par',") not understood. EXITING."
$     Exit
$ EndIf
$!
$ Return ! Check_Params_Found_One
$!
$HELP:
$ ww = "write sys$output"
$ 'ww' "The following options are available:"
$ 'ww' "-? or -H     This help"
$ 'ww' "-TEST        Use the test version"
$ 'ww' "-USER        Use a user version", -
   " (give the exe name if it is not the default)"
$ 'ww' "-OLD         Use the old version"
$ 'ww' "-DEV         Use the development version"
$ 'ww' "-DISPLAY     Use L3 online display version"
$ 'ww' "-GKSGRAL     Use the GKSGRAL version"
$ 'ww' "-VAXGKS      Use the VAXGKS version (equivalent to DECGKS)"
$ 'ww' "-DECGKS      Use the DECGKS version (equivalent to VAXGKS)"
$ 'ww' "-DGKS3D      Use the DEC GKS3D version"
$ 'ww' "-DI3000      Use the DI3000 version"
$ 'ww' "-X11         Use the X11 version"
$ 'ww' "-NODE        Node name for X display (default=SYS$NODE)"
$ 'ww' "-TRANS       Transport mode for data (default = DECNET)"
$ 'ww' "-SERVER      Server number for X display"
$ 'ww' "-PLTSUB      Use the PLTSUB version"
$ 'ww' "-RUN         Give parameters for running Mn_Fit (Vax CPC version)
$ 'ww' "-DBG         Run Mn_Fit in debug"
$ 'ww' "-CPC         Run CPC version of Mn_Fit"
$ Good_Par = 1
$ Exit   ! ? or H = Help
$!
$TEST:
$ tfname = "mn_fit_exe:mn_test"
$ Good_Par = 1
$ Return ! TEST = Test version
$!
$DISPLAY:
$ tfname = "mn_fit_exe:mn_dsp"
$ Good_Par = 1
$ Return ! DISPLAY = Display version
$!
$CPC:
$ tfname = "mn_fit_exe:mn_dsp_cpc"
$ Good_Par = 1
$ Return ! DISPLAY = Display version
$!
$OLD:
$ tfname = "mn_fit_exe:mn_old"
$ Good_Par = 1
$ Return ! OLD = Old version
$!
$DEV:
$ tfname = "mn_fit_exe:mn_dev"
$ Good_Par = 1
$ Return ! DEV = Development version
$!
$USER:
$ tfname = "mn_user"
$ tgks = ""
$ Par_Next = Par + 1
$ If Par_Next.lt.9 .and. P'Par_Next'.nes."" .and. -
     f$locate(Par_Flag,P'Par_Next').ne.0
$  then
$    tfname = P'Par_Next'
$    Par = Par_Next
$ EndIf
$ Good_Par = 1
$ Return ! USER = User version - no qualifier
$!
$GKSGRAL:
$ tgks     = "g"
$ Good_Par = 1
$ Return ! GKSGRAL = GKSGRAL version
$DECGKS:
$ tgks     = "v"
$ Good_Par = 1
$ Return ! DECGKS = DECGKS/VAXGKS version
$DGKS3D:
$ tgks     = "d"
$ Good_Par = 1
$ Return ! DGKS3D = DEC GKS3D version
$DI3000:
$ tgks     = "3"
$ Good_Par = 1
$ Return ! DI3000 = DI3000 version
$X11:
$ tgks     = "x"
$ Good_Par = 1
$ Return ! X11 = X11 version
$NODE:
$ Par_Next = Par + 1
$ If Par_Next.lt.9 .and. P'Par_Next'.nes."" .and. -
     f$locate(Par_Flag,P'Par_Next').ne.0
$  then
$    xnode = P'Par_Next'
$    Par = Par_Next
$    Good_Par = 1
$ EndIf
$ Return ! NODE = X Windows display node
$TRANS:
$ Par_Next = Par + 1
$ If Par_Next.lt.9 .and. P'Par_Next'.nes."" .and. -
     f$locate(Par_Flag,P'Par_Next').ne.0
$  then
$    xtrans = P'Par_Next'
$    Par = Par_Next
$    Good_Par = 1
$ EndIf
$ Return ! TRANSPORT = X Windows transport mode
$SERVER:
$ Par_Next = Par + 1
$ If Par_Next.lt.9 .and. P'Par_Next'.nes."" .and. -
     f$locate(Par_Flag,P'Par_Next').ne.0
$  then
$    xserv = P'Par_Next'
$    Par = Par_Next
$    Good_Par = 1
$ EndIf
$ Return ! SERVER = X Windows server number
$PLTSUB:
$ tgks     = "p"
$ Good_Par = 1
$ Return ! PLTSUB = PLTSUB version
$!
$DEBUG:
$ trun   = "run/debug"
$ Good_Par = 1
$ Return ! DBG = Run Mn_Fit in debug
$!
$RUN_PARAM:
$ Par_Next = Par + 1
$ If Par_Next.lt.9 .and. P'Par_Next'.nes."" .and. -
     f$locate(Par_Flag,P'Par_Next').ne.0
$  then
$    rparam = P'Par_Next'
$    Par = Par_Next
$ EndIf
$ Good_Par = 1
$ Return ! PAR = Run parameter
$!
$! End of Check_Params subroutines.
