import sys
from distutils.core import setup

# make win32 distribution
if sys.platform == 'win32':
    import py2exe

    # list additional files
    additionalFiles = [("",[
                            "history.txt",
                            "install.txt",
                            "license.txt",
                            "readme.txt",
                            ])
                        ]

    # py2exe options
    py2exe_options = dict(
        bundle_files = 1,
        compressed = True,
        optimize = 2
        )

    # main setup
    setup(
        name = "mMass",
        version = "2.4.0",
        description = "Open Source Mass Spectrometry Tool for Proteomics",
        author = "Martin Strohalm",
        author_email = "mmass@biographics.cz",
        url = 'http://mmass.biographics.cz/',
        license = 'GNU General Public License',
        windows = [
            {
                "script": "mmass.py",
                "icon_resources": [(1, "images/icon.ico")]
            }],
        data_files = additionalFiles,
        options = dict(py2exe = py2exe_options),
        zipfile = None
    )


# make OSX distribution
if sys.platform == 'darwin':
    import py2app

    # list additional files
    additionalFiles = [
                "images/icon_msd.icns",
                "images/icon_mzdata.icns",
                "images/icon_mzxml.icns",
    ]

    # py2app options
    py2appOptions = dict(
        iconfile = 'images/icon.icns',
        argv_emulation = True,
        compressed = 1,
        optimize = 2,
        plist=dict(
            CFBundleName = "mMass",
            CFBundleDisplayName = "mMass",
            CFBundleExecutable = "mMass",
            CFBundleSignature = "mMass",
            CFBundleIdentifier = "cz.biographics.mmass",
            CFBundlePackageType = "APPL",
            CFBundleShortVersionString = "2.4.0",
            CFBundleVersion = "2.4.0",
            CFBundleGetInfoString = "mMass 2.4.0 - Open Source Mass Spectrometry Tool for Proteomics",
            CFBundleIconFile = "icon.icns",
            NSHumanReadableCopyright = "(c)2005-07 Martin Strohalm",
            LSHasLocalizedDisplayName = False,
            NSAppleScriptEnabled = False,
            CFBundleDocumentTypes = [
                dict(
                CFBundleTypeExtensions = ["msd"],
                CFBundleTypeName = "mMass Spectrum Document",
                CFBundleTypeIconFile = "icon_msd.icns",
                CFBundleTypeOSTypes = ["TEXT"],
                CFBundleTypeRole = "Editor",
                NSDocumentClass = "MyDocument",
                ),
                dict(
                CFBundleTypeExtensions = ["mzdata"],
                CFBundleTypeName = "mzData Mass Spectrum Document",
                CFBundleTypeIconFile = "icon_mzdata.icns",
                CFBundleTypeOSTypes = ["TEXT"],
                CFBundleTypeRole = "Viewer",
                NSDocumentClass = "MyDocument",
                ),
                dict(
                CFBundleTypeExtensions = ["mzxml"],
                CFBundleTypeName = "mzXML Mass Spectrum Document",
                CFBundleTypeIconFile = "icon_mzxml.icns",
                CFBundleTypeOSTypes = ["TEXT"],
                CFBundleTypeRole = "Viewer",
                NSDocumentClass = "MyDocument",
                ),
            ]
        )
    )

    # main setup
    setup(
        app = ['mmass.py'],
        name = "mMass",
        author = "Martin Strohalm",
        author_email = "mmass@biographics.cz",
        url = 'http://mmass.biographics.cz/',
        license = 'GNU General Public License',
        options = dict(py2app = py2appOptions),
        data_files = additionalFiles,
    )
