# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Define application menubar.

# load libs
import wx

# load modules
from ids import *
from hotkeys import *


class menuBar(wx.MenuBar):
    """ Make application main menubar. """

    # ----
    def __init__(self):
        wx.MenuBar.__init__(self)

        # file menu
        fileMenu = wx.Menu()
        fileMenu.Append(ID_fileNew, "New Document" +hotkeys[ID_fileNew], " Create new blank document")
        fileMenu.AppendSeparator()

        fileMenu.Append(ID_fileOpen, "Open..." +hotkeys[ID_fileOpen], " Open document")
        fileMenu.Append(ID_fileSave, "Save" +hotkeys[ID_fileSave], " Save document")
        fileMenu.Append(ID_fileSaveAs, "Save As..." +hotkeys[ID_fileSaveAs], " Save document with new name")

        fileRecentSubMenu = wx.Menu()
        fileRecentSubMenu.Append(ID_fileRecentFiles0, "0:" +hotkeys[ID_fileRecentFiles0], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles1, "1:" +hotkeys[ID_fileRecentFiles1], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles2, "2:" +hotkeys[ID_fileRecentFiles2], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles3, "3:" +hotkeys[ID_fileRecentFiles3], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles4, "4:" +hotkeys[ID_fileRecentFiles4], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles5, "5:" +hotkeys[ID_fileRecentFiles5], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles6, "6:" +hotkeys[ID_fileRecentFiles6], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles7, "7:" +hotkeys[ID_fileRecentFiles7], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles8, "8:" +hotkeys[ID_fileRecentFiles8], " Open document")
        fileRecentSubMenu.Append(ID_fileRecentFiles9, "9:" +hotkeys[ID_fileRecentFiles9], " Open document")
        fileMenu.AppendMenu(ID_fileRecentFiles, "Recent Files", fileRecentSubMenu)
        fileMenu.AppendSeparator()

        filePrintSubMenu = wx.Menu()
        filePrintSubMenu.Append(ID_filePrintSpectrum, "Spectrum..." +hotkeys[ID_filePrintSpectrum], " Print current spectrum view")
        filePrintSubMenu.Append(ID_filePrintReport, "Report..." +hotkeys[ID_filePrintReport], " Print annotated peaklist")
        fileMenu.AppendMenu(ID_filePrint, "Print", filePrintSubMenu)

        fileMenu.Append(ID_filePageSetup, "Page Setup..." +hotkeys[ID_filePageSetup], " Page setup")
        fileMenu.AppendSeparator()

        fileImportSubMenu = wx.Menu()
        fileImportSubMenu.Append(ID_fileImportPeaklist, "Peaklist..." +hotkeys[ID_fileImportPeaklist], " Import peaklist from ASCII file")
        fileImportSubMenu.Append(ID_fileImportSequence, "Sequence..." +hotkeys[ID_fileImportSequence], " Import sequence from ASCII file")
        fileMenu.AppendMenu(ID_fileImport, "Import", fileImportSubMenu)

        fileExportSubMenu = wx.Menu()
        fileExportSubMenu.Append(ID_fileExportSpectrumData, "Spectrum Data..." +hotkeys[ID_fileExportSpectrumData], " Export spectrum data")
        fileExportSubMenu.Append(ID_fileExportSpectrumImage, "Spectrum Image..." +hotkeys[ID_fileExportSpectrumImage], " Export current spectrum view to image file")
        fileExportSubMenu.Append(ID_fileExportPeaklist, "Peaklist..." +hotkeys[ID_fileExportPeaklist], " Export labeled peaks to ASCII file")
        fileMenu.AppendMenu(ID_fileExport, "Export", fileExportSubMenu)
        fileMenu.AppendSeparator()

        fileMenu.Append(ID_fileInfo, "Information..." +hotkeys[ID_fileInfo], " Show information about current document")
        fileMenu.AppendSeparator()

        fileMenu.Append(ID_fileClose, "Close Document" +hotkeys[ID_fileClose], " Close current document")
        fileMenu.Append(ID_fileExit, "Exit" +hotkeys[ID_fileExit], " Exit application")

        # peaklist menu
        peaklistMenu = wx.Menu()
        peaklistMenu.Append(ID_peaklistUndo, "Undo" +hotkeys[ID_peaklistUndo], " Undo last change in peaklist")
        peaklistMenu.Append(ID_peaklistRedo, "Redo" +hotkeys[ID_peaklistRedo], " Redo last change in peaklist")
        peaklistMenu.AppendSeparator()

        peaklistMenu.Append(ID_peaklistAddPeak, "Add Peak..." +hotkeys[ID_peaklistAddPeak], " Add new peak to the peaklist manually")
        peaklistMenu.AppendSeparator()

        peaklistMenu.Append(ID_peaklistSelectAllPeaks, "Select All Peaks" +hotkeys[ID_peaklistSelectAllPeaks], " Select all peaks in peaklist")
        peaklistMenu.Append(ID_peaklistSelectAnnotatedPeaks, "Select Annotated Peaks" +hotkeys[ID_peaklistSelectAnnotatedPeaks], " Select all annotated peaks in peaklist")
        peaklistMenu.Append(ID_peaklistSelectByTreshold, "Select by Treshold..." +hotkeys[ID_peaklistSelectByTreshold], " Select peaks by intensity treshold")
        peaklistMenu.Append(ID_peaklistInvertSelection, "Invert Selection" +hotkeys[ID_peaklistInvertSelection], " Invert current selection")
        peaklistMenu.AppendSeparator()

        peaklistMenu.Append(ID_peaklistClearAllAnnots, "Clear All Annotations" +hotkeys[ID_peaklistClearAllAnnots], " Clear all peaklist's annotations")
        peaklistMenu.Append(ID_peaklistDeleteAllPeaks, "Delete All Peaks" +hotkeys[ID_peaklistDeleteAllPeaks], " Delete all labeled peaks")
        peaklistMenu.AppendSeparator()

        peaklistMenu.Append(ID_peaklistCopyToClipboard, "Copy to Clipboard" +hotkeys[ID_peaklistCopyToClipboard], " Copy mass/z and intensity to clipboard")
        peaklistMenu.AppendSeparator()

        peaklistMenu.Append(ID_peaklistRefresh, "Refresh" +hotkeys[ID_peaklistRefresh], " Refresh peaklist")

        # spectrum menu
        spectrumMenu = wx.Menu()

        spectrumMenu.Append(ID_spectrumLabelPoint, "Label Point" +hotkeys[ID_spectrumLabelPoint], " Label point in spectrum", wx.ITEM_RADIO)
        spectrumMenu.Append(ID_spectrumLabelPeak, "Label Peak" +hotkeys[ID_spectrumLabelPeak], " Label peak by centroid", wx.ITEM_RADIO)
        spectrumMenu.Append(ID_spectrumDeleteLabel, "Delete Label" +hotkeys[ID_spectrumDeleteLabel], " Delete selected labels", wx.ITEM_RADIO)
        spectrumMenu.Append(ID_spectrumMeasureDistance, "Distance Measurement" +hotkeys[ID_spectrumMeasureDistance], " Measure distance between two peaks", wx.ITEM_RADIO)
        spectrumMenu.AppendSeparator()

        spectrumMenu.Append(ID_spectrumAddToCompare, "Add to Compare..." +hotkeys[ID_spectrumAddToCompare], " Add spectrum to compare with current")
        spectrumMenu.Append(ID_spectrumCopyToClipboard, "Copy to Clipboard" +hotkeys[ID_spectrumCopyToClipboard], " Copy current spectrum view to clipboard")
        spectrumMenu.Append(ID_spectrumSetRange, "Set Range..." +hotkeys[ID_spectrumSetRange], " Set spectrum range")
        spectrumMenu.AppendSeparator()

        spectrumMenu.Append(ID_spectrumViewOptions, "View Options..." +hotkeys[ID_spectrumViewOptions], " Show spectrum view option")
        spectrumMenu.Append(ID_spectrumRefresh, "Refresh" +hotkeys[ID_spectrumRefresh], " Refresh labels in spectrum")

        # processing menu
        processingMenu = wx.Menu()

        processingMenu.Append(ID_processingUndo, "Undo Processing" +hotkeys[ID_processingUndo], " Revert peaklist and spectrum to the state before last processing applied")
        processingMenu.AppendSeparator()

        processingMenu.Append(ID_processingInternalCalibration, "Internal Callibration..." +hotkeys[ID_processingInternalCalibration], " Internal standard calibration")
        processingMenu.Append(ID_processingStatisticalCalibration, "Statistical Calibration..." +hotkeys[ID_processingStatisticalCalibration], " Statistical calibration for protein digest spectrum")
        processingMenu.AppendSeparator()

        # processingMenu.Append(ID_processingBaseline, "Baseline Corection..." +hotkeys[ID_processingBaseline], " Subtract baseline from spectrum (not implemented yet)")
        # processingMenu.Append(ID_processingSmooth, "Smooth Spectrum..." +hotkeys[ID_processingSmooth], " Smooth spectrum by Savitzky-Golay filter (not implemented yet)")
        processingMenu.Append(ID_processingCrop, "Crop Spectrum..." +hotkeys[ID_processingCrop], " Crop spectrum to selected range")

        # matching
        matchingMenu = wx.Menu()
        matchingMenu.Append(ID_matchingMatchData, "Match Data" +hotkeys[ID_matchingMatchData], " Match current data to peaklist")
        matchingMenu.Append(ID_matchingMatchInfo, "Show Match Info" +hotkeys[ID_matchingMatchInfo], " Show current match info")
        matchingMenu.Append(ID_matchingAnnotate, "Annotate Peaklist" +hotkeys[ID_matchingAnnotate], " Annotate matched peaks in peaklist by current data")

        # sequence menu
        sequenceMenu = wx.Menu()
        sequenceMenu.Append(ID_sequenceEditMod, "Modifications..." +hotkeys[ID_sequenceEditMod], " Edit sequence modifications")
        sequenceMenu.AppendSeparator()

        sequenceMenu.Append(ID_sequenceSearchMass, "Search for Mass..." +hotkeys[ID_sequenceSearchMass], " Search for specified mass in sequence")
        sequenceMenu.Append(ID_sequenceSearchSeq, "Search for Sequence..." +hotkeys[ID_sequenceSearchSeq], " Search for specified sub-sequence in sequence")
        sequenceMenu.AppendSeparator()

        sequenceMenu.Append(ID_fileImportSequence, "Import Sequence..." +hotkeys[ID_fileImportSequence], " Import sequence from ASCII file")

        # tools menu
        toolsMenu = wx.Menu()
        toolsMenu.Append(ID_toolsMSpec, "Mass Spectrum" +hotkeys[ID_toolsMSpec], " Analyse mass spectrum")
        toolsMenu.Append(ID_toolsMSeq, "Sequence Editor" +hotkeys[ID_toolsMSeq], " Protein / peptide sequence editing")
        toolsMenu.AppendSeparator()

        toolsMenu.Append(ID_toolsMCut, "Protein Digest" +hotkeys[ID_toolsMCut], " Generate list of digestion peptides")
        toolsMenu.Append(ID_toolsMFrag, "Peptide Fragmentation" +hotkeys[ID_toolsMFrag], " Generate list of peptide fragments")
        toolsMenu.Append(ID_toolsMDiff, "Check Differences" +hotkeys[ID_toolsMDiff], " Check differences for all peaks")
        toolsMenu.Append(ID_toolsMComp, "Compare Peaklists" +hotkeys[ID_toolsMComp], " Compare loaded peaklists with the main peaklist")
        toolsMenu.AppendSeparator()

        toolsMenu.Append(ID_toolsMMascotPMF, "Mascot PMF Search..." +hotkeys[ID_toolsMMascotPMF], " Send peaklist data to Mascot Peptide Mass Fingerprint")
        toolsMenu.Append(ID_toolsMMascotSeq, "Mascot Sequence Query..." +hotkeys[ID_toolsMMascotSeq], " Send peaklist data to Mascot Sequence Query")
        toolsMenu.Append(ID_toolsMMascotMSMS, "Mascot MS/MS Ion Search..." +hotkeys[ID_toolsMMascotMSMS], " Send peaklist data to Mascot MS/MS Ion Search")
        toolsMenu.AppendSeparator()

        toolsMenu.Append(ID_toolsMConv, "Sequence Converter..." +hotkeys[ID_toolsMConv], " Convert protein and nucleic acid sequence")

        # links
        linksMenu = wx.Menu()
        linksMSToolsSubMenu = wx.Menu()
        linksMSToolsSubMenu.Append(ID_linksMatrixScience, "Matrix Science" +hotkeys[ID_linksMatrixScience], " Open web page of Matrix Science (MASCOT)")
        linksMSToolsSubMenu.Append(ID_linksProspector, "Protein Prospector" +hotkeys[ID_linksProspector], " Open web page of Protein Prospector")
        linksMSToolsSubMenu.Append(ID_linksSearchXLinks, "SearchXLinks" +hotkeys[ID_linksSearchXLinks], " Open web page of SearchXLinks  - search for cross-links in protein digest")
        linksMSToolsSubMenu.Append(ID_linksExpasy, "ExPASy" +hotkeys[ID_linksExpasy], " Open web page of ExPASy - Proteomics Server")
        linksMenu.AppendMenu(ID_linksMSTools, "MS Tools", linksMSToolsSubMenu)

        linksModifSubMenu = wx.Menu()
        linksModifSubMenu.Append(ID_linksUniMod, "UniMod" +hotkeys[ID_linksUniMod], " Open web page of UniMod - Protein Modifications for Mass Spectrometry")
        linksModifSubMenu.Append(ID_linksDeltaMass, "Delta Mass" +hotkeys[ID_linksDeltaMass], " Open web page of Delta Mass - A Database of Protein Post Translational Modifications")
        linksMenu.AppendMenu(ID_linksModifs, "Modifications", linksModifSubMenu)

        linksSeqDBSubMenu = wx.Menu()
        linksSeqDBSubMenu.Append(ID_linksUniProt, "UniProt" +hotkeys[ID_linksUniProt], " Open web page of UniProt - Universal Protein Resource")
        linksSeqDBSubMenu.Append(ID_linksExpasy, "ExPASy" +hotkeys[ID_linksExpasy], " Open web page of ExPASy - Proteomics Server")
        linksSeqDBSubMenu.Append(ID_linksEMBLEBI, "EMBL EBI" +hotkeys[ID_linksEMBLEBI], " Open web page of EMBL EBI - European Bioinformatics Institute")
        linksSeqDBSubMenu.Append(ID_linksPIR, "PIR" +hotkeys[ID_linksPIR], " Open web page of PIR - Protein Information Resource")
        linksSeqDBSubMenu.Append(ID_linksNCBI, "NCBI" +hotkeys[ID_linksNCBI], " Open web page of NCBI - National Center for Biotechnology Information")
        linksMenu.AppendMenu(ID_linksSeqDB, "Sequence Databases", linksSeqDBSubMenu)

        linksSeqToolsSubMenu = wx.Menu()
        linksSeqToolsSubMenu.Append(ID_linksBLAST, "BLAST" +hotkeys[ID_linksBLAST], " Open web page of BLAST - Basic Local Alignment Search Tool")
        linksSeqToolsSubMenu.Append(ID_linksClustalW, "ClustalW" +hotkeys[ID_linksClustalW], " Open web page of ClustalW - Multiple Sequence Alignment")
        linksSeqToolsSubMenu.Append(ID_linksFASTA, "FASTA" +hotkeys[ID_linksFASTA], " Open web page of FASTA - Sequence Similarity Searching")
        linksSeqToolsSubMenu.Append(ID_linksMUSCLE, "MUSCLE" +hotkeys[ID_linksMUSCLE], " Open web page of MUSCLE - Multiple Sequence Comparison by Log-Expectation")
        linksMenu.AppendMenu(ID_linksStruct, "Sequence Tools", linksSeqToolsSubMenu)

        linksStructSubMenu = wx.Menu()
        linksStructSubMenu.Append(ID_linksPDB, "RCSB PDB" +hotkeys[ID_linksPDB], " Open web page of RCSB Protein Data Bank")
        linksMenu.AppendMenu(ID_linksStruct, "Protein Structures", linksStructSubMenu)

        # config menu
        configMenu = wx.Menu()
        configMenu.Append(ID_configMonoisotopic, "Monoisotopic Masses" +hotkeys[ID_configMonoisotopic], " Use monoisotopic masses", wx.ITEM_RADIO)
        configMenu.Append(ID_configAverage, "Average Masses" +hotkeys[ID_configAverage], " Use average masses", wx.ITEM_RADIO)
        configMenu.AppendSeparator()

        configMenu.Append(ID_configTolerance, "Tolerance..." +hotkeys[ID_configTolerance],  " Set tolerance value for data matching")
        configMenu.AppendSeparator()

        configMenu.Append(ID_configShowPeaklist, "Show Peaklist" +hotkeys[ID_configShowPeaklist], " Split window to peaklist and tool frame", wx.ITEM_CHECK)
        configMenu.Append(ID_configPeaklistBottom, "Peaklist Bottom" +hotkeys[ID_configPeaklistBottom], " Split document window horizontally", wx.ITEM_CHECK)
        configMenu.AppendSeparator()

        configMenu.Append(ID_configModifications, "Modifications..." +hotkeys[ID_configModifications], " Edit available modifications")
        configMenu.AppendSeparator()

        configMenu.Append(ID_configPreferences, "Preferences..." +hotkeys[ID_configPreferences], " Set application defaults")

        # help menu
        helpMenu = wx.Menu()
        helpMenu.Append(ID_helpUpdate, "Check For Updates..." +hotkeys[ID_helpUpdate], " Check for newer version of mMass")
        helpMenu.Append(ID_helpHomepage, "mMass Homepage" +hotkeys[ID_helpHomepage], " Open mMass homepage")
        helpMenu.Append(ID_helpAbout, "About" +hotkeys[ID_helpAbout], " About mMass")

        # set menubar
        self.Append(fileMenu, "File")
        self.Append(peaklistMenu, "Peaklist")
        self.Append(spectrumMenu, "Spectrum")
        self.Append(processingMenu, "Processing")
        self.Append(matchingMenu, "Matching")
        self.Append(sequenceMenu, "Sequence")
        self.Append(toolsMenu, "Tools")
        self.Append(linksMenu, "Links")
        self.Append(configMenu, "Config")
        self.Append(helpMenu, "&Help")
    # ----
