# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Common functions.


# ----
def countTolerance(value, error, errorType):
    """ Count tolerance from masses and error. """

    if errorType == 'Da':
        return error
    elif errorType == '%':
        return (value/100)*error
    elif errorType == 'ppm':
        return (value/1000000)*error
# ----


# ----
def calcMassError(measured, counted, errorType):
    """ Count error from measured and counted mass. """

    if counted == 0: return 0
    if errorType == 'Da':
        return (measured - counted)
    elif errorType == '%':
        return round((measured - counted)/counted*100, 3)
    elif errorType == 'ppm':
        return int((measured - counted)/counted*1000000)
# ----


# ----
def sortMultiList(data, sortBy, desc=False):
    """ Sort multi-row list by selected column. """

    # check data
    if not data:
        return data

    # get data to sort
    buff = []
    for row in range(len(data)):
        buff.append((data[row][sortBy], data[row]))

    # sort data
    buff.sort()
    if desc:
        buff.reverse()

    # paste sorted data
    sortedData = []
    for row in range(len(buff)):
        sortedData.append(buff[row][1])

    return sortedData
# ----
