# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Dialog to name/rename loaded peaklist.

# load libs
import wx


class dlgRenamePeaklist(wx.Dialog):
    """ Dialog to name/rename loaded peaklist. """

    # ----
    def __init__(self, parent, name):
        wx.Dialog.__init__(self, parent, -1, "Peaklist Title", style=wx.DEFAULT_DIALOG_STYLE)

        self.name = name

        # make items
        params = self.makeParamsBox()
        buttons = self.makeButtonBox()

        # pack main frame
        mainBox = wx.BoxSizer(wx.VERTICAL)
        if wx.Platform == '__WXMAC__':
            mainBox.Add(params, 0, wx.EXPAND|wx.TOP|wx.LEFT|wx.RIGHT, 20)
            mainBox.Add(buttons, 0, wx.ALIGN_CENTER|wx.ALL, 10)
        else:
            mainBox.Add(params, 0, wx.EXPAND|wx.TOP|wx.LEFT|wx.RIGHT, 3)
            mainBox.Add(buttons, 0, wx.ALIGN_CENTER|wx.ALL, 5)

        # fit layout
        mainBox.Fit(self)
        self.SetSizer(mainBox)
        self.Centre()
    # ----


    # ----
    def makeParamsBox(self):
        """ Make box with buttons. """

        # make items
        peaklistName_label = wx.StaticText(self, -1, "Peaklist title:")
        self.peaklistName_value = wx.TextCtrl(self, -1, self.name, size=(150, -1))

        # pack items
        mainBox = wx.BoxSizer(wx.HORIZONTAL)
        mainBox.Add(peaklistName_label, 0, wx.RIGHT, 5)
        mainBox.Add(self.peaklistName_value, 0, wx.LEFT, 5)

        return mainBox
    # ----


    # ----
    def makeButtonBox(self):
        """ Make box with buttons. """

        # make items
        OK_button = wx.Button(self, wx.ID_OK, "OK")
        Cancel_button = wx.Button(self, wx.ID_CANCEL, "Cancel")

        # pack items
        mainBox = wx.BoxSizer(wx.HORIZONTAL)
        mainBox.Add(OK_button, 0, wx.ALL, 5)
        mainBox.Add(Cancel_button, 0, wx.ALL, 5)

        # set events
        wx.EVT_BUTTON(self, wx.ID_OK, self.onDlgOK)

        # set defaults
        OK_button.SetDefault()

        return mainBox
    # ----


    # ----
    def onDlgOK(self, evt):
        """ Get name when OK pressed. """

        # get name
        self.name = self.peaklistName_value.GetValue()
        if self.name != '':
            self.EndModal(wx.ID_OK)
    # ----
