/*
 *    Copyright (C) 1999-2002 Stijn van Dongen.
*/

#include "env.h"
#include "util.h"
#include "segment.h"

#include "util/txt.h"
#include "util/hash.h"


/* Note: the whole scopeStack thing is now disabled,
 * (in order to enable \${html}{\begin{vbt}}
 * so maybe it should be thrown away.
*/


static   mcxHash*    envTable_g        =  NULL;    /* environment keys  */

typedef struct
{
   mcxTing            *key
;  yamSeg            *seg
;
}  yamScope          ;

#define     SCOPE_STACK_SIZE  32
static      yamScope    scopeStack[SCOPE_STACK_SIZE];
static      int         scopeCount_g     =  0;


void yamEnvNew
(  const char* tag
,  const char* openstr
,  const char* closestr
)
   {
      mcxTing*  opentag     =  mcxTingNew(tag)
   ;  mcxTing*  closetag    =  mcxTingNew(tag)
   ;  mcxKV*   kv

   ;  mcxTingAppend(closetag, "!_")

  /*
   *  scopeStack contains mcxTing key member, which is also stored
   *  in the envTable_g. First thought I could not redefine it,
   *  right now I think it is possible, because overwriting key
   *  does not change the key pointer.
  */
   ;  if (scopeCount_g)
      {  yamExit
         ("\\env#3"
         ,  "(re)define not allowed within environment\n"
            "  now within environment <%s>"
         ,  scopeStack[scopeCount_g-1].key->str
         )
   ;  }

   ;  kv =  mcxHashSearch(opentag, envTable_g, MCX_DATUM_INSERT)
   ;  if (kv->key != opentag)
      {  fprintf(stderr, "[\\env#3] overwriting key <%s>\n",opentag->str)
      ;  mcxTingFree(&opentag)
   ;  }
   ;  if (kv->val)
      mcxTingWrite((mcxTing*) (kv->val), openstr)
   ;  else
      kv->val = mcxTingNew(openstr)

   ;  kv =  mcxHashSearch(closetag, envTable_g, MCX_DATUM_INSERT)
   ;  if (kv->key != closetag)
      mcxTingFree(&closetag)
   ;  if (kv->val)
      mcxTingWrite((mcxTing*) (kv->val), closestr)
   ;  else
      kv->val = mcxTingNew(closestr)
;  }


const char* yamEnvOpenScope
(  mcxTing* key
,  yamSeg*  seg
)
   {  mcxKV* kv = mcxHashSearch(key, envTable_g, MCX_DATUM_FIND)

   ;  if (kv)
      {  if (scopeCount_g < SCOPE_STACK_SIZE)
         {  scopeStack[scopeCount_g].seg = seg
         ;  scopeStack[scopeCount_g].key = (mcxTing*) kv->key
      ;  }
      ;  scopeCount_g++
      ;  return ((mcxTing*) kv->val)->str
   ;  }

      yamExit("\\begin#2", "env <%s> not found\n", key->str)
   ;  return NULL
;  }


const char* yamEnvCloseScope
(  const char* str
,  yamSeg*  seg
)
   {
      mcxTing* key = mcxTingNew(str)
   ;  mcxKV* kv

   ;  mcxTingAppend(key, "!_")

   ;  scopeCount_g--
   ;  if
      (  scopeCount_g < SCOPE_STACK_SIZE
      && (  strcmp(str, scopeStack[scopeCount_g].key->str)
      )  )
         /* || seg != scopeStack[scopeCount_g].seg
          * disabled this condition in order to allow \${html}{\begin{vbt}}
         */
      yamExit("\\end#2", "some inner scope was not closed")

   ;  kv = mcxHashSearch(key, envTable_g, MCX_DATUM_FIND)
   ;  return kv ? ((mcxTing*) kv->val)->str : NULL
;  }


void yamEnvInitialize
(  int n
)
   {  envTable_g           =  mcxHashNew(n, mcxTingHash, mcxTingCmp)
;  }

