# Author: Prabhu Ramachandran <prabhu_r at users dot sf dot net>
# Copyright (c) 2006, Enthought, Inc.
# License: BSD Style.

# Enthought library imports.
from enthought.traits.api import Instance
from enthought.tvtk.api import tvtk

# Local imports
from enthought.mayavi.filters.filter_base import FilterBase


######################################################################
# `Delaunay3D` class.
######################################################################
class Delaunay3D(FilterBase):

    """Performs a 3D Delaunay triangulation using the tvtk.Delaunay3D
    class.    
    """
    
    # The version of this class.  Used for persistence.
    __version__ = 0

    # The actual TVTK filter that this class manages.
    filter = Instance(tvtk.Delaunay3D, args=(), allow_none=False)


