""" An example using perspectives. """


# Enthought library imports.
from enthought.envisage.api import PluginDefinition

# Plugin definition imports.
from enthought.envisage.workbench.workbench_plugin_definition import \
     Perspective, View, Workbench


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = "enthought.envisage.examples.plugin.perspective"


###############################################################################
# Extensions.
###############################################################################

workbench = Workbench(
    views = [
        View(
            class_name = ID + ".view.black_view.BlackView",
            name       = "Black",
            position   = "bottom"
        ),
        
        View(
            class_name = ID + ".view.blue_view.BlueView",
            name       = "Blue",
            position   = "left"
        ),
        
        View(
            class_name = ID + ".view.green_view.GreenView",
            name       = "Green",
            position   = "left"
        ),

        View(
            class_name = ID + ".view.red_view.RedView",
            name       = "Red",
            position   = "left"
        ),
        
        View(
            class_name = ID + ".view.yellow_view.YellowView",
            name       = "Yellow",
            position   = "bottom"
        ),
        
        View(
            class_name = ID + ".view.a_traits_ui_view.ATraitsUIView",
            name       = "Bling",
            position   = "bottom"
        ),

        View(
            id         = ID + ".view.blang.blang",
            uol        = "import://%s.view.blang.blang" % ID,
            name       = "Blang",
            position   = "left"
        )
    ],
    
    perspectives = [
        Perspective(
            id = ID + ".perspective.foo_perspective.FooPerspective",
            name = "Foo",

            contents = [
                Perspective.Item(
                    id = ID + ".view.blue_view.BlueView",
                    position = "left"
                ),

                Perspective.Item(
                    id = ID + ".view.red_view.RedView",
                    position  = "with",
                    relative_to = ID + ".view.blue_view.BlueView"
                ),

                Perspective.Item(
                    id = ID + ".view.green_view.GreenView",
                    position = "top"
                ),

                Perspective.Item(
                    id = ID + ".view.blang.blang",
                    position  = "left"
                ),

                Perspective.Item(
                    id = ID + ".view.a_traits_ui_view.ATraitsUIView",
                    position  = "with",
                    relative_to = ID + ".view.green_view.GreenView"
                ),

                Perspective.Item(
                    id = "enthought.plugins.python_shell.view.PythonShellView",
                    position = "bottom"
                ),

                Perspective.Item(
                    id = ID + ".view.yellow_view.YellowView",
                    position = "right",
                    width  = 0.1,
                    height = 0.1
               )
            ]
        ),
        
        Perspective(
            id = ID + ".perspective.bar_perspective.BarPerspective",
            name = "Bar",

            contents = [
                Perspective.Item(
                    id = ID + ".view.green_view.GreenView",
                    position = "left"
                ),
                
                Perspective.Item(
                    id = ID + ".view.black_view.BlackView",
                    position = "bottom",
                    relative_to = ID + ".view.green_view.GreenView"
                ),

                Perspective.Item(
                    id = ID + ".view.yellow_view.YellowView",
                    position = "top"
                ),

                Perspective.Item(
                    id = "enthought.plugins.python_shell.view.PythonShellView",
                    position = "bottom"
                )
            ]
        ),

        Perspective(
            id = ID + ".perspective.bif_perspective.BifPerspective",
            name = "Bif",
            show_editor_area = False,

            contents = [
                Perspective.Item(
                    id = ID + ".view.green_view.GreenView"
                ),
                
                Perspective.Item(
                    id = ID + ".view.black_view.BlackView",
                    position = "bottom",
                    relative_to = ID + ".view.green_view.GreenView"
                )
            ]
        ),

        Perspective(
            id = ID + ".perspective.baz_perspective.BazPerspective",
            class_name = ID + ".perspective.baz_perspective.BazPerspective",
            name = "Bazzle",

            contents = [
                Perspective.Item(
                    id = ID + ".view.blue_view.BlueView",
                    position = "left"
                ),

                Perspective.Item(
                    id = ID + ".view.red_view.RedView",
                    position    = "bottom",
                    relative_to = ID + ".view.blue_view.BlueView"
                ),

                Perspective.Item(
                    id = ID + ".view.green_view.GreenView",
                    position = "top"
                ),

                Perspective.Item(
                    id = "enthought.plugins.python_shell.view.PythonShellView",
                    position = "bottom"
                ),

                Perspective.Item(
                    id = ID + ".view.yellow_view.YellowView",
                    position = "right"
               )
            ]
        )
    ],

    default_perspective = ID + ".perspective.bar_perspective.BarPerspective"
)

###############################################################################
# The plugin definition!
###############################################################################

class PerspectiveExample(PluginDefinition):
    """ The perspective example. """
    
    # The plugin's globally unique identifier.
    id = ID

    # General information about the plugin.
    name          = "Perspective Example Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"

    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.workbench"]

    # The extension points offered by this plugin,
    extension_points = []
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [workbench]

#### EOF ######################################################################
