""" The toolbox view for editors which provide tools. """

import wx


from enthought.pyface.action.api import ToolPaletteManager
from enthought.traits.api import Instance

from editor import Editor
from view import View




class Toolbox(View):

    name = 'Toolbox'

    position = 'left bottom'

    tool_palette_manager = Instance(ToolPaletteManager)
    
    def _create_contents(self, parent):
        """ Create the contents of the window. """

        return self.tool_palette_manager.create_tool_palette(parent).control
        
#### EOF ######################################################################
        
        
