#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2007 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Dave Peterson <dpeterson@enthought.com>
#
#-----------------------------------------------------------------------------

"""
A monitor for tree nodes recognized as project resources.

"""

# Standard library imports.
import logging

# Enthought library imports
from enthought.pyface.tree.api import NodeMonitor


# Setup a logger for this module.
logger = logging.getLogger(__name__)


class ProjectNodeMonitor(NodeMonitor):
    """
    A monitor for tree nodes recognized as project resources.

    """

    ##########################################################################
    # 'NodeMonitor' interface.
    ##########################################################################

    #### protected methods ###################################################

    def _setup_trait_change_handlers(self, project, remove=False):
        """
        Add or remove trait change handlers to/from a Project.

        """

        logger.debug('%s trait listeners for Project [%s] '
            'in ProjectNodeMonitor [%s]',
            (remove and 'Removing' or 'Adding'), project, self)

        # Update the node if the name changes.
        project.on_trait_change(self._on_name_changed, 'name',
            remove=remove)

        return


    ##########################################################################
    # 'UnifiedProjectNodeMonitor' interface
    ##########################################################################

    #### Event handlers ######################################################

    def _on_name_changed(self, obj, name, old, new):
        """
        Handle the UnifiedProject's name changing.

        """

        logger.debug('Name changed in ProjectNodeMonitor [%s]', self)

        # Update the name in our node's binding.
        self.node.name = new

        # Tell the tree to update its representation of this node.
        self.fire_nodes_changed()

        return


#### EOF #####################################################################

