import sys
import glob
import os.path
import subprocess

inkscape_exe = "inkscape"
if sys.platform == "win32":
    inkscape_exe = "c:\\program files\\inkscape\\inkscape.exe"

path = os.getcwd()

for svg in glob.glob("*.svg"):
    png = svg[:-3] + "png"

    
    width, height = 16, 16
    args = ['-z', '-e', os.path.join(path, png), 
            '-w', str(width), '-h', str(height), 
            os.path.join(path, svg)]
    subprocess.call([inkscape_exe] + args)

    width, height = 16, 16
    args = ['-z', '-e', os.path.join(path, "16x16", png),
        '-w', str(width), '-h', str(height),
            os.path.join(path, svg)]
    subprocess.call([inkscape_exe] + args)

    width, height = 22, 22
    args = ['-z', '-e', os.path.join(path, "22x22", png),
            '-w', str(width), '-h', str(height),
            os.path.join(path, svg)]
    subprocess.call([inkscape_exe] + args)
