#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#-----------------------------------------------------------------------------

""" Preference page for default path for a project
"""

# Enthought library imports
from enthought.envisage import get_application
from enthought.envisage.workbench.preference import WorkbenchPreferencePage
from enthought.traits.api import Directory, Int
from enthought.traits.ui.api import View, Item


#-------------------------------------------------------------------------------
#   DefaultPathPreferencePage Class
#-------------------------------------------------------------------------------

class DefaultPathPreferencePage(WorkbenchPreferencePage):
    """ Preference page for default path for a plugin.
    """

    # Choose the unit system that needs to be used for the project
    preferred_path = Directory('')


    # Auto-save interval (i.e., how often should automatic saving of the
    # project happen).
    autosave_interval = Int(5) # minutes

    
    # Set the traits view
    traits_view = View(Item('preferred_path',
                    tooltip='Path that will be used for storing projects'),
                       Item('autosave_interval',
                            label='Project auto-save frequency (minutes)',
                            tooltip='How often the project is auto-saved by '
                            'the app')
                       )

    # Setting project plugin id
    _project_plugin_id = 'enthought.envisage.single_project'
    
    #---------------------------------------------------------------------------
    #   Workbench interface
    #---------------------------------------------------------------------------

    ### protected methods ------------------------------------------------------
    def _get_preferences(self):
        """ Returns the preferences that this page is editing.
        """

        return get_application().get_preferences(self._project_plugin_id)


### EOF ------------------------------------------------------------------------
