""" The node type for workspace resources. """


# Enthought library imports.
from enthought.envisage.resource import FolderNodeType
from enthought.naming.api import Binding
from enthought.pyface.api import ImageResource

# Local imports.
from project import Project
from workspace_project import WorkspaceProject

class WorkspaceNodeType(FolderNodeType):
    """ The node type for workspace resources. """

    #### 'NodeType' interface #################################################

    # The image used to represent nodes of this type that are NOT expanded.
    closed_image = ImageResource('workspace')

    # The image used to represent nodes of this type that ARE expanded.
    open_image = closed_image

    ###########################################################################
    # 'NodeType' interface.
    ###########################################################################

    def can_copy(self, node):
        """ Can a node be copied? """

        return False

    def can_cut(self, node):
        """ Can a node be cut? """

        return False

    def can_delete(self, node):
        """ Can a node be deleted? """

        return True
    
    def can_paste(self, node, data):
        """ Can data be pasted onto a node? """

        return isinstance(data, Binding) and isinstance(data.obj, WorkspaceProject)
    
#### EOF ######################################################################
