""" Pastes resources. """


# Standard library imports.
import logging, sys

# Enthought library imports.
from enthought.envisage.ui import SelectionListenerAction
from enthought.naming.api import Context
from enthought.pyface.api import error
from enthought.traits.api import Instance


# Setup a logger for this module.
logger=logging.getLogger(__name__)


# Error messages.
DST_SAME_AS_SRC = "The destination folder is the same as the source folder"
DST_SUB_OF_SRC  = "The destination folder is a sub-folder of the source folder"


class PasteAction(SelectionListenerAction):
    """ Pastes resources. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """

        # fixme: In terms of the whole UI model thang... This method would be a
        # method on the project UI service, and '_paste_nodes' would be a
        # method on the project service?!?  The scripting layer can then expose
        # both methods...
        selection = self.window.selection

        try:
            self._paste_nodes(selection[0])

        except Exception, msg:
            logger.exception(msg)
            type, value, traceback = sys.exc_info()
            error(self.window.control, "Paste failed\n%s" % str(value))

        return

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action. """

        if self.window is not None and len(self.window.selection) > 0:
            # The node that we are pasting into.
            node = self.window.selection[0]

            # Get the resource type of the node that we are pasting into.
            resource_type = self.resource_manager.get_type_of(node.obj)

            # fixme: Clipboard!
            application = self.window.plugin.application

            # If the clipboard is empty then there is nothing to paste!
            if not hasattr(application, 'clipboard'):
                self.enabled = False

            else:
                for data in application.clipboard:
                    if not resource_type.node_type.can_paste(node, data):
                        self.enabled = False
                        break

                else:
                    self.enabled = True

        else:
            self.enabled = False

        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _paste_nodes(self, node):
        """ Pastes a list of nodes. """

        node_resource_type = self.resource_manager.get_type_of(node.obj)

        for data in self.window.plugin.application.clipboard:
            # Get the resource type of the object being pasted.
            data_resource_type = self.resource_manager.get_type_of(data.obj)

            # Ask the node type for the actual value to paste.
            value = data_resource_type.node_type.get_paste_value(data)

            node_resource_type.node_type.paste(node, data)

        return


#### EOF ######################################################################
