/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "net_internal.h"
#include "mas/mas_dpi.h"
#include "auth_host.h"

int32
auth_host_add_host( struct host_list *hl, char *hn )
{
    void *ptr;

    hl->members++;
    
    if ( hl->members > hl->allocated )
    {
        if ( hl->allocated > 0 )
        {
            hl->allocated *= 2;
        }
        else
        {
            hl->allocated = 1;
        }
        
        ptr = masc_rtrealloc( hl->hosts, hl->allocated );
        if ( ptr != 0 )
        {
            hl->hosts = ptr;
        }
        else
        {
            return MAS_MEMLMT_RCHD;
        }
    }

    hl->hosts[hl->members - 1] = hn;
    
    return 0;
}

int32
auth_host_remove_host( struct host_list *hl, char *hn )
{
    int i, j = 0;

    for (i=0; i<hl->members; i++)
    {
        if ( strcmp( hl->hosts[i], hn ) == 0 )
        {
            masc_rtfree( hl->hosts[i] );
            for (j=i; j<hl->members; j++)
            {
                hl->hosts[i] = hl->hosts[j];
                i++;
            }
        }
    }

    hl->members--;

    if ( j == 0 )
        return MAS_NETHN_NFND;

    return 0;
}

int32
auth_host_allow_all( struct host_list *hl )
{
    char *tempstr;
    
    auth_host_deny_all( hl );

    tempstr = masc_rtalloc( strlen( AUTH_HOST_ALL ) + 1 );
    masc_strlcpy( tempstr, AUTH_HOST_ALL, strlen( AUTH_HOST_ALL ) + 1 );

    auth_host_add_host( hl, tempstr );

    return 0;
}

int32
auth_host_deny_all( struct host_list *hl )
{
    int i;
    
    for (i=0; i<hl->members; i++)
    {
        masc_rtfree( hl->hosts[i] );
        hl->hosts[i] = 0;
    }

    hl->members = 0;

    return 0;
}

int32
auth_host_authenticate( struct host_list *hl, char *hn )
{
    int i;

    
    if ( hl->members > 0 && strcmp (hl->hosts[0], AUTH_HOST_ALL ) == 0 )
        return MAS_SUCCESS;
            
    for (i=0; i<hl->members; i++)
    {
        if ( strcmp( hl->hosts[i], hn ) == 0 )
            return MAS_SUCCESS;
    }

    return MAS_NETHN_NPMIT;
}

int32
auth_host_authenticate_addr4( struct host_list *hl, int addr )
{
    if ( strcmp (hl->hosts[0], AUTH_HOST_ALL ) == 0 )
        return MAS_SUCCESS;

    /* otherwise, not supported yet */
    return MAS_NETADR_NPMIT;
}

int32
auth_host_parse( struct host_list *hl, char *hn )
{
    int32 retval = 0;
    
    if ( strlen(hn) == 1 )
    {
        if ( hn[0] == '-' )
        {
            auth_host_deny_all( hl );
            goto success;
            
        }
        else if ( hn[0] == '+' )
        {
            auth_host_allow_all( hl );
            goto success;
        }
        else
        {
            retval = MAS_OPARG_IVLD;
            goto failure;
        }
        
    }

    retval = MAS_OPARG_IVLD;
    
 failure:
 success:
    return retval;
}

