import gtk
import MetaData


class View:

    xpadding = 3
    ypadding = 3

    def __init__(self, table_widget, ok_hook):
    	self.metadatas = []
	self.keys = None
	self.labels = []
	self.entry2key = {}
	self.backups = []
	self.widget = table_widget
	self.ok_hook = ok_hook
	self.controller = Controller(self)
	
    def clear(self):
	for metadata in self.metadatas:
	    metadata.dont_listen(self.controller.someone_else_changed)
    	for entry in self.entry2key.keys():
	    self.widget.remove(entry)
    	for label in self.labels:
	    self.widget.remove(label)
    	self.entry2key = {}
	self.labels = []

    def setup(self, attrlist, metadatas):
    	self.clear()
    	self.metadatas = metadatas
	if not attrlist:
	    attrlist = MetaData.AttributeList()
	if self.metadatas:
	    self.backups = []
	    for metadata in self.metadatas:
		metadata.listen(self.controller.someone_else_changed)
		self.backups.append(metadata.copy())
	    keys = attrlist.get_all()
	    self.entry2key = {}
	    self.key2label = {}
	    self.widget.resize(len(keys), 2)
	    for i in range(len(keys)):
		key = keys[i]
		label = gtk.Label()
		vname = attrlist.get_visible_name(key)
		label.set_markup("<b>%s:</b>" % MetaData.protect(vname))
		label.set_alignment(1.0, 0.5)
		label.show()
		self.widget.attach(label, 0, 1, i, i+1, gtk.FILL, 0, 
				   self.xpadding, self.ypadding)
    	    	self.labels.append(label)
		
    	    	value = self.metadatas[0][key]
    	    	for metadata in self.metadatas[1:]:
		    if metadata[key] != value:
		    	value = ""
			break
    
		if attrlist.is_editable(key):
		    entry = gtk.Entry()
		    entry.set_text(value)
		    entry.show()
		    self.widget.attach(entry, 1, 2, i, i+1, 
				       gtk.SHRINK | gtk.EXPAND | gtk.FILL, 0, 
				       self.xpadding, self.ypadding)
		    entry.connect("activate", self.controller.activate)
		    entry.connect("changed", self.controller.changed)
		    self.entry2key[entry] = key
		else:
		    label2 = gtk.Label(value)
		    label2.set_alignment(0.0, 0.5)
		    label2.set_line_wrap(gtk.TRUE)
		    label2.show()
		    self.widget.attach(label2, 1, 2, i, i+1, 
				       gtk.SHRINK | gtk.EXPAND | gtk.FILL, 0, 
				       self.xpadding, self.ypadding)
    	    	    self.labels.append(label2)
		    self.key2label[key] = label2

class Controller:

    def __init__(self, view):
    	self.view = view

    def activate(self, *args):
    	if self.view.ok_hook:
	    self.view.ok_hook()
	
    def changed(self, *args):
    	entry = args[0]
	key = self.view.entry2key[entry]
	text = entry.get_text()
	if type(text) == type(""):
	    text = unicode(text)
    	for metadata in self.view.metadatas:
	    metadata.dont_listen(self.someone_else_changed)
	    metadata[key] = text
	    metadata.listen(self.someone_else_changed)

    def restore(self):
    	if self.view.metadatas and self.view.backups:
	    for i in range(len(self.metadatas)):
	    	self.metadatas[i].restore(self.view.backups[i])

    def someone_else_changed(self, photo, key):
    	if self.view.key2label.has_key(key):
	    self.view.key2label[key].set_text(photo[key])
    	else:
	    list = filter(lambda e: self.view.entry2key[e] == key, 
			  self.view.entry2key.keys())
	    if list:
		entry = list[0]
		entry.set_text(photo[key])
