import os
from linda.funcs import run_external_cmd

class ArchParser:
    def __init__(self):
        self.arches = []
        tmp_arches = filter(lambda x: x.startswith('Known Debian Arch'), \
            run_external_cmd('dpkg-architecture --help 2>&1', 1).split('\n'))
        if tmp_arches:
            self.arches = tmp_arches[0].split(' are ')[1].split(', ')
        else:
            self.arches = run_external_cmd('dpkg-architecture -L').split('\n')
        self.arches.append('all') 
        
    def check(self, arch):
        if arch in self.arches:
            return 1
        return 0
