/***********************************************************************************

	Copyright (C) 2007-2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include <gtkmm/main.h>

#include "lifeograph.hpp"


int
main( int argc, char *argv[] )
{
	// LIBGETTEXT REQUIREMENTS
	setlocale( LC_ALL, "" );
	bindtextdomain( PACKAGE, LOCALEDIR );
	textdomain( PACKAGE );

	Gnome::Conf::init();
	Gtk::Main kit( argc, argv );

	Glib::set_application_name( LIFEO::PROGRAM_NAME );

	{
		std::string path_icon( PIXMAPDIR "/lifeograph.png" );
		bool icon_found( true );
		if( !Glib::file_test( path_icon, Glib::FILE_TEST_EXISTS ) )
		{
			path_icon = argv[ 0 ];
			path_icon += ".png";
			if( !Glib::file_test( path_icon, Glib::FILE_TEST_EXISTS ) )
				icon_found = false;
		}
		if( icon_found )
			Gtk::Window::set_default_icon_from_file( path_icon );
	}

	LIFEO::Lifeograph *lifeograph = new LIFEO::Lifeograph( argc, argv );

	lifeograph->run();

	delete lifeograph;

	return 0;
}
