/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <SDL/SDL.h>
#include "ttf.h"

/* #define NO_MOUSE_CURSOR */

u_long id = 1327695029;
u_long options = BE_NONE;


static SDL_Surface *surface;
static Plugin_t *glcube = NULL;


static void
SDL_get_event(Context_t *ctx)
{
  // TODO middle = change color, right = erase (3x3)
  SDL_Event evt;

  while (SDL_PollEvent(&evt)) {
    BKey_t key;

    switch (evt.type) {
    case SDL_KEYDOWN:
      if (NULL != ctx->events_cb) {
	key.val = evt.key.keysym.sym;
	key.mod = evt.key.keysym.mod;
	
	ctx->events_cb(ctx, &key);
      }
      break;
	
    case SDL_QUIT:
      Context_send_event(ctx, BT_CONTEXT, BC_QUIT, BA_NONE);
      break;
			
    case SDL_MOUSEMOTION:
      // printf("motion.state: %d\n", evt.motion.state);
      //printf("left: %d\n", SDL_BUTTON_LEFT);
      //printf("right: %d\n", SDL_BUTTON_RIGHT);

      switch (evt.motion.state) {
	/* TODO un switch pour le mouse drag/drop mode */
      case SDL_BUTTON_LEFT:
#ifdef WITH_GL
	ctx->params3d.gl_xe = evt.motion.x;
	ctx->params3d.gl_ye = evt.motion.y;
	Params3d_rotate_GL(&ctx->params3d);
#else
	ctx->params3d.xe = evt.motion.x;
	ctx->params3d.ye = evt.motion.y;
	Params3d_rotate(&ctx->params3d);
#endif
	// printf("left button motion @ %d %d\n",  evt.motion.x, evt.motion.y);
	break;

      case SDL_BUTTON_RIGHT+SDL_BUTTON_LEFT: /* <- WTF ? */
	// printf("right button motion @ %d %d\n",  evt.motion.x, evt.motion.y);
	set_pixel_nc(active_buffer(ctx), evt.motion.x, MAXY-evt.motion.y, 255);
	break;

      default:
	break;
      }
      break;

    case SDL_MOUSEBUTTONDOWN:
      /* printf("type= %d, button= %d\n", evt.button.type, evt.button.button); */
      switch (evt.button.button) {
      case SDL_BUTTON_LEFT:
#ifdef WITH_GL /* TODO switch GL/not-GL */
	ctx->params3d.gl_xs = evt.motion.x;
	ctx->params3d.gl_ys = evt.motion.y;
#else
	ctx->params3d.xs = evt.motion.x;
	ctx->params3d.ys = evt.motion.y;
#endif
	break;

      case SDL_BUTTON_RIGHT:
	// printf("button down @ %d %d\n",  evt.motion.x, evt.motion.y);
	set_pixel_nc(active_buffer(ctx), evt.motion.x, MAXY-evt.motion.y, 255);
	break;
	
      case SDL_BUTTON_WHEELUP:
#ifdef WITH_GL /* TODO switch GL/not-GL */
	if (ctx->params3d.gl_fov > 1)
	  ctx->params3d.gl_fov--;
	//printf("FOV: %f\n", ctx->params3d.gl_fov);
#else
	ctx->params3d.scale_factor /= 0.9;
	/* printf("scale: %d\n", ctx->params3d->scale_factor); */
#endif
	break;

      case SDL_BUTTON_WHEELDOWN:
#ifdef WITH_GL /* TODO switch GL/not-GL */
	ctx->params3d.gl_fov++;
	//printf("FOV: %f\n", ctx->params3d.gl_fov);
#else
	if (ctx->params3d.scale_factor > 11)
	  ctx->params3d.scale_factor *= 0.9;
#endif
	break;

      default:
	break;
      }
      break;

#if 0
#ifndef FIXED
    case SDL_VIDEORESIZE:
      out_width = (evt.resize.w >= 8) ? evt.resize.w : out_width;
      out_height = (evt.resize.h >= 8) ? evt.resize.h : out_height;

      break;
#endif
#endif /* 0 */

    default:
      break;
    }
  }
}


/* "Le Superbe Rectangle Noir sur son Fond Blanc" */
void
test_gl()
{
  glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0);
  glBegin(GL_POLYGON);
  glColor3f(1,1,1);
  glVertex2f(0.1,0.1);
  glVertex2f(0.1,0.9);
  glVertex2f(0.9,0.9);
  glVertex2f(0.9,0.1);
  glEnd();
}


void
test_glbis()
{
  glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0);
  glBegin(GL_POLYGON);
  glColor3f(1,0,0.5);
  glVertex2f(0.1,0.25);
  glVertex2f(0.75,0.25);
  glVertex2f(0.75,0.75);
  glVertex2f(0.25,0.999);
  glEnd();
}


void
test_gl2()
{
  //  glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0);
  glBegin(GL_POLYGON);
  glColor3f(1,0,0);
  glVertex2f(0.0,0.0);
  glColor3f(0,1,0);
  glVertex2f(1.0, 0.0);
  glColor3f(0,0,1);
  glVertex2f(1,1);
  glColor3f(1,1,1);
  glVertex2f(0,1);
  glEnd();
}


static inline void
tex_point(const float x, const float y)
{
  glTexCoord2f(x, y);
  glVertex2f(x, y);
}


void
test_gl3(__attribute__ ((unused)) Context_t *ctx)
{
  Context_make_GL_RGBA_texture(ctx, ACTIVE_BUFFER);

  //  glBindTexture(GL_TEXTURE_2D, ctx->textures[ACTIVE_BUFFER]);

  glBegin(GL_TRIANGLE_STRIP);
  tex_point(0, 0);
  tex_point(1, 0);
  tex_point(1, 1);

  tex_point(0, 0);
  tex_point(0, 1);
  tex_point(1, 1);
  glEnd();

  //glDeleteTextures(1, &ctx->textures[ACTIVE_BUFFER]);
}


void
reshape(int w, int h)
{
   glViewport(0, 0, (GLsizei)w, (GLsizei)h);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}


void
run(Context_t *ctx)
{
  if (!ctx->gl_done) {
    if (ctx->force_cube && (NULL != glcube))
      glcube->run(ctx);
    else {
      reshape(WIDTH, HEIGHT);
      test_gl3(ctx);
    }
  }

  if (ctx->osd_mode != OSD_NONE) {
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    osd(ctx);
    /* TODO merge with SDL code
    if (ctx->random_mode != BR_NONE)
      osd_random_mode_elapsed(ctx);
    */
  }

  SDL_get_event(ctx);
  SDL_GL_SwapBuffers();
}


void
fullscreen(const int fs)
{
  int do_it = surface->flags & SDL_FULLSCREEN;

  /* houlala c'est loin l'algebre de bool en C... */
  do_it = (fs && !do_it) || (!fs && do_it);

  if (do_it) {
    printf("[S] Toggle full-screen\n");
    SDL_WM_ToggleFullScreen(surface);
  }
}


void
destroy(__attribute__ ((unused)) Context_t *ctx)
{
#ifndef FIXED
  /*
  sws_freeContext(sws_context);
  xfree(bufp);
  xfree(dstbufp);
  */
#endif
  SDL_FreeSurface(surface);
  ttf_quit();
  SDL_Quit();
}


void
switch_cursor()
{
  int on;

  on = SDL_ShowCursor(SDL_QUERY);
  SDL_ShowCursor(on ? SDL_DISABLE : SDL_ENABLE);
}


static void
resize_window(int width, int height)
{
  glViewport(0, 0, width, height);

  //  glMatrixMode(GL_PROJECTION);
  //  glLoadIdentity();
}


static void
init_GL()
{
  glShadeModel(GL_SMOOTH);
  glClearColor(0, 0, 0, 0);
  glClearDepth(1.0f);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LEQUAL);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

  /* Initialize font */
  ttf_init();
}


void
create(__attribute__ ((unused)) Context_t *ctx)
{
  char *window_title;

  /* Find default output plugin for OpenGL: GLCube */
  /* FIXME hardcoded */
  glcube = Plugins_find(1328382269);
  if (NULL != glcube) {
    printf("[i] glcube found @%p\n", glcube);
    if (NULL != glcube->create)
      glcube->create(ctx);
  }

  /* Information about the current video settings. */
  const SDL_VideoInfo* info = NULL;

  /* Color depth in bits of our window. */
  int bpp = 0;

  /* Flags we will pass into SDL_SetVideoMode. */
  int flags = 0;

  /* First, initialize SDL's video subsystem. */
  if (!SDL_WasInit(SDL_INIT_VIDEO))
    if (SDL_Init(SDL_INIT_VIDEO) < 0) {
      /* Failed, exit. */
      fprintf(stderr, "Video initialization failed: %s\n",
	      SDL_GetError());
      exit(1);
    }

  /* Let's get some video information. */
  info = SDL_GetVideoInfo();

  if (NULL == info) {
    /* This should probably never happen. */
    fprintf(stderr, "Video query failed: %s\n",
	    SDL_GetError());
    exit(1);
  }

  bpp = info->vfmt->BitsPerPixel;

  /*
   * Now, we want to setup our requested
   * window attributes for our OpenGL window.
   * We want *at least* 5 bits of red, green
   * and blue. We also want at least a 16-bit
   * depth buffer.
   *
   * The last thing we do is request a double
   * buffered window. '1' turns on double
   * buffering, '0' turns it off.
   *
   * Note that we do not use SDL_DOUBLEBUF in
   * the flags to SDL_SetVideoMode. That does
   * not affect the GL attribute state, only
   * the standard 2D blitting setup.
   */
  SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
  SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
  SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
  SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

  /*
   * TODO:
   * Make starting windowed an option, and
   * handle the resize events properly with
   * glViewport.
   */
  flags = SDL_OPENGL;
  // flags |= SDL_FULLSCREEN;
  flags |= SDL_GL_DOUBLEBUFFER;
  flags |= SDL_HWPALETTE;
  // flags |= SDL_RESIZABLE;

  if (info->hw_available)
    flags |= SDL_HWSURFACE;
  else
    flags |= SDL_SWSURFACE;

  if (info->blit_hw)
    flags |= SDL_HWACCEL;

  /*
   * Set the video mode
   */
  surface = SDL_SetVideoMode(WIDTH, HEIGHT, bpp, flags);
  if (NULL == surface) {
    fprintf(stderr, "Video mode set failed: %s\n",
	    SDL_GetError());
    exit(1);
  }

  init_GL();

  window_title = g_strdup_printf("Le Biniou OpenGL (%dx%d)", WIDTH, HEIGHT);
  SDL_WM_SetCaption(window_title, NULL);
  g_free(window_title);

#ifdef NO_MOUSE_CURSOR
  SDL_ShowCursor(SDL_DISABLE);
#endif
  SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);

  resize_window(WIDTH, HEIGHT);
}
