/***************************************************************************
                          xmlelementdlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlelementdlg.h"

#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>

XmlElementDlg::XmlElementDlg(QWidget *parent, const char *name, bool modal, bool bHideComboBoxWhereToInsert)
	: XmlElementDlgBase(parent, name, modal)
{
	if(m_strElementName.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);
		
	m_pEditElementName->setFocus();
	m_pPushButtonOk->setDefault(true);
	
	if(bHideComboBoxWhereToInsert)
		{ m_pComboBoxWhereToInsert->hide();
			m_pTextLabelInsert->hide();
		}
}

XmlElementDlg::~XmlElementDlg()
{
}

/** Called, when user press OK button */
void XmlElementDlg::slotOk()
{
	m_strElementName = m_pEditElementName->text();
	//m_strNamespaceURI = m_pEditNamespaceURI->text();
	m_iWhereToInsert = m_pComboBoxWhereToInsert->currentItem();
	accept();
}

/** Called when element name in edit line
is changed */
void XmlElementDlg::slotElementNameChanged(const QString &string)
{
	if(string.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);
}
