/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_dcop.h"
#include <xeobject.h>
#include <xgdocker.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include "xeplugin_dcop.moc"

#include <kxdocker_setup_sources.h>

XEPlugin_DCOPInterface *XEPlugin_DCOP::DCOPInterface;
XEPlugin_DCOP *XEPlugin_DCOPInterface::DockerInterface;

XEPlugin_DCOP::XEPlugin_DCOP(QObject *parent, const char *name)
 : QObject(parent, name)
{
	DCOPInterface=new XEPlugin_DCOPInterface(this);
	xGDocker=NULL;
	XEObject::xPluginAdd(this);

}


XEPlugin_DCOP::~XEPlugin_DCOP()
{
}





XEPlugin_DCOPInterface::XEPlugin_DCOPInterface(XEPlugin_DCOP *dInterface):DCOPObject("docker")
{
	DockerInterface=dInterface;
	functionsList=QStringList();
	functionsList.append("list");
	functionsList.append("exit");
}

QStringList XEPlugin_DCOPInterface::list()
{
	return functionsList;
}

bool XEPlugin_DCOPInterface::exit()
{
	DockerInterface->queryExit();
	return true;
}

XEPlugin_DCOPInterface::~ XEPlugin_DCOPInterface()
{
}

bool XEPlugin_DCOPInterface::changebackground(const QString newpath)
{
	DockerInterface->changeBackground(newpath);
	return true;
}

/*!
    \fn XEPlugin_DCOP::changeBackground(QString newPath)
 */
void XEPlugin_DCOP::changeBackground(const QString newPath)
{
    xGDocker->changeBackground(::locate("data",newPath));
}


/*!
    \fn XEPlugin_DCOP::xSetup()
 */
void XEPlugin_DCOP::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_DCOP::xSetup");
#endif
	XEConfiguration *Configurator=(XEConfiguration*)
			XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

}


/*!
    \fn XEPlugin_DCOPInterface::changeImage(int index,QString newImage)
 */
void XEPlugin_DCOPInterface::changeImage(int index,const QString newImage)
{
	DockerInterface->changeImage(index,newImage);
}


/*!
    \fn XEPlugin_DCOP::changeImage(int index, QString newImage)
 */
void XEPlugin_DCOP::changeImage(int index,const  QString newImage)
{
	ActiveConfiguration->ObjectsIcons.at(index)->Images.imgFileName=newImage;
	xGDocker->reloadIcon(index);
}


/*!
    \fn XEPlugin_DCOP::queryExit()
 */
void XEPlugin_DCOP::queryExit()
{
	xGDocker->close();
}


/*!
    \fn XEPlugin_DCOP::changeText(int index,QString newText)
 */
void XEPlugin_DCOP::changeText(int index,const QString newText)
{
	ActiveConfiguration->ObjectsIcons.at(index)->OverText=newText;
	xGDocker->reloadIcon(index);
}


/*!
    \fn XEPlugin_DCOPInterface::changeText(int index,QString newText)
 */
void XEPlugin_DCOPInterface::changeText(int index,const QString newText)
{
	DockerInterface->changeText(index,newText);
}


/*!
    \fn XEPlugin_DCOPInterface::findIcon(QString iconName)
 */
int XEPlugin_DCOPInterface::findIcon(const QString iconName)
{
	return DockerInterface->findIcon(iconName);
}


/*!
    \fn XEPlugin_DCOP::findIcon(QString iconName)
 */
int XEPlugin_DCOP::findIcon(const QString iconName)
{
	for(uint i =0; i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name
		==iconName)return i;
	}
	
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name
		==iconName)return -2;
	}
	
	return -1;
}


/*!
    \fn XEPlugin_DCOPInterface::addIcon()
 */
void XEPlugin_DCOPInterface::addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass

)
{
	DockerInterface->addIcon(
	newName,
	newImg,
	overText,
	onClickExec,
	className,
	groupName,
	fileName,
	windowTitle,
	taskName,
	taskClass
	);
}


/*!
    \fn XEPlugin_DCOP::addIcon()
 */
void XEPlugin_DCOP::addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass
)
{
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
//	addedCfg->Tasks.PopupMenu=new KPopupMenu();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	
	addedCfg->Tasks.Proces.clear();
	addedCfg->Info.className=className;
	addedCfg->Info.fileName=fileName;
	addedCfg->Info.Name=newName;
	addedCfg->Info.Group=groupName;
	addedCfg->Actions.onClickExec=onClickExec;
	addedCfg->Actions.onDropExec=onClickExec;
	addedCfg->Actions.onDropExec+=" %1";
	addedCfg->OverText=overText;
	addedCfg->Images.imgFileName=newImg;
	
	addedCfg->Tasks.WindowTitle.append(windowTitle);
	addedCfg->Tasks.TaskName.append(taskName);
	addedCfg->Tasks.ClassName.append(taskClass);
	
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.TaskInfo=NULL;
	
	// check for existent icons
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Name==ActiveConfiguration->RollingIcons.at(i)->Info.Name)
		{
			// we only update the image:
			changeImageByName(addedCfg->Info.Name,addedCfg->Images.imgFileName);
			delete addedCfg;
			return;
		}
	}
	
	ActiveConfiguration->RollingIcons.append(addedCfg);
	
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Group==ActiveConfiguration->ObjectsIcons.at(i)->Info.Group)return;
	}
	
	ActiveConfiguration->ObjectsIcons.append(addedCfg);
	xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
}


/*!
    \fn XEPlugin_DCOP::removeIcon(int index)
 */
void XEPlugin_DCOP::removeIcon(int index)
{
	xGDocker->iconRemove(index);
}


/*!
    \fn XEPlugin_DCOPInterface::removeIcon(int index)
 */
void XEPlugin_DCOPInterface::removeIcon(int index)
{
	DockerInterface->removeIcon(index);
}


/*!
    \fn XEPlugin_DCOP::xStop()
 */
void XEPlugin_DCOP::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::xStart()
 */
void XEPlugin_DCOP::xStart()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::xGetParameter(const QString,QString&)
 */
void XEPlugin_DCOP::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::changeImage(QStrtring ImageName,QString newImage)
 */
void XEPlugin_DCOP::changeImageByName(const QString ImageName,const QString newImage)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			ActiveConfiguration->RollingIcons.at(i)->Images.imgFileName=newImage;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)xGDocker->reloadIcon(idx);
			
			return;
		}
	}
	
}


/*!
    \fn XEPlugin_DCOPInterface::changeImage(QStrtring ImageName,QString newImage)
 */
void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName,const QString newImage)
{
    /// @todo implement me
    DockerInterface->changeImageByName(ImageName,newImage);
}


/*!
    \fn XEPlugin_DCOP::changeTextByName(QString iconName,QString newText)
 */
void XEPlugin_DCOP::changeTextByName(const QString iconName,const QString newText)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iconName)
		{
			ActiveConfiguration->RollingIcons.at(i)->OverText=newText;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)xGDocker->reloadIcon(idx);
			
			return;
		}
	}

}
/*!
    \fn XEPlugin_GAppletInterface::changeTextByName(QString iconName,QString newText)
 */
void XEPlugin_DCOPInterface::changeTextByName(const QString iconName,const QString newText)
{
    DockerInterface->changeTextByName(iconName,newText);
}
#include <xeplugin_animator.h>

/*!
    \fn XEPlugin_DCOP::bounceByName(const QString)
 */
void XEPlugin_DCOP::bounceByName(const QString iname)
{
	//qWarning("void XEPlugin_DCOP::bounceByName(const QString iname)");
	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->getObjectIcon(i);
			if(!theIcon)return;
			xAnimator->xAnimateBounce(theIcon);
			return;
		}
	}	
}


/*!
    \fn XEPlugin_DCOPInterface::bounceByName(const QString)
 */
void XEPlugin_DCOPInterface::bounceByName(const QString iname)
{
	DockerInterface->bounceByName(iname);
}


/*!
    \fn XEPlugin_DCOP::rollUpIcon(int)
 */
void XEPlugin_DCOP::rollUpIcon(uint i)
{
	int x,y;
	//if(i<0 || i>ActiveConfiguration->ObjectsIcons.count())return;
	if(i>ActiveConfiguration->ObjectsIcons.count())return;
	XGIcon *xGIcon=xGDocker->getObjectIcon(i);
	if(xGIcon==NULL)return;
	x=xGIcon->xHotspot.x();
	y=xGIcon->xHotspot.y();
	//xGDocker->xEventMouseWheel(i,x,y,2);
	//if(e->delta()>0)b=1;
	QWheelEvent e(QPoint(x,y),-1, 0);
	
	xGDocker->wheelEvent(&e);
}


/*!
    \fn XEPlugin_DCOPInterface::rollUpIcon(int)
 */
void XEPlugin_DCOPInterface::rollUpIcon(int i)
{
    DockerInterface->rollUpIcon(i);
}


/*!
    \fn XEPlugin_DCOP::rollDownIcon(int)
 */
void XEPlugin_DCOP::rollDownIcon(uint i)
{
	int x,y;
	if(i>ActiveConfiguration->ObjectsIcons.count())return;
	XGIcon *xGIcon=xGDocker->getObjectIcon(i);
	if(xGIcon==NULL)return;
	x=xGIcon->xHotspot.x();
	y=xGIcon->xHotspot.y();
	//xGDocker->xEventMouseWheel(i,x,y,2);
	//if(e->delta()>0)b=1;
	QWheelEvent e(QPoint(x,y),+1, 0);
	
	xGDocker->wheelEvent(&e);
}


/*!
    \fn XEPlugin_DCOPInterface::rollDownIcon(int)
 */
void XEPlugin_DCOPInterface::rollDownIcon(int i)
{
    DockerInterface->rollDownIcon(i);
}


/*!
    \fn XEPlugin_DCOP::rollUpIconByName(QString)
 */
void XEPlugin_DCOP::rollUpIconByName(const QString ImageName)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
	if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			// ok than now we have to find the group displayed:
			QString grp=ActiveConfiguration->RollingIcons.at(i)->Info.Group;
		for(uint k=0;k<ActiveConfiguration->ObjectsIcons.count();k++)
		{
		if(ActiveConfiguration->ObjectsIcons.at(k)->Info.Group==grp)
		{
			// got the right icon:
			rollUpIcon(k);
		}
			
		}
		}
	}
}


/*!
    \fn XEPlugin_DCOP::rollDownIconByName(QString)
 */
void XEPlugin_DCOP::rollDownIconByName(const QString ImageName)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
	if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			// ok than now we have to find the group displayed:
			QString grp=ActiveConfiguration->RollingIcons.at(i)->Info.Group;
	for(uint k=0;k<ActiveConfiguration->ObjectsIcons.count();k++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(k)->Info.Group==grp)
		{
			// got the right icon:
			rollDownIcon(k);
		}
			
		}
		}
	}
}


/*!
    \fn XEPlugin_DCOPInterface::rollUpIconByName(QString)
 */
void XEPlugin_DCOPInterface::rollUpIconByName(const QString ImageName)
{
	DockerInterface->rollUpIconByName(ImageName);
}
void XEPlugin_DCOPInterface::addAlias(const QString newAlias)
{
	DockerInterface->addAlias(newAlias);
}


/*!
    \fn XEPlugin_DCOPInterface::rollDownIconByName(QString)
 */
void XEPlugin_DCOPInterface::rollDownIconByName(const QString ImageName)
{
	DockerInterface->rollDownIconByName(ImageName);
}


/*!
    \fn XEPlugin_DCOP::addAlias(QString)
 */
void XEPlugin_DCOP::addAlias(const QString newMount)
{
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
			// searching if it's being showed
			for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
	// if there are too icons, we can exit because no more will be added
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;


			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.className=name();
			
			addedCfg->Tasks.Proces.clear();
			
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
		}
	}
}


/*!
    \fn XEPlugin_DCOP::removeByName(const QString)
 */
void XEPlugin_DCOP::removeByName(const QString iname)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			removeIcon(i);
			//return;
		}
	}	
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iname)
		{
			removeRollingIcon(i);
			//return;
		}
	}
}


/*!
    \fn XEPlugin_DCOPInterface::removeByName(const QString)
 */
void XEPlugin_DCOPInterface::removeByName(const QString iname)
{
    DockerInterface->removeByName(iname);
}


/*!
    \fn XEPlugin_DCOP::removeRollingIcon(uint Index)
 */
void XEPlugin_DCOP::removeRollingIcon(uint Index)
{
    ActiveConfiguration->RollingIcons.remove(Index);
}


/*!
    \fn XEPlugin_DCOP::xGetInfo(QStringList &)
 */
void XEPlugin_DCOP::xGetInfo(QStringList &)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::getPluginParameter(const QString)
 */
QStringList XEPlugin_DCOPInterface::getPluginParameters(const QString a)
{
	return DockerInterface->getPluginParameters(a);
}
QStringList XEPlugin_DCOP::getPluginParameters(const QString a)
{
	bool ok=false;
	QStringList l;
	ok=connect(this, SIGNAL(xGetTargetParameterList(QStringList *)),
		XEObject::xFindObject(a),
		SLOT(xGetParameterList(QStringList *)));
		
	if(ok==false)return l;
	xGetTargetParameterList(&l);

	disconnect(this, SIGNAL(xGetTargetParameterList(QStringList *)),
		XEObject::xFindObject(a),
		SLOT(xGetParameterList(QStringList *)));
	/*
	connect(this, SIGNAL(xGetTargetParameter(const QString,QString&)),
		XEObject::xFindObject(a),
		SLOT(xGetParameter(const QString,QString&)));
		
	for(int i=0;i<l.count();i++)
	{
		
		item->setText(0,a[i]);
		
		QString b;
		xGetParameter(a[i],b);
		
		item->setText(1,b);
		
		
		list->insertItem(item);
	
	}
	disconnect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameter(const QString,QString&)));
	*/
	return l;
}

/*!
    \fn XEPlugin_DCOP::getPluginList()
 */
QStringList XEPlugin_DCOPInterface::getPluginList()
{
	return DockerInterface->getPluginList();
}


/*!
    \fn XEPlugin_DCOP::addPlugin(const QString)
 */
void XEPlugin_DCOPInterface::addPlugin(const QString a)
{
	DockerInterface->addPlugin(a);
}


/*!
    \fn XEPlugin_DCOP::configurePlugin(const QString)
 */
void XEPlugin_DCOPInterface::configurePlugin(const QString a)
{
	DockerInterface->configurePlugin(a);
}


/*!
    \fn XEPlugin_DCOP::hide()
 */
void XEPlugin_DCOPInterface::hide()
{
	DockerInterface->hide();
}


/*!
    \fn XEPlugin_DCOP::startPluginIconByName(const QString)
 */
void XEPlugin_DCOPInterface::startPluginIconByName(const QString a)
{
	DockerInterface->startPluginIconByName(a);
}


/*!
    \fn XEPlugin_DCOP::removePlugin(const QString)
 */
void XEPlugin_DCOPInterface::removePlugin(const QString a)
{
	DockerInterface->removePlugin(a);
}


/*!
    \fn XEPlugin_DCOP::setPluginParameter(const QString, const QString)
 */
void XEPlugin_DCOPInterface::setPluginParameter(
const QString a, const QString b, const QString c)
{
	DockerInterface->setPluginParameter(a,b,c);
}


/*!
    \fn XEPlugin_DCOP::show()
 */
void XEPlugin_DCOPInterface::show()
{
	DockerInterface->show();
}


/*!
    \fn XEPlugin_DCOP::startPlugin(const QString)
 */
void XEPlugin_DCOPInterface::startPlugin(const QString a)
{
	DockerInterface->startPlugin(a);
}


/*!
    \fn XEPlugin_DCOP::stopPlugin(const QString)
 */
void XEPlugin_DCOPInterface::stopPlugin(const QString a)
{
	DockerInterface->stopPlugin(a);
}


/*!
    \fn XEPlugin_DCOP::getPluginList()
 */
QStringList XEPlugin_DCOP::getPluginList()
{
	QStringList a;
	for(int i=ActiveConfiguration->Plugins.Plugin.count()-1; i>=0;i--)
	{
		XSGObjectPlugin	*theplugin=ActiveConfiguration->Plugins.Plugin.at(i);
	
		a.append(theplugin->Info.Name);
	}
	return a;
}


/*!
    \fn XEPlugin_DCOP::addPlugin(const QString)
 */
void XEPlugin_DCOP::addPlugin(const QString a)
{
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator !=NULL)
	{
		Configurator->pluginAdd(a);
	}

}


/*!
    \fn XEPlugin_DCOP::configurePlugin(const QString)
 */
void XEPlugin_DCOP::configurePlugin(const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::hide()
 */
void XEPlugin_DCOP::hide()
{
	xGDocker->hide();
}


/*!
    \fn XEPlugin_DCOP::startPluginIconByName(const QString)
 */
void XEPlugin_DCOP::startPluginIconByName(const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::removePlugin(const QString)
 */
void XEPlugin_DCOP::removePlugin(const QString a)
{
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator !=NULL)
	{
		Configurator->pluginRemove(a);
	}
}


/*!
    \fn XEPlugin_DCOP::setPluginParameter(const QString, const QString)
 */
void XEPlugin_DCOP::setPluginParameter(const QString a, const QString b, const QString c)
{
	bool ok=false;
		// ok we are going on the same route
	ok=connect(this, SIGNAL(xTargetSetupParameter(const QString,const QString)),
		XEObject::xFindObject(a),
		SLOT(xSetupParameter(const QString,const QString)));
	if(ok)
	{
		xTargetSetupParameter(b,c);
	disconnect(this, SIGNAL(xTargetSetupParameter(const QString,const QString)),
		XEObject::xFindObject(a),
		SLOT(xSetupParameter(const QString,const QString)));
	}
}


/*!
    \fn XEPlugin_DCOP::show()
 */
void XEPlugin_DCOP::show()
{
    xGDocker->show();
}


/*!
    \fn XEPlugin_DCOP::startPlugin(const QString)
 */
void XEPlugin_DCOP::startPlugin(const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::stopPlugin(const QString)
 */
void XEPlugin_DCOP::stopPlugin(const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_DCOP::xStopAnimateBackground()
 */
void XEPlugin_DCOP::xStopAnimateBackground()
{
	xGDocker->xStopAnimateBackground();
}


/*!
    \fn XEPlugin_DCOP::xStartAnimateBackground()
 */
void XEPlugin_DCOP::xStartAnimateBackground()
{
	xGDocker->xStartAnimateBackground();
}


/*!
    \fn XEPlugin_DCOPInterface::xStopAnimateBackground()
 */
void XEPlugin_DCOPInterface::stopAnimateBackground()
{
	DockerInterface->xStopAnimateBackground();
}


/*!
    \fn XEPlugin_DCOPInterface::xStartAnimateBackground()
 */
void XEPlugin_DCOPInterface::startAnimateBackground()
{
	DockerInterface->xStartAnimateBackground();
}


/*!
    \fn XEPlugin_DCOP::stopBounceByName(const QString)
 */
void XEPlugin_DCOP::stopBounceByName(const QString iname)
{
	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->getObjectIcon(i);
			if(!theIcon)return;
			xAnimator->xStopAnimate();
			return;
		}
	}
}


/*!
    \fn XEPlugin_DCOP::startBounceByName(const QString)
 */
void XEPlugin_DCOP::startBounceByName(const QString iname)
{
	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->getObjectIcon(i);
			if(!theIcon)return;
			xAnimator->xStartAnimate(theIcon);
			return;
		}
	}
}


/*!
    \fn XEPlugin_DCOPInterface::stopBounceByName(const QString)
 */
void XEPlugin_DCOPInterface::stopBounceByName(const QString i)
{
DockerInterface->stopBounceByName(i);
}


/*!
    \fn XEPlugin_DCOPInterface::startBounceByName(const QString)
 */
void XEPlugin_DCOPInterface::startBounceByName(const QString i)
{
DockerInterface->startBounceByName(i);
}


int XEPlugin_DCOP::getRunningByName(const QString iname)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			return ActiveConfiguration->ObjectsIcons.at(i)->Tasks.forceRunning;
		}
	}
	return -1;
}


void XEPlugin_DCOP::setRunningByName(const QString iname,int isRunning)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			ActiveConfiguration->ObjectsIcons.at(i)->Tasks.forceRunning=isRunning;
			xGDocker->xUpdateRepaint(i);
			return;
		}
	}
}

int XEPlugin_DCOPInterface::getRunningByName(const QString iname)
{
 return DockerInterface->getRunningByName(iname);
}

void XEPlugin_DCOPInterface::setRunningByName(const QString iname, int i)
{
DockerInterface->setRunningByName(iname, i);
}


/*!
    \fn XEPlugin_DCOP::changeImage(int, QPixmap)
 */
void XEPlugin_DCOP::changeImage(int index, QPixmap newImage)
{
	XGIcon *Icona=xGDocker->getObjectIcon(index);
	if(Icona==NULL)return;
	Icona->xImgSource=newImage.convertToImage();
	Icona->xImgOriginal=Icona->xImgSource;
	Icona->cachePurge();
	Icona->xSetSmoothZoom();
	xGDocker->xDockerRedraw(Icona);
}


/*!
    \fn XEPlugin_DCOP::changeImage(const QString, QPixmap)
 */
void XEPlugin_DCOP::changeImage(const QString ImageName, QPixmap newImage)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==ImageName)
		{
			changeImage(i,newImage);
			return;
		}
	}
}


/*!
    \fn XEPlugin_DCOP::changeImage(int, QImage)
 */
void XEPlugin_DCOP::changeImage(int index, QImage newImage)
{
	XGIcon *Icona=xGDocker->getObjectIcon(index);
	if(Icona==NULL)return;
	Icona->xImgSource=newImage;
	Icona->xImgOriginal=Icona->xImgSource;
	Icona->cachePurge();
	Icona->xSetSmoothZoom();
	xGDocker->xDockerRedraw(Icona);
}


/*!
    \fn XEPlugin_DCOP::changeImage(const QString, QImage)
 */
void XEPlugin_DCOP::changeImage(const QString ImageName, QImage newImage)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==ImageName)
		{
			changeImage(i,newImage);
			return;
		}
	}
}
















void XEPlugin_DCOPInterface::changeImage(int index, QPixmap newImage)
{
	DockerInterface->changeImage(index,newImage);
}


void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName, QPixmap newImage)
{
	DockerInterface->changeImage(ImageName,newImage);
}


void XEPlugin_DCOPInterface::changeImage(int index, QImage newImage)
{
	DockerInterface->changeImage(index,newImage);
}


void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName, QImage newImage)
{
	DockerInterface->changeImage(ImageName,newImage);
}

